/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.views.displays;

import gama.core.common.interfaces.IDisplaySurface;
import gama.core.common.interfaces.IOverlayProvider;
import gama.core.common.interfaces.IUpdaterTarget;
import gama.core.outputs.LayeredDisplayOutput;
import gama.core.outputs.layers.OverlayStatement;
import gama.core.runtime.GAMA;
import gama.dev.DEBUG;
import gama.gaml.operators.Maths;
import gama.ui.experiment.views.displays.LayeredDisplayView;
import gama.ui.experiment.views.displays.ThreadedOverlayUpdater;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.IGamaColors;
import gama.ui.shared.utils.WorkbenchHelper;
import java.awt.Color;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;

public class DisplayOverlay
implements IUpdaterTarget<OverlayStatement.OverlayInfo> {
    Label coord;
    Label zoom;
    Label left;
    Label middle;
    Label right;
    Canvas scalebar;
    volatile boolean isBusy;
    private final Shell popup;
    private boolean visible = false;
    final LayeredDisplayView view;
    protected final Composite referenceComposite;
    final boolean createExtraInfo;
    Timer timer = new Timer();
    OverlayListener listener = new OverlayListener();
    protected final MouseListener toggleListener = new MouseAdapter(){

        public void mouseUp(MouseEvent mouseEvent) {
            DisplayOverlay.this.setVisible(false);
        }
    };

    static {
        DEBUG.OFF();
    }

    public DisplayOverlay(LayeredDisplayView layeredDisplayView, Composite composite, IOverlayProvider<OverlayStatement.OverlayInfo> iOverlayProvider) {
        this.createExtraInfo = iOverlayProvider != null;
        this.view = layeredDisplayView;
        this.referenceComposite = composite;
        this.popup = new Shell(composite.getShell(), 524296);
        this.popup.setAlpha(140);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        fillLayout.spacing = 10;
        this.popup.setLayout((Layout)fillLayout);
        this.popup.setBackground(GamaColors.toSwtColor((Color)layeredDisplayView.getDisplaySurface().getData().getBackgroundColor().darker().darker()));
        this.createPopupControl();
        this.popup.setAlpha(140);
        this.popup.layout();
        composite.getShell().addShellListener((ShellListener)this.listener);
        composite.addControlListener((ControlListener)this.listener);
        if (iOverlayProvider != null) {
            iOverlayProvider.setTarget((IUpdaterTarget)new ThreadedOverlayUpdater(this), layeredDisplayView.getDisplaySurface());
        }
        this.timer.schedule((TimerTask)new FPSTask(), 0L, 1000L);
    }

    protected void createPopupControl() {
        Shell shell = this.getPopup();
        GridLayout gridLayout = new GridLayout(3, true);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        shell.setLayout((Layout)gridLayout);
        if (this.createExtraInfo) {
            this.left = new Label((Composite)shell, 16384);
            this.middle = new Label((Composite)shell, 0x1000000);
            this.right = new Label((Composite)shell, 131072);
        }
        this.coord = new Label((Composite)shell, 16384);
        this.zoom = new Label((Composite)shell, 0x1000000);
        this.scalebar = new Canvas((Composite)shell, 0);
        this.scalebar.setVisible(true);
        GridData gridData = new GridData(131072, 0x1000000, true, false);
        gridData.minimumWidth = 140;
        gridData.widthHint = 140;
        gridData.minimumHeight = 24;
        gridData.heightHint = 24;
        this.scalebar.setLayoutData((Object)gridData);
        this.scalebar.setBackground(shell.getBackground());
        this.scalebar.addPaintListener(paintEvent -> this.paintScale(paintEvent.gc));
        shell.addMouseListener(this.toggleListener);
        this.scalebar.addMouseListener(this.toggleListener);
        shell.layout();
    }

    void paintScale(GC gC) {
        gC.setBackground(IGamaColors.BLACK.color());
        int n = this.scalebar.getBounds().width - 40;
        int n2 = this.scalebar.getBounds().height;
        int n3 = 0 + n2 - 4;
        Path path = new Path((Device)WorkbenchHelper.getDisplay());
        path.moveTo(21.0f, (float)(n3 - 8 + 2));
        path.lineTo(21.0f, (float)(n3 + 2));
        path.moveTo(21.0f, (float)(n3 - 4 + 2));
        path.lineTo((float)(21 + n), (float)(n3 - 4 + 2));
        path.moveTo((float)(21 + n), (float)(n3 - 8 + 2));
        path.lineTo((float)(21 + n), (float)(n3 + 2));
        gC.setForeground(IGamaColors.WHITE.color());
        gC.setLineStyle(1);
        gC.setLineWidth(1);
        gC.drawPath(path);
        gC.setFont(this.coord.getFont());
        this.drawStringCentered(gC, "0", 21, n3 - 6);
        this.drawStringCentered(gC, this.getScaleRight(), 21 + n, n3 - 6);
        path.dispose();
    }

    private String getScaleRight() {
        double d = this.getValueOfOnePixelInModelUnits() * 100.0;
        if (d > 1000.0) {
            return String.format("%.1fkm", d / 1000.0);
        }
        if (d < 0.001) {
            return String.format("%dmm", (int)d * 1000);
        }
        if (d < 0.01) {
            return String.format("%dcm", (int)(d * 100.0));
        }
        return String.format("%dm", (int)d);
    }

    public boolean isBusy() {
        return this.isBusy;
    }

    public void update() {
        if (this.isBusy) {
            return;
        }
        this.isBusy = true;
        try {
            if (this.getPopup().isDisposed()) {
                return;
            }
            if (!this.coord.isDisposed()) {
                try {
                    this.getOverlayCoordInfo(this.coord.text);
                    this.coord.redraw();
                }
                catch (Exception exception) {
                    this.coord.setText("Not initialized yet");
                }
            }
            if (!this.zoom.isDisposed()) {
                try {
                    this.getOverlayZoomInfo(this.zoom.text);
                    this.zoom.redraw();
                }
                catch (Exception exception) {
                    this.zoom.setText("Not initialized yet");
                }
            }
            if (!this.scalebar.isDisposed()) {
                this.scalebar.redraw();
            }
            this.getPopup().layout(true);
        }
        finally {
            this.isBusy = false;
        }
    }

    protected Point getLocation() {
        Rectangle rectangle = this.referenceComposite.getClientArea();
        Point point = this.referenceComposite.toDisplay(rectangle.x, rectangle.y);
        int n = point.x;
        int n2 = point.y + rectangle.height - (this.createExtraInfo ? 56 : 32);
        DEBUG.OUT((Object)("Location of overlay = " + n + " " + n2 + " <> client area dans Display : " + String.valueOf(rectangle)));
        return new Point(n, n2);
    }

    protected Point getSize() {
        Point point = this.referenceComposite.getSize();
        return new Point(point.x, -1);
    }

    private void drawStringCentered(GC gC, String string, int n, int n2) {
        Point point = gC.textExtent(string);
        int n3 = n - point.x / 2;
        gC.drawText(string, n3, n2 - point.y, true);
    }

    private void setForeground(Label label, org.eclipse.swt.graphics.Color color) {
        if (label == null || label.isDisposed()) {
            return;
        }
        org.eclipse.swt.graphics.Color color2 = label.getForeground();
        label.setForeground(color);
        if (color2 != IGamaColors.WHITE.color() && color2 != color) {
            color2.dispose();
        }
    }

    public void updateWith(OverlayStatement.OverlayInfo overlayInfo) {
        String[] stringArray = overlayInfo.infos;
        List list = overlayInfo.colors;
        if (stringArray[0] != null) {
            if (list != null) {
                this.setForeground(this.left, GamaColors.get((int[])((int[])list.get(0))).color());
            }
            this.left.setText(stringArray[0]);
        }
        if (stringArray[1] != null) {
            if (list != null) {
                this.setForeground(this.middle, GamaColors.get((int[])((int[])list.get(1))).color());
            }
            this.middle.setText(stringArray[1]);
        }
        if (stringArray[2] != null) {
            if (list != null) {
                this.setForeground(this.right, GamaColors.get((int[])((int[])list.get(2))).color());
            }
            this.right.setText(stringArray[2]);
        }
        this.getPopup().layout(true);
    }

    public void resume() {
    }

    public Shell getPopup() {
        return this.popup;
    }

    public void display() {
        if (!this.isVisible() || this.popup.isDisposed()) {
            return;
        }
        this.update();
        this.relocate();
        this.resize();
        if (!this.popup.isVisible()) {
            this.popup.setVisible(true);
        }
    }

    public void relocate() {
        if (!this.isVisible()) {
            return;
        }
        if (!this.popup.isDisposed()) {
            this.popup.setLocation(this.getLocation());
        }
    }

    public void resize() {
        if (!this.isVisible()) {
            return;
        }
        if (!this.popup.isDisposed()) {
            Point point = this.getSize();
            this.popup.setSize(this.popup.computeSize(point.x, point.y));
            DEBUG.OUT((Object)("Size of overlay = " + this.popup.getSize().x + " " + this.popup.getSize().y));
        }
    }

    public void hide() {
        if (!this.popup.isDisposed() && this.popup.isVisible()) {
            this.popup.setSize(0, 0);
            this.popup.update();
            this.popup.setVisible(false);
        }
    }

    public boolean isDisposed() {
        return this.popup.isDisposed() || this.viewIsDetached();
    }

    public void close() {
        if (!this.popup.isDisposed()) {
            if (this.referenceComposite != null && !this.referenceComposite.isDisposed()) {
                this.referenceComposite.removeControlListener((ControlListener)this.listener);
            }
            if (!this.popup.getParent().isDisposed()) {
                this.popup.getParent().removeControlListener((ControlListener)this.listener);
                this.popup.getParent().getShell().removeShellListener((ShellListener)this.listener);
            }
            this.timer.cancel();
            this.popup.dispose();
        }
    }

    public boolean isVisible() {
        return this.visible && !this.isDisposed();
    }

    private boolean viewIsDetached() {
        boolean[] blArray = new boolean[1];
        WorkbenchHelper.run(() -> {
            IWorkbenchPartSite iWorkbenchPartSite = this.view.getSite();
            if (iWorkbenchPartSite == null) {
                return;
            }
            Shell shell = iWorkbenchPartSite.getShell();
            if (shell == null) {
                return;
            }
            String string = shell.getText();
            blArray[0] = string == null || string.isEmpty();
        });
        return blArray[0];
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
        if (!bl) {
            this.hide();
        } else if (!this.viewIsDetached()) {
            this.display();
        }
    }

    public void dispose() {
        this.popup.dispose();
    }

    public double getValueOfOnePixelInModelUnits() {
        IDisplaySurface iDisplaySurface = this.view.getDisplaySurface();
        if (iDisplaySurface == null) {
            return 1.0;
        }
        double d = iDisplaySurface.getDisplayWidth();
        double d2 = iDisplaySurface.getEnvWidth();
        return d2 / d;
    }

    public void getOverlayCoordInfo(StringBuilder stringBuilder) {
        LayeredDisplayOutput layeredDisplayOutput = this.view.getOutput();
        if (layeredDisplayOutput == null) {
            return;
        }
        stringBuilder.setLength(0);
        boolean bl = layeredDisplayOutput.isPaused();
        boolean bl2 = GAMA.isSynchronized();
        IDisplaySurface iDisplaySurface = this.view.getDisplaySurface();
        if (iDisplaySurface != null) {
            iDisplaySurface.getModelCoordinatesInfo(stringBuilder);
        }
        if (bl) {
            stringBuilder.append(" | Paused");
        }
        if (bl2) {
            stringBuilder.append(" | Synchronized");
        }
    }

    public void getOverlayZoomInfo(StringBuilder stringBuilder) {
        Double d;
        IDisplaySurface iDisplaySurface = this.view.getDisplaySurface();
        if (iDisplaySurface == null) {
            return;
        }
        stringBuilder.setLength(0);
        stringBuilder.append(iDisplaySurface.getFPS());
        stringBuilder.append(" fps | ");
        int n = 0;
        if (this.view.getOutput() != null) {
            d = this.view.getOutput().getData().getZoomLevel();
            n = d == null ? 1 : (int)(d * 100.0);
        }
        stringBuilder.append("Zoom ").append(n).append("%");
        if (this.view.isOpenGL() && (d = ((IDisplaySurface.OpenGL)iDisplaySurface).getROIDimensions()) != null) {
            stringBuilder.append(" ROI [");
            stringBuilder.append(Maths.round((Double)d.getWidth(), (Integer)2));
            stringBuilder.append(" x ");
            stringBuilder.append(Maths.round((Double)d.getHeight(), (Integer)2));
            stringBuilder.append("]");
        }
    }

    public class FPSTask
    extends TimerTask {
        @Override
        public void run() {
            WorkbenchHelper.asyncRun(() -> {
                if (!DisplayOverlay.this.zoom.isDisposed()) {
                    DisplayOverlay.this.zoom.redraw();
                }
            });
        }
    }

    class Label
    extends Canvas {
        final int alignment;
        final StringBuilder text;
        final GridData data;

        public Label(Composite composite, int n) {
            super(composite, 0);
            this.text = new StringBuilder();
            this.setVisible(true);
            this.alignment = n;
            this.addPaintListener(paintEvent -> this.paint(paintEvent.gc));
            this.data = this.infoData(n);
            this.setLayoutData(this.data);
            GamaColors.setBackAndForeground((org.eclipse.swt.graphics.Color)composite.getBackground(), (org.eclipse.swt.graphics.Color)IGamaColors.WHITE.color(), (Control[])new Control[]{this});
            this.addMouseListener(DisplayOverlay.this.toggleListener);
        }

        private GridData infoData(int n) {
            GridData gridData = new GridData(n, 0x1000000, true, false);
            gridData.minimumHeight = 24;
            gridData.heightHint = 24;
            gridData.minimumWidth = 140;
            gridData.widthHint = 140;
            return gridData;
        }

        public void setWidth(int n) {
            if (n <= this.data.minimumWidth) {
                return;
            }
            this.data.minimumWidth = n;
            this.data.widthHint = n;
            this.getParent().requestLayout();
        }

        private void paint(GC gC) {
            int n = this.getBounds().width;
            gC.setForeground(IGamaColors.WHITE.color());
            String string = this.text.toString();
            Point point = gC.stringExtent(string);
            if (point.x > n) {
                this.setWidth(point.x);
                return;
            }
            int n2 = this.getBounds().height;
            int n3 = (n2 - point.y) / 2;
            int n4 = switch (this.alignment) {
                case 131072 -> n - point.x;
                case 0x1000000 -> (n - point.x) / 2;
                default -> 0;
            };
            gC.drawString(string, n4, n3, true);
        }

        public void setText(String string) {
            this.text.setLength(0);
            this.text.append(string);
            this.redraw();
        }
    }

    class OverlayListener
    extends ShellAdapter
    implements ControlListener {
        OverlayListener() {
        }

        public void controlMoved(ControlEvent controlEvent) {
            DisplayOverlay.this.relocate();
            DisplayOverlay.this.resize();
        }

        public void controlResized(ControlEvent controlEvent) {
            DisplayOverlay.this.relocate();
            DisplayOverlay.this.resize();
        }

        public void shellClosed(ShellEvent shellEvent) {
            DisplayOverlay.this.close();
        }
    }
}

