/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.views.inspectors;

import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.kernel.experiment.ParameterAdapter;
import gama.core.metamodel.agent.IAgent;
import gama.core.outputs.IOutput;
import gama.core.outputs.InspectDisplayOutput;
import gama.core.runtime.IScope;
import gama.gaml.types.Types;
import gama.ui.experiment.menus.AgentsMenu;
import gama.ui.experiment.parameters.AgentAttributesEditorsList;
import gama.ui.experiment.views.inspectors.AttributesEditorsView;
import gama.ui.shared.controls.FlatButton;
import gama.ui.shared.controls.ParameterExpandBar;
import gama.ui.shared.controls.ParameterExpandItem;
import gama.ui.shared.menus.MenuAction;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.IGamaColors;
import gama.ui.shared.views.toolbar.IToolbarDecoratedView;
import gama.ui.shared.views.toolbar.Selector;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class AgentInspectView
extends AttributesEditorsView<IAgent>
implements IToolbarDecoratedView.Pausable {
    public static final String ID = "gama.ui.application.view.AgentInspectView";
    public String firstPartName = null;

    public void addOutput(IOutput iOutput) {
        if (iOutput == null) {
            this.reset();
            return;
        }
        if (!(iOutput instanceof InspectDisplayOutput)) {
            return;
        }
        InspectDisplayOutput inspectDisplayOutput = (InspectDisplayOutput)iOutput;
        IAgent[] iAgentArray = inspectDisplayOutput.getLastValue();
        if (iAgentArray == null || iAgentArray.length == 0) {
            this.reset();
            return;
        }
        IAgent iAgent = iAgentArray[0];
        if (this.getParentComposite() == null) {
            super.addOutput((IOutput)inspectDisplayOutput);
        } else if (this.editors == null || !this.editors.getSections().containsKey(iAgent)) {
            super.addOutput((IOutput)inspectDisplayOutput);
            this.addItem(iAgent);
        }
    }

    public void ownCreatePartControl(Composite composite) {
        IAgent[] iAgentArray;
        composite.setBackground(composite.getBackground());
        if (!this.outputs.isEmpty() && (iAgentArray = this.getOutput().getLastValue()) != null && iAgentArray.length > 0) {
            IAgent[] iAgentArray2 = iAgentArray;
            int n = iAgentArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAgent iAgent = iAgentArray2[n2];
                this.addItem(iAgent);
                ++n2;
            }
        }
    }

    public InspectDisplayOutput getOutput() {
        return (InspectDisplayOutput)super.getOutput();
    }

    public boolean areItemsClosable() {
        return true;
    }

    public Label createLeftLabel(Composite composite, String string, String string2, boolean bl) {
        Label label = new Label(composite, 131136);
        label.setBackground(composite.getBackground());
        label.setForeground(GamaColors.getTextColorForBackground((Color)composite.getBackground()).color());
        GridData gridData = new GridData(0x1000008, 0x1000000, true, true);
        gridData.minimumWidth = 70;
        gridData.horizontalIndent = bl ? 30 : 0;
        label.setLayoutData((Object)gridData);
        label.setText(string);
        label.setToolTipText(string2);
        return label;
    }

    @Override
    protected Composite createItemContentsFor(IAgent iAgent) {
        Composite composite = super.createItemContentsFor(iAgent);
        this.createLeftLabel(composite, "Actions", "", false);
        Composite composite2 = new Composite(composite, 0);
        composite2.setBackground(composite.getBackground());
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.minimumWidth = 150;
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 5;
        composite2.setLayout((Layout)gridLayout);
        FlatButton flatButton = FlatButton.menu((Composite)composite2, (GamaColors.GamaUIColor)IGamaColors.BLUE, (String)"Select...");
        flatButton.addSelectionListener((SelectionListener)((Selector)selectionEvent -> {
            Menu menu = new Menu((Control)flatButton);
            AgentsMenu.createMenuForAgent(menu, iAgent, iAgent instanceof ITopLevelAgent, false, new MenuAction[0]);
            menu.setVisible(true);
        }));
        return composite;
    }

    public boolean addItem(IAgent iAgent) {
        if (this.editors == null) {
            this.editors = new AgentAttributesEditorsList();
        }
        this.updatePartName();
        if (!this.editors.getSections().containsKey(iAgent)) {
            ((AgentAttributesEditorsList)this.editors).add(this.getParametersToInspect(iAgent), iAgent);
            ParameterExpandItem parameterExpandItem = this.createItem(this.getParentComposite(), iAgent, true, null);
            return parameterExpandItem != null;
        }
        return false;
    }

    protected ParameterExpandItem buildConcreteItem(ParameterExpandBar parameterExpandBar, IAgent iAgent, GamaColors.GamaUIColor gamaUIColor) {
        return new ParameterExpandItem(parameterExpandBar, (Object)iAgent, 0, 0, gamaUIColor);
    }

    private List<IParameter> getParametersToInspect(IAgent iAgent) {
        Map map = this.getOutput().getAttributes();
        if (map == null) {
            return new ArrayList<IParameter>(iAgent.getSpecies().getVars());
        }
        ArrayList<IParameter> arrayList = new ArrayList<IParameter>();
        for (String string : map.keySet()) {
            if (iAgent.getSpecies().getVar(string) != null) {
                arrayList.add((IParameter)iAgent.getSpecies().getVar(string));
                continue;
            }
            arrayList.add(this.buildAttribute(iAgent, string, (String)map.get(string)));
        }
        return arrayList;
    }

    private IParameter buildAttribute(final IAgent iAgent, final String string, String string2) {
        return new ParameterAdapter(string, Types.get((String)string2).id()){

            public void setValue(IScope iScope, Object object) {
                iAgent.setAttribute(string, object);
            }

            public boolean isEditable() {
                return true;
            }

            public boolean isDefined() {
                return true;
            }

            public Object value() {
                return iAgent.getAttribute(string);
            }
        };
    }

    @Override
    public void removeItem(IAgent iAgent) {
        InspectDisplayOutput inspectDisplayOutput = null;
        for (IOutput iOutput : this.outputs) {
            InspectDisplayOutput inspectDisplayOutput2 = (InspectDisplayOutput)iOutput;
            IAgent[] iAgentArray = inspectDisplayOutput2.getLastValue();
            if (iAgentArray == null || iAgentArray.length <= 0 || iAgentArray[0] != iAgent) continue;
            inspectDisplayOutput = inspectDisplayOutput2;
            break;
        }
        if (inspectDisplayOutput != null) {
            inspectDisplayOutput.close();
            this.removeOutput((IOutput)inspectDisplayOutput);
        }
        this.updatePartName();
        super.removeItem(iAgent);
    }

    public void updatePartName() {
        Object object;
        if (this.firstPartName == null) {
            object = this.getOutput();
            this.firstPartName = object == null ? "Inspect: " : object.getName();
        }
        object = new LinkedHashSet();
        for (IOutput iOutput : this.outputs) {
            InspectDisplayOutput inspectDisplayOutput = (InspectDisplayOutput)iOutput;
            IAgent iAgent = inspectDisplayOutput.getLastValue()[0];
            if (iAgent == null) continue;
            object.add(iAgent.getName());
        }
        this.setPartName(this.firstPartName + " " + (object.isEmpty() ? "" : object.toString()));
    }

    public void pauseChanged() {
    }

    public Map<String, Runnable> handleMenu(IAgent iAgent, int n, int n2) {
        return null;
    }
}

