/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.views.inspectors;

import gama.core.common.interfaces.IGamaView;
import gama.core.common.interfaces.ITopLevelAgentChangeListener;
import gama.core.common.preferences.GamaPreferences;
import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.outputs.MonitorOutput;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.util.GamaColor;
import gama.dev.COUNTER;
import gama.dev.DEBUG;
import gama.ui.experiment.parameters.EditorsList;
import gama.ui.experiment.parameters.ExperimentsParametersList;
import gama.ui.experiment.views.inspectors.AttributesEditorsView;
import gama.ui.shared.controls.ParameterExpandItem;
import gama.ui.shared.interfaces.IParameterEditor;
import gama.ui.shared.parameters.EditorsGroup;
import gama.ui.shared.parameters.MonitorDisplayer;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.shared.views.GamaViewPart;
import gama.ui.shared.views.toolbar.GamaToolbar2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolItem;

public class ExperimentParametersView
extends AttributesEditorsView<String>
implements IGamaView.Parameters {
    private static final String MONITOR_SECTION_NAME = "Monitors";
    public static final String ID = "gama.ui.application.view.ParameterView";
    public static final int REVERT = 0;
    ITopLevelAgent agent;
    ParameterExpandItem monitorSection;
    ToolItem status;

    static {
        DEBUG.ON();
    }

    public ExperimentParametersView() {
        GAMA.registerTopLevelAgentChangeListener((ITopLevelAgentChangeListener)this);
    }

    public void ownCreatePartControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 5;
        composite2.setLayout((Layout)gridLayout);
        this.setParentComposite(composite2);
    }

    ExperimentsParametersList getEditorsList() {
        return (ExperimentsParametersList)this.editors;
    }

    @Override
    public List<String> getItems() {
        EditorsList editorsList = this.editors;
        if (!(editorsList instanceof ExperimentsParametersList)) {
            return Collections.EMPTY_LIST;
        }
        ExperimentsParametersList experimentsParametersList = (ExperimentsParametersList)editorsList;
        return experimentsParametersList.getItems();
    }

    public void displayItems() {
        WorkbenchHelper.run(() -> {
            super.displayItems();
            this.createMonitorSectionIfNeeded(false);
            Map<MonitorOutput, MonitorDisplayer> map = this.getEditorsList().getMonitors();
            map.forEach((monitorOutput, monitorDisplayer) -> {
                monitorDisplayer.createControls((EditorsGroup)this.monitorSection.getControl());
                monitorDisplayer.setCloser(() -> this.deleteMonitor((MonitorDisplayer)monitorDisplayer));
            });
        });
        this.updateToolbar();
    }

    private void updateToolbar() {
        ITopLevelAgent iTopLevelAgent = GAMA.getCurrentTopLevelAgent();
        if (iTopLevelAgent != null) {
            WorkbenchHelper.asyncRun(() -> {
                if (this.toolbar != null && !this.toolbar.isDisposed()) {
                    this.toolbar.status(GamaIcon.ofColor((GamaColor)iTopLevelAgent.getColor()).getCode(), "Parameters for " + iTopLevelAgent.getFamilyName() + " " + iTopLevelAgent.getName());
                }
            });
        } else {
            WorkbenchHelper.asyncRun(() -> {
                if (this.toolbar != null && !this.toolbar.isDisposed()) {
                    this.toolbar.wipe(16384, true);
                }
            });
        }
    }

    private void deleteMonitorSectionIfEmpty() {
        if (this.monitorSection == null || this.getEditorsList().hasMonitors() || this.getEditorsList().getItems().contains(MONITOR_SECTION_NAME)) {
            return;
        }
        this.monitorSection.dispose();
        this.monitorSection = null;
    }

    private void createMonitorSectionIfNeeded(boolean bl) {
        if (this.monitorSection != null || !((Boolean)GamaPreferences.Runtime.CORE_MONITOR_PARAMETERS.getValue()).booleanValue() || !bl && !this.getEditorsList().hasMonitors()) {
            return;
        }
        EditorsGroup editorsGroup = (EditorsGroup)this.createItemContentsFor(MONITOR_SECTION_NAME);
        Composite composite = this.getParentComposite();
        boolean bl2 = this.editors.getItemExpanded(MONITOR_SECTION_NAME);
        GamaColors.GamaUIColor gamaUIColor = GamaColors.get((java.awt.Color)this.editors.getItemDisplayColor(MONITOR_SECTION_NAME));
        this.monitorSection = this.createItem(composite, MONITOR_SECTION_NAME, MONITOR_SECTION_NAME, (Composite)editorsGroup, this.getViewer(), bl2, gamaUIColor);
    }

    private void createNewMonitor() {
        this.createMonitorSectionIfNeeded(true);
        IScope iScope = GAMA.getRuntimeScope();
        MonitorOutput monitorOutput = new MonitorOutput(iScope, "Monitor " + String.valueOf(COUNTER.COUNT()), null);
        MonitorDisplayer monitorDisplayer = this.getEditorsList().addMonitor(GAMA.getCurrentTopLevelAgent().getScope(), monitorOutput);
        monitorDisplayer.createControls((EditorsGroup)this.monitorSection.getControl());
        this.monitorSection.setHeight(this.monitorSection.getControl().computeSize((int)-1, (int)-1).y);
        monitorDisplayer.setCloser(() -> this.deleteMonitor(monitorDisplayer));
    }

    private void deleteMonitor(MonitorDisplayer monitorDisplayer) {
        MonitorOutput monitorOutput = (MonitorOutput)monitorDisplayer.getStatement();
        monitorOutput.close();
        this.getEditorsList().removeMonitor(monitorOutput);
        monitorDisplayer.dispose();
        this.monitorSection.setHeight(this.monitorSection.getControl().computeSize((int)-1, (int)-1).y);
        this.deleteMonitorSectionIfEmpty();
    }

    @Override
    protected Composite createItemContentsFor(String string) {
        Map<String, IParameterEditor<?>> map = this.editors.getSections().get(string);
        this.createViewer(this.getParentComposite());
        EditorsGroup editorsGroup = new EditorsGroup((Composite)this.getViewer());
        if (map != null) {
            ArrayList arrayList = new ArrayList(map.values());
            Collections.sort(arrayList);
            for (IParameterEditor iParameterEditor : arrayList) {
                iParameterEditor.createControls(editorsGroup);
                if (this.editors.isEnabled(iParameterEditor)) continue;
                iParameterEditor.setActive(Boolean.valueOf(false));
            }
        }
        return editorsGroup;
    }

    public void topLevelAgentChanged(ITopLevelAgent iTopLevelAgent) {
        SimulationAgent simulationAgent;
        if (iTopLevelAgent == null || iTopLevelAgent.isPlatform()) {
            this.agent = null;
            this.reset();
            this.updateToolbar();
            return;
        }
        if (iTopLevelAgent.isSimulation()) {
            simulationAgent = (SimulationAgent)iTopLevelAgent;
            if (this.agent == null || this.agent.isPlatform() || !this.agent.getExperiment().getSpecies().isBatch()) {
                this.reset();
                this.agent = simulationAgent;
                this.editors = new ExperimentsParametersList((ITopLevelAgent)simulationAgent);
                this.getEditorsList().setItemValues(simulationAgent.getExternalInits());
                this.displayItems();
                return;
            }
            if (this.agent.isSimulation()) {
                this.saveParameterValuesForCurrentAgent();
                this.agent = simulationAgent;
                this.getEditorsList().setItemValues(simulationAgent.getExternalInits());
                this.getEditorsList().updateItemValues(false);
                this.updateToolbar();
                return;
            }
            if (this.agent.isExperiment()) {
                this.agent = simulationAgent;
                this.getEditorsList().updateItemValues(false);
                if (this.getEditorsList().hasMonitors()) {
                    this.createMonitorSectionIfNeeded(false);
                }
                this.updateToolbar();
                return;
            }
        }
        if (iTopLevelAgent.isExperiment()) {
            simulationAgent = (IExperimentAgent)iTopLevelAgent;
            if (this.agent == simulationAgent || !simulationAgent.hasParametersOrUserCommands()) {
                return;
            }
            if (this.monitorSection != null) {
                WorkbenchHelper.run(() -> this.monitorSection.dispose());
                this.monitorSection = null;
            }
            if (this.agent != null && this.agent.isSimulation()) {
                this.saveParameterValuesForCurrentAgent();
                this.agent = simulationAgent;
                this.getEditorsList().updateItemValues(false);
                this.updateToolbar();
                return;
            }
            this.agent = simulationAgent;
            this.reset();
            this.editors = new ExperimentsParametersList((ITopLevelAgent)simulationAgent);
            String string = "Model " + simulationAgent.getModel().getDescription().getTitle() + " / " + StringUtils.capitalize((String)simulationAgent.getSpecies().getDescription().getTitle());
            this.setPartName(string);
            this.displayItems();
        }
    }

    private void saveParameterValuesForCurrentAgent() {
        ITopLevelAgent iTopLevelAgent = this.agent;
        if (!(iTopLevelAgent instanceof SimulationAgent)) {
            return;
        }
        SimulationAgent simulationAgent = (SimulationAgent)iTopLevelAgent;
        simulationAgent.setExternalInits(this.getEditorsList().getItemValues());
    }

    public void createToolItems(GamaToolbar2 gamaToolbar2) {
        super.createToolItems(gamaToolbar2);
        GridData gridData = (GridData)gamaToolbar2.getToolbar(16384).getLayoutData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.status = this.toolbar.button(GamaColors.get((Color)this.toolbar.getBackground()), "", null, 16384);
        if (GAMA.getExperiment() == null || GAMA.getExperiment().isBatch()) {
            return;
        }
        gamaToolbar2.button("generic/menu.undo", "Revert parameter values", "Revert parameters to their initial values", selectionEvent -> {
            EditorsList editorsList = this.editors;
            if (editorsList != null) {
                editorsList.revertToDefaultValue();
            }
        }, 131072);
        if (((Boolean)GamaPreferences.Runtime.CORE_MONITOR_PARAMETERS.getValue()).booleanValue()) {
            gamaToolbar2.button("views/open.monitor", "Add new monitor", "Add new monitor", selectionEvent -> this.createNewMonitor(), 131072);
        }
    }

    public boolean addItem(String string) {
        if (((Boolean)GamaPreferences.Runtime.CORE_MONITOR_PARAMETERS.getValue()).booleanValue() && MONITOR_SECTION_NAME.equals(string)) {
            this.createMonitorSectionIfNeeded(true);
            return true;
        }
        this.createItem(this.getParentComposite(), string, this.editors.getItemExpanded(string), GamaColors.get((java.awt.Color)this.editors.getItemDisplayColor(string)));
        return true;
    }

    protected GamaViewPart.ViewUpdateUIJob createUpdateJob() {
        ExperimentsParametersList experimentsParametersList = this.getEditorsList();
        if (experimentsParametersList != null && ((Boolean)GamaPreferences.Runtime.CORE_MONITOR_PARAMETERS.getValue()).booleanValue() && experimentsParametersList.hasMonitors()) {
            return new GamaViewPart.ViewUpdateUIJob((GamaViewPart)this){

                protected GamaViewPart.UpdatePriority jobPriority() {
                    return GamaViewPart.UpdatePriority.LOW;
                }

                public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                    if (!ExperimentParametersView.this.isOpen) {
                        return Status.CANCEL_STATUS;
                    }
                    if (ExperimentParametersView.this.getViewer() != null && !ExperimentParametersView.this.getViewer().isDisposed()) {
                        ((ExperimentsParametersList)ExperimentParametersView.this.editors).updateMonitors(GAMA.isSynchronized());
                    }
                    return Status.OK_STATUS;
                }
            };
        }
        return null;
    }

    protected boolean needsOutput() {
        return false;
    }

    public void dispose() {
        GAMA.removeTopLevelAgentChangeListener((ITopLevelAgentChangeListener)this);
        super.dispose();
    }
}

