/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.views.displays;

import gama.core.common.interfaces.IDisplaySurface;
import gama.core.runtime.GAMA;
import gama.core.runtime.PlatformHelper;
import gama.dev.DEBUG;
import gama.ui.experiment.views.displays.LayeredDisplayDecorator;
import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.shared.views.WorkaroundForIssue1353;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.swt.graphics.Point;

public class LayeredDisplayMultiListener {
    private final LayeredDisplayDecorator view;
    private final IDisplaySurface surface;
    volatile boolean mouseIsDown;
    volatile boolean inMenu;
    volatile long lastEnterTime;
    volatile Point lastEnterPosition = new Point(0, 0);
    volatile boolean suppressNextEnter;
    final Consumer<Character> keyListener;
    final Set<Character> pressedCharacters = new HashSet<Character>();
    final Set<Integer> pressedSpecialCharacters = new HashSet<Integer>();

    static {
        DEBUG.ON();
    }

    public LayeredDisplayMultiListener(IDisplaySurface iDisplaySurface, LayeredDisplayDecorator layeredDisplayDecorator) {
        this.view = layeredDisplayDecorator;
        this.surface = iDisplaySurface;
        this.keyListener = c -> {
            switch (c.charValue()) {
                case 'O': 
                case 'o': {
                    layeredDisplayDecorator.toggleOverlay();
                    break;
                }
                case 'T': 
                case 't': {
                    layeredDisplayDecorator.toggleToolbar();
                }
            }
        };
    }

    public void keyPressed(char c, boolean bl) {
        DEBUG.OUT((Object)("Key pressed: " + c));
        if (bl) {
            this.keyListener.accept(Character.valueOf(c));
            return;
        }
        this.pressedCharacters.add(Character.valueOf(c));
        for (Character c2 : this.pressedCharacters) {
            this.surface.dispatchKeyEvent(c2.charValue());
        }
        WorkbenchHelper.asyncRun((Runnable)this.view.displayOverlay);
    }

    public void specialKeyPressed(int n) {
        this.pressedSpecialCharacters.add(n);
        for (Integer n2 : this.pressedSpecialCharacters) {
            this.surface.dispatchSpecialKeyEvent(n2.intValue());
        }
        WorkbenchHelper.asyncRun((Runnable)this.view.displayOverlay);
    }

    public void keyReleased(char c, boolean bl) {
        DEBUG.OUT((Object)("Key released: " + c));
        if (!bl) {
            this.pressedCharacters.remove(Character.valueOf(c));
        }
    }

    public void specialKeyReleased(int n) {
        this.pressedSpecialCharacters.remove(n);
    }

    public void mouseEnter(int n, int n2, boolean bl, int n3) {
        if (this.suppressNextEnter) {
            this.suppressNextEnter = false;
            return;
        }
        if (bl) {
            return;
        }
        this.setMousePosition(n, n2);
        if (n3 > 0) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l - this.lastEnterTime < 100L && this.lastEnterPosition.x == n && this.lastEnterPosition.y == n2) {
            return;
        }
        this.lastEnterTime = System.currentTimeMillis();
        this.lastEnterPosition = new Point(n, n2);
        this.surface.dispatchMouseEvent(6, n, n2);
    }

    public void mouseExit(int n, int n2, boolean bl, int n3) {
        long l = System.currentTimeMillis();
        if (l - this.lastEnterTime < 100L && this.lastEnterPosition.x == n && this.lastEnterPosition.y == n2) {
            return;
        }
        this.setMousePosition(-1, -1);
        if (n3 > 0) {
            return;
        }
        this.surface.dispatchMouseEvent(7, n, n2);
        if (!this.view.isFullScreen() && WorkaroundForIssue1353.isInstalled()) {
            WorkaroundForIssue1353.showShell();
        }
    }

    public void mouseHover(int n, int n2, int n3) {
        if (n3 > 0) {
            return;
        }
        this.surface.dispatchMouseEvent(32, n, n2);
    }

    public void mouseMove(int n, int n2, boolean bl) {
        WorkbenchHelper.asyncRun((Runnable)this.view.displayOverlay);
        if (bl) {
            return;
        }
        if (this.mouseIsDown) {
            this.surface.draggedTo(n, n2);
            this.setMousePosition(n, n2);
            this.surface.dispatchMouseEvent(29, n, n2);
        } else {
            this.setMousePosition(n, n2);
            this.surface.dispatchMouseEvent(5, n, n2);
        }
    }

    public void mouseDown(int n, int n2, int n3, boolean bl) {
        this.setMousePosition(n, n2);
        if (this.inMenu) {
            this.inMenu = false;
            return;
        }
        if (bl || PlatformHelper.isWindows() && n3 == 3) {
            return;
        }
        this.mouseIsDown = true;
        this.surface.dispatchMouseEvent(3, n, n2);
    }

    public void mouseUp(int n, int n2, int n3, boolean bl) {
        if (!this.mouseIsDown) {
            return;
        }
        this.setMousePosition(n, n2);
        if (bl) {
            return;
        }
        this.mouseIsDown = false;
        if (!this.view.isFullScreen() && WorkaroundForIssue1353.isInstalled()) {
            WorkaroundForIssue1353.showShell();
        }
        this.surface.dispatchMouseEvent(4, n, n2);
    }

    public void menuDetected(int n, int n2) {
        if (this.inMenu) {
            return;
        }
        this.inMenu = this.surface.canTriggerContextualMenu();
        this.setMousePosition(n, n2);
        this.surface.dispatchMouseEvent(35, n, n2);
        if (this.inMenu) {
            this.surface.selectAgentsAroundMouse();
        }
    }

    public void dragDetected(int n, int n2) {
        this.surface.draggedTo(n, n2);
        this.setMousePosition(n, n2);
        this.surface.dispatchMouseEvent(29, n, n2);
    }

    public void focusGained() {
    }

    public void focusLost() {
        this.pressedCharacters.clear();
        this.pressedSpecialCharacters.clear();
    }

    private void setMousePosition(int n, int n2) {
        this.surface.setMousePosition(n, n2);
        GAMA.getGui().setMouseLocationInDisplay(this.surface.getWindowCoordinates());
        GAMA.getGui().setMouseLocationInModel(this.surface.getModelCoordinates());
    }
}

