/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.views.displays;

import gama.core.common.interfaces.GeneralSynchronizer;
import gama.core.common.interfaces.IDisplaySurface;
import gama.core.common.interfaces.IDisposable;
import gama.core.common.interfaces.IGamaView;
import gama.core.common.interfaces.ILayerManager;
import gama.core.common.preferences.GamaPreferences;
import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.outputs.IOutput;
import gama.core.outputs.LayeredDisplayData;
import gama.core.outputs.LayeredDisplayOutput;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.util.GamaColor;
import gama.dev.DEBUG;
import gama.ui.experiment.views.displays.LayeredDisplayDecorator;
import gama.ui.experiment.views.displays.SWTLayeredDisplayMultiListener;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.utils.ViewsHelper;
import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.shared.views.GamaViewPart;
import gama.ui.shared.views.toolbar.GamaToolbar2;
import gama.ui.shared.views.toolbar.IToolbarDecoratedView;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public abstract class LayeredDisplayView
extends GamaViewPart
implements IToolbarDecoratedView.Pausable,
IToolbarDecoratedView.Zoomable,
IGamaView.Display {
    volatile boolean isHiDPI;
    ControlListener shellListener;
    protected int realIndex = -1;
    public Composite surfaceComposite;
    public LayeredDisplayDecorator decorator;
    public volatile boolean disposed = false;
    private volatile boolean closing = false;
    protected CentralPanel centralPanel;
    protected GeneralSynchronizer syncSemaphore = GeneralSynchronizer.withInitialAndMaxPermits((int)1, (int)1);

    static {
        DEBUG.OFF();
    }

    public void setIndex(int n) {
        this.realIndex = n;
    }

    public int getIndex() {
        return this.realIndex;
    }

    public Composite getCentralPanel() {
        return this.centralPanel;
    }

    public boolean containsPoint(int n, int n2) {
        if (super.containsPoint(n, n2)) {
            return true;
        }
        Point point = this.getSurfaceComposite().toDisplay(0, 0);
        Point point2 = this.getSurfaceComposite().getSize();
        Rectangle rectangle = new Rectangle(point.x, point.y, point2.x, point2.y);
        return rectangle.contains(n, n2);
    }

    public void init(IViewSite iViewSite) throws PartInitException {
        super.init(iViewSite);
        this.decorator = new LayeredDisplayDecorator(this);
        if (this.getOutput() != null) {
            this.getOutput().getData().addListener((LayeredDisplayData.DisplayDataListener)this.decorator);
            this.setPartName(this.getOutput().getName());
        }
        this.shellListener = new ControlListener(){

            public void controlResized(ControlEvent controlEvent) {
                LayeredDisplayView.this.computeHiDPI();
            }

            public void controlMoved(ControlEvent controlEvent) {
                LayeredDisplayView.this.computeHiDPI();
            }
        };
        iViewSite.getShell().addControlListener(this.shellListener);
    }

    public void addOutput(IOutput iOutput) {
        IScope iScope;
        if (iOutput == this.getOutput()) {
            return;
        }
        super.addOutput(iOutput);
        if (iOutput instanceof LayeredDisplayOutput && (iScope = iOutput.getScope()) != null && iScope.getSimulation() != null) {
            ITopLevelAgent iTopLevelAgent = iScope.getRoot();
            this.setTitleImage(GamaIcon.ofColor((GamaColor)iTopLevelAgent.getColor()).image());
        }
    }

    public boolean isOpenGL() {
        return false;
    }

    public ILayerManager getDisplayManager() {
        return this.getDisplaySurface().getManager();
    }

    public Composite getSurfaceComposite() {
        return this.surfaceComposite;
    }

    public void ownCreatePartControl(Composite composite) {
        if (this.getOutput() == null) {
            return;
        }
        composite.setLayout(this.emptyLayout());
        this.centralPanel = new CentralPanel(composite);
        this.createSurfaceComposite(this.centralPanel);
        this.surfaceComposite.setLayoutData((Object)this.fullData());
        this.decorator.createDecorations();
        composite.requestLayout();
    }

    public IDisposable getMultiListener() {
        return new SWTLayeredDisplayMultiListener(this.decorator, this.getDisplaySurface());
    }

    Layout emptyLayout() {
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        return gridLayout;
    }

    GridData fullData() {
        return new GridData(4, 4, true, true);
    }

    protected abstract Composite createSurfaceComposite(Composite var1);

    public LayeredDisplayOutput getOutput() {
        return (LayeredDisplayOutput)super.getOutput();
    }

    public IDisplaySurface getDisplaySurface() {
        LayeredDisplayOutput layeredDisplayOutput = this.getOutput();
        if (layeredDisplayOutput != null) {
            return layeredDisplayOutput.getSurface();
        }
        return null;
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        if (this.disposed) {
            return;
        }
        LayeredDisplayOutput layeredDisplayOutput = this.getOutput();
        if (layeredDisplayOutput != null) {
            layeredDisplayOutput.getData().listeners.clear();
            IDisplaySurface iDisplaySurface = layeredDisplayOutput.getSurface();
            if (this.isOpenGL() && iDisplaySurface != null) {
                iDisplaySurface.dispose();
                layeredDisplayOutput.setSurface(null);
            }
            layeredDisplayOutput.releaseView();
            layeredDisplayOutput.setSurface(null);
        }
        this.disposed = true;
        if (this.surfaceComposite != null) {
            try {
                this.surfaceComposite.dispose();
            }
            catch (RuntimeException runtimeException) {}
        }
        if (this.decorator != null) {
            this.decorator.dispose();
        }
        super.widgetDisposed(disposeEvent);
    }

    public void pauseChanged() {
        this.decorator.updateOverlay();
    }

    public boolean forceOverlayVisibility() {
        return false;
    }

    public void zoomIn() {
        if (this.getDisplaySurface() != null) {
            this.getDisplaySurface().zoomIn();
        }
    }

    public void zoomOut() {
        if (this.getDisplaySurface() != null) {
            this.getDisplaySurface().zoomOut();
        }
    }

    public void zoomFit() {
        if (this.getDisplaySurface() != null) {
            this.getDisplaySurface().zoomFit();
        }
    }

    public void toggleLock() {
        if (this.getDisplaySurface() != null) {
            this.getDisplaySurface().toggleLock();
        }
    }

    public Control[] getZoomableControls() {
        return new Control[]{this.getParentComposite()};
    }

    protected Job createUpdateJob() {
        return null;
    }

    public void update(IOutput iOutput) {
        if (this.getDisplaySurface() != null && !this.getDisplaySurface().isDisposed()) {
            try {
                this.getDisplaySurface().updateDisplay(false, this.syncSemaphore);
                GAMA.getGui().getStatus().informStatus("Updating " + this.getTitle(), "status/status.view");
            }
            catch (Exception exception) {
                DEBUG.OUT((Object)("Error when updating " + this.getTitle() + ": " + exception.getMessage()));
            }
        }
        if (GAMA.isSynchronized() && !WorkbenchHelper.isDisplayThread()) {
            this.syncSemaphore.acquire();
        }
        this.updateSnapshot();
    }

    private void updateSnapshot() {
        if (this.disposed) {
            return;
        }
        IDisplaySurface iDisplaySurface = this.getDisplaySurface();
        if (iDisplaySurface == null || iDisplaySurface.isDisposed()) {
            return;
        }
        if (iDisplaySurface.getScope().getClock().getCycle() > 0 && iDisplaySurface.getData().isAutosave()) {
            WorkbenchHelper.run(() -> this.takeSnapshot(iDisplaySurface.getData().getImageDimension()));
        }
    }

    public boolean zoomWhenScrolling() {
        return true;
    }

    public void removeOutput(IOutput iOutput) {
        if (iOutput == null) {
            return;
        }
        if (iOutput == this.getOutput() && this.isFullScreen()) {
            WorkbenchHelper.run(this.decorator::toggleFullScreen);
        }
        iOutput.dispose();
        this.outputs.remove(iOutput);
        if (this.outputs.isEmpty()) {
            this.close(GAMA.getRuntimeScope());
        }
    }

    public boolean isFullScreen() {
        return this.decorator.isFullScreen();
    }

    public void toggleOverlay() {
        this.decorator.toggleOverlay();
    }

    public void toggleFullScreen() {
        this.decorator.toggleFullScreen();
    }

    public void createToolItems(GamaToolbar2 gamaToolbar2) {
        super.createToolItems(gamaToolbar2);
        this.decorator.createToolItems(gamaToolbar2);
    }

    public void showOverlay(boolean bl) {
        this.decorator.overlay.setVisible(bl);
    }

    public void takeSnapshot(GamaPoint gamaPoint) {
        GAMA.getSnapshotMaker().takeAndSaveSnapshot(this.getDisplaySurface(), gamaPoint);
    }

    public Control getInteractionControl() {
        return this.getZoomableControls()[0];
    }

    public void close(IScope iScope) {
        if (this.closing) {
            return;
        }
        this.closing = true;
        WorkbenchHelper.asyncRun(() -> {
            try {
                IDisplaySurface iDisplaySurface = this.getDisplaySurface();
                if (iDisplaySurface != null) {
                    iDisplaySurface.dispose();
                }
                ViewsHelper.hideView((IViewPart)this);
            }
            catch (Exception exception) {}
        });
    }

    public void dispose() {
        this.syncSemaphore.release();
        WorkbenchHelper.run(() -> {
            if (this.getSite() != null) {
                this.getSite().getShell().removeControlListener(this.shellListener);
            }
            super.dispose();
        });
    }

    public boolean isVisible() {
        IDisplaySurface iDisplaySurface = this.getDisplaySurface();
        return iDisplaySurface != null && iDisplaySurface.isVisible() || this.isFullScreen();
    }

    public boolean isEscRedefined() {
        IDisplaySurface iDisplaySurface = this.getDisplaySurface();
        return iDisplaySurface != null && iDisplaySurface.isEscRedefined();
    }

    public void computeHiDPI() {
        Monitor monitor = ViewsHelper.getMonitorOf((IWorkbenchPart)this);
        this.isHiDPI = monitor == null ? false : monitor.getZoom() > 100;
    }

    public boolean isHiDPI() {
        return this.isHiDPI;
    }

    public boolean largeZoomIcons() {
        return true;
    }

    public class CentralPanel
    extends Composite
    implements IGamaView.Display.InnerComponent {
        public CentralPanel(Composite composite) {
            super(composite, (Boolean)GamaPreferences.Displays.CORE_DISPLAY_BORDER.getValue() != false ? 2048 : 0);
            this.setLayout(LayeredDisplayView.this.emptyLayout());
            this.setLayoutData(LayeredDisplayView.this.fullData());
            LayeredDisplayView.this.setParentComposite(this);
        }

        public LayeredDisplayView getView() {
            return LayeredDisplayView.this;
        }
    }
}

