/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.views.inspectors;

import gama.core.common.interfaces.IValue;
import gama.core.common.interfaces.ItemList;
import gama.core.metamodel.agent.IAgent;
import gama.core.outputs.IOutput;
import gama.core.outputs.MonitorOutput;
import gama.core.outputs.ValuedDisplayOutputFactory;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.dev.COUNTER;
import gama.gaml.compilation.GAML;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.IExpressionFactory;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import gama.ui.shared.parameters.EditorFactory;
import gama.ui.shared.parameters.EditorsGroup;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.shared.views.ExpandableItemsView;
import gama.ui.shared.views.toolbar.GamaToolbar2;
import gama.ui.shared.views.toolbar.IToolbarDecoratedView;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class MonitorView
extends ExpandableItemsView<MonitorOutput>
implements IToolbarDecoratedView.Pausable {
    public void ownCreatePartControl(Composite composite) {
        this.displayItems();
    }

    protected boolean needsOutput() {
        return false;
    }

    public void addOutput(IOutput iOutput) {
        super.addOutput(iOutput);
        this.addItem((MonitorOutput)iOutput);
    }

    public boolean addItem(MonitorOutput monitorOutput) {
        if (monitorOutput != null) {
            this.createItem(this.getParentComposite(), monitorOutput, monitorOutput.getValue() == null, monitorOutput.getColor(null) == null ? null : GamaColors.get((Color)monitorOutput.getColor(null)));
            return true;
        }
        return false;
    }

    protected Composite createItemContentsFor(final MonitorOutput monitorOutput) {
        IExpression iExpression;
        EditorsGroup editorsGroup = new EditorsGroup((Composite)this.getViewer(), 0);
        Text text = (Text)EditorFactory.create((IScope)monitorOutput.getScope(), (EditorsGroup)editorsGroup, (String)"Title:", (String)monitorOutput.getName(), (boolean)true, string -> {
            monitorOutput.setName(string);
            this.update((IOutput)monitorOutput);
        }).getEditor();
        try {
            iExpression = GAML.compileExpression((String)monitorOutput.getExpressionText(), (IAgent)monitorOutput.getScope().getSimulation(), (boolean)true);
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            iExpression = GAML.compileExpression((String)monitorOutput.getExpressionText(), (IAgent)monitorOutput.getScope().getExperiment(), (boolean)true);
        }
        Text text2 = (Text)EditorFactory.createExpression((IScope)monitorOutput.getScope(), (EditorsGroup)editorsGroup, (String)"Expression:", (IExpression)(monitorOutput.getValue() == null ? IExpressionFactory.NIL_EXPR : iExpression), object -> {
            monitorOutput.setNewExpression((IExpression)object);
            this.update((IOutput)monitorOutput);
        }, (IType)Types.NO_TYPE).getEditor();
        text2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                MonitorView.this.getViewer().collapseItemWithData((Object)monitorOutput);
            }
        });
        text.addModifyListener(modifyEvent -> {
            monitorOutput.setName(text.getText());
            this.update((IOutput)monitorOutput);
        });
        return editorsGroup;
    }

    public void removeItem(MonitorOutput monitorOutput) {
        monitorOutput.close();
        this.removeOutput((IOutput)monitorOutput);
    }

    public void resumeItem(MonitorOutput monitorOutput) {
        if (monitorOutput.isPaused()) {
            monitorOutput.setPaused(false);
        }
        this.update((IOutput)monitorOutput);
    }

    public void pauseItem(MonitorOutput monitorOutput) {
        monitorOutput.setPaused(true);
        this.update((IOutput)monitorOutput);
    }

    public String getItemDisplayName(MonitorOutput monitorOutput, String string) {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.setLength(0);
        stringBuilder.append(monitorOutput.getName()).append(ItemList.SEPARATION_CODE).append(this.getValueAsString(monitorOutput));
        if (monitorOutput.isPaused()) {
            stringBuilder.append(" (paused)");
        }
        return stringBuilder.toString();
    }

    public String getValueAsString(MonitorOutput monitorOutput) {
        Object object = monitorOutput.getLastValue();
        return object == null ? "nil" : (object instanceof IValue ? ((IValue)object).serializeToGaml(true) : object.toString());
    }

    public GamaColor getItemDisplayColor(MonitorOutput monitorOutput) {
        return monitorOutput.getColor(null);
    }

    public static void createNewMonitor(IScope iScope) {
        new MonitorOutput(iScope, "monitor" + String.valueOf(COUNTER.COUNT()), "");
    }

    public void reset() {
        this.disposeViewer();
        this.outputs.clear();
    }

    public void focusItem(MonitorOutput monitorOutput) {
        this.outputs.remove(monitorOutput);
        this.outputs.add(0, monitorOutput);
    }

    protected boolean areItemsClosable() {
        return true;
    }

    protected boolean areItemsPausable() {
        return true;
    }

    public List getItems() {
        return this.outputs;
    }

    public void updateItemValues(boolean bl) {
    }

    public void createToolItems(GamaToolbar2 gamaToolbar2) {
        super.createToolItems(gamaToolbar2);
        gamaToolbar2.sep(4, 131072);
        gamaToolbar2.button("views/open.monitor", "Add new monitor", "Add new monitor", selectionEvent -> MonitorView.createNewMonitor(this.getOutput().getScope()), 131072);
    }

    public void pauseChanged() {
    }

    public Map<String, Runnable> handleMenu(MonitorOutput monitorOutput, int n, int n2) {
        HashMap<String, Runnable> hashMap = new HashMap<String, Runnable>();
        IExpression iExpression = monitorOutput.getValue();
        if (iExpression == null) {
            return null;
        }
        IType iType = iExpression.getGamlType();
        hashMap.put("Copy to clipboard", () -> WorkbenchHelper.copy((String)this.getValueAsString(monitorOutput)));
        if (iType.isNumber() || iType.isContainer() && iType.getContentType().isNumber()) {
            hashMap.put("Save as CSV", () -> monitorOutput.saveHistory());
        } else if (iType.isAgentType()) {
            hashMap.put("Inspect", () -> monitorOutput.getScope().getGui().setSelectedAgent((IAgent)monitorOutput.getLastValue()));
        } else if (iType.isContainer() && iType.getContentType().isAgentType()) {
            hashMap.put("Browse", () -> ValuedDisplayOutputFactory.browse((Collection)((Collection)monitorOutput.getLastValue())));
        }
        return hashMap;
    }
}

