/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.views.inspectors;

import gama.core.common.util.FileUtils;
import gama.core.common.util.StringUtils;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.outputs.IOutput;
import gama.core.outputs.InspectDisplayOutput;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.file.csv.CsvWriter;
import gama.dev.DEBUG;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.VariableDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.types.SpeciesConstantExpression;
import gama.gaml.operators.Files;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import gama.ui.experiment.menus.AgentsMenu;
import gama.ui.shared.controls.SwitchButton;
import gama.ui.shared.menus.GamaMenu;
import gama.ui.shared.menus.MenuAction;
import gama.ui.shared.parameters.ExpressionControl;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.views.GamaViewPart;
import gama.ui.shared.views.toolbar.GamaToolbar2;
import gama.ui.shared.views.toolbar.IToolbarDecoratedView;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.locationtech.jts.geom.Coordinate;

public class PopulationInspectView
extends GamaViewPart
implements IToolbarDecoratedView.Sizable,
IToolbarDecoratedView.Pausable {
    protected static final String exportFolder = "exports";
    public static final String ID = "gama.ui.application.view.TableAgentInspectView";
    public static final String ID_ATTRIBUTE = "#";
    public static final int SAVE = 0;
    public static final int LOCK = 1;
    public static final int POP = 2;
    public static final int EXPR = 3;
    public static final List<String> DONT_INSPECT_BY_DEFAULT = Arrays.asList("peers", "members", "agents", "shape", "host");
    private IScope scope;
    volatile boolean locked;
    ToolItem populationMenu;
    TableViewer viewer;
    Composite attributesMenu;
    AgentComparator comparator;
    ExpressionControl editor;
    IAgent[] elements = new IAgent[0];
    Map<String, List<String>> selectedColumns = new HashMap<String, List<String>>();
    private final AgentContentProvider provider = new AgentContentProvider();
    private final SelectionAdapter attributeAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            PopulationInspectView.this.selectedColumns.put(PopulationInspectView.this.getSpeciesName(), PopulationInspectView.this.getAttributesSelection());
            PopulationInspectView.this.recreateViewer();
            PopulationInspectView.this.update((IOutput)PopulationInspectView.this.getOutput());
        }
    };

    public void init(IViewSite iViewSite) throws PartInitException {
        super.init(iViewSite);
        this.setTitleImage(GamaIcon.named((String)"views/tabs/view.browser").image());
    }

    protected Job createUpdateJob() {
        return new GamaViewPart.ViewUpdateUIJob(this){

            protected GamaViewPart.UpdatePriority jobPriority() {
                return GamaViewPart.UpdatePriority.LOW;
            }

            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                TableViewer tableViewer = PopulationInspectView.this.viewer;
                if (tableViewer == null || tableViewer.getTable() == null || tableViewer.getTable().isDisposed() || PopulationInspectView.this.getOutput() == null) {
                    return Status.CANCEL_STATUS;
                }
                if (!PopulationInspectView.this.locked) {
                    Object[] objectArray = (IAgent[])((StreamEx)StreamEx.of((Object[])PopulationInspectView.this.getOutput().getLastValue()).filter(iAgent -> iAgent != null && !iAgent.dead())).toArray(IAgent.class);
                    if (Arrays.equals(PopulationInspectView.this.elements, objectArray)) {
                        tableViewer.refresh();
                    } else {
                        PopulationInspectView.this.viewer.setInput((Object)objectArray);
                    }
                } else {
                    PopulationInspectView.this.viewer.refresh();
                }
                return Status.OK_STATUS;
            }
        };
    }

    public InspectDisplayOutput getOutput() {
        return (InspectDisplayOutput)super.getOutput();
    }

    public void addOutput(IOutput iOutput) {
        if (this.getOutput() == iOutput) {
            return;
        }
        if (this.getOutput() != null) {
            this.getOutput().setPaused(true);
            GAMA.releaseScope((IScope)this.getScope());
            this.outputs.clear();
        }
        this.outputs.add(iOutput);
        this.scope = iOutput.getScope().copy("in population inspector");
        this.selectedColumns.clear();
        this.updateSpecies();
        this.comparator = new AgentComparator();
        this.recreateViewer();
    }

    void updateSpecies() {
        SpeciesDescription speciesDescription = this.getOutput().getSpeciesDescription();
        IExpression iExpression = this.getOutput().getValue();
        String string = speciesDescription == null ? "agent" : speciesDescription.getName();
        boolean bl = iExpression instanceof SpeciesConstantExpression;
        if (!this.selectedColumns.containsKey(string)) {
            this.selectedColumns.put(string, new ArrayList());
            Map map = this.getOutput().getAttributes();
            if (map != null) {
                this.selectedColumns.get(string).addAll(map.keySet());
            } else if (this.getOutput().getValue() != null) {
                if (speciesDescription == null) {
                    return;
                }
                this.selectedColumns.get(string).addAll(speciesDescription.getAttributeNames());
                this.selectedColumns.get(string).removeAll(DONT_INSPECT_BY_DEFAULT);
            }
            Collections.sort(this.selectedColumns.get(string));
            this.selectedColumns.get(string).remove(ID_ATTRIBUTE);
            this.selectedColumns.get(string).add(0, ID_ATTRIBUTE);
        }
        this.changePartName(string, bl);
    }

    private void changePartName(String string, boolean bl) {
        if (string == null) {
            return;
        }
        if (!bl) {
            this.setPartName(this.getOutput().getName() + ": set of " + string);
        } else {
            this.setPartName(this.getOutput().getName() + ": population of " + string);
        }
    }

    private void createMenus(Composite composite) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 512);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        this.attributesMenu = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)this.attributesMenu);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 1;
        this.attributesMenu.setLayout((Layout)gridLayout);
        this.fillAttributeMenu();
    }

    void fillAttributeMenu() {
        String string3;
        Control control;
        if (this.getOutput() == null || this.attributesMenu == null || this.attributesMenu.isDisposed()) {
            return;
        }
        Control[] controlArray = this.attributesMenu.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        control = new Label(this.attributesMenu, 0);
        control.setText("Attributes");
        control = new Label(this.attributesMenu, 0);
        control.setText(" ");
        String string2 = this.getSpeciesName();
        Object object = "agent".equals(string2) ? "A list of the attributes common to the agents returned by the custom expression" : "A list of the attributes defined in species " + string2 + ". Select the ones you want to display in the table";
        this.attributesMenu.setToolTipText((String)object);
        boolean bl = this.selectedColumns.get(string2) != null;
        InspectDisplayOutput inspectDisplayOutput = this.getOutput();
        SpeciesDescription speciesDescription = inspectDisplayOutput.getSpeciesDescription();
        ArrayList arrayList = new ArrayList(this.getOutput().getAttributes() == null ? speciesDescription.getAttributeNames() : this.getOutput().getAttributes().keySet());
        Collections.sort(arrayList);
        DEBUG.OUT((Object)String.valueOf(arrayList));
        for (String string3 : arrayList) {
            SwitchButton switchButton = new SwitchButton(this.attributesMenu, 0, "   ", "   ", string3);
            switchButton.setSelection(bl && this.selectedColumns.get(string2).contains(string3));
            switchButton.addSelectionListener((SelectionListener)this.attributeAdapter);
        }
        string3 = this.attributesMenu.computeSize(-1, -1, true);
        this.attributesMenu.setSize((Point)string3);
        this.attributesMenu.layout(true, true);
        ((ScrolledComposite)this.attributesMenu.getParent()).setMinSize((Point)string3);
    }

    private void createExpressionComposite() {
        Composite composite = new Composite((Composite)this.toolbar.getToolbar(131072), 0);
        composite.setSize(new Point(150, 30));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.editor = new ExpressionControl(this.getScope(), composite, null, this.getScope().getAgent(), (IType)Types.CONTAINER.of(Types.AGENT), 2048, false){

            public void modifyValue() {
                Object object = this.getCurrentValue();
                super.modifyValue();
                if (object == null ? this.getCurrentValue() != null : !object.equals(this.getCurrentValue())) {
                    if (PopulationInspectView.this.outputs.isEmpty()) {
                        return;
                    }
                    try {
                        PopulationInspectView.this.getOutput().setNewExpression((IExpression)this.getCurrentValue());
                    }
                    catch (GamaRuntimeException gamaRuntimeException) {
                        gamaRuntimeException.printStackTrace();
                    }
                    PopulationInspectView.this.updateSpecies();
                    PopulationInspectView.this.fillAttributeMenu();
                    PopulationInspectView.this.recreateViewer();
                    PopulationInspectView.this.update((IOutput)PopulationInspectView.this.getOutput());
                }
            }
        };
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.minimumHeight = 16;
        gridData.heightHint = 16;
        this.editor.getControl().setText(this.getOutput().getExpressionText());
        this.editor.getControl().setLayoutData((Object)gridData);
        this.editor.getControl().setToolTipText("Enter a GAML expression returning one or several agents ");
        this.toolbar.control((Control)composite, 150, 131072);
        this.toolbar.requestLayout();
    }

    List<String> getAttributesSelection() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Control[] controlArray = this.attributesMenu.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            SwitchButton switchButton;
            Control control = controlArray[n2];
            if (control instanceof SwitchButton && (switchButton = (SwitchButton)control).getSelection()) {
                arrayList.add(switchButton.getText());
            }
            ++n2;
        }
        return arrayList;
    }

    String getSpeciesName() {
        if (this.getOutput() == null) {
            return "";
        }
        SpeciesDescription speciesDescription = this.getOutput().getSpeciesDescription();
        if (speciesDescription == null) {
            return "agent";
        }
        return speciesDescription.getName();
    }

    public void ownCreatePartControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout2 = new GridLayout(2, false);
        gridLayout2.marginWidth = 0;
        gridLayout2.marginHeight = 0;
        gridLayout2.verticalSpacing = 0;
        composite3.setLayout((Layout)gridLayout2);
        this.createMenus(composite3);
        this.createViewer(composite3);
        composite3.layout(true, true);
        this.setParentComposite(composite3);
    }

    private void createViewer(Composite composite) {
        this.viewer = new TableViewer(composite, 0x10010300);
        this.createColumns();
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)this.provider);
        this.viewer.addDoubleClickListener(doubleClickEvent -> {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)this.viewer.getSelection();
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof IAgent) {
                this.getScope().getGui().setHighlightedAgent((IAgent)object);
                GAMA.getExperiment().refreshAllOutputs();
            }
        });
        this.viewer.setComparer(new IElementComparer(){

            public int hashCode(Object object) {
                return Objects.hashCode(object);
            }

            public boolean equals(Object object, Object object2) {
                return Objects.equals(object, object2);
            }
        });
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(false);
        menuManager.addMenuListener(iMenuManager -> {
            IAgent iAgent = null;
            IStructuredSelection iStructuredSelection = (IStructuredSelection)this.viewer.getSelection();
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof IAgent) {
                iAgent = (IAgent)object;
            }
            if (iAgent != null) {
                iMenuManager.removeAll();
                iMenuManager.update(true);
                AgentsMenu.createMenuForAgent(this.viewer.getControl().getMenu(), iAgent, false, true, new MenuAction[0]);
            }
        });
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 1;
        this.viewer.getControl().setLayoutData((Object)gridData);
    }

    void recreateViewer() {
        if (this.viewer == null) {
            return;
        }
        Table table = this.viewer.getTable();
        if (table.isDisposed()) {
            return;
        }
        Font font = this.viewer.getControl().getFont();
        table.dispose();
        this.createViewer(this.getParentComposite());
        this.viewer.getControl().setFont(font);
        this.getParentComposite().layout(true);
    }

    private void createColumns() {
        ArrayList<String> arrayList = new ArrayList<String>(this.getAttributesSelection());
        arrayList.remove(ID_ATTRIBUTE);
        arrayList.add(0, ID_ATTRIBUTE);
        for (String string : arrayList) {
            this.createTableViewerColumn(string, 100, 0);
        }
    }

    private ColumnLabelProvider getColumnLabelProvider(final String string) {
        return new ColumnLabelProvider(){

            public String getText(Object object) {
                IAgent iAgent = (IAgent)object;
                if (iAgent.dead() && !PopulationInspectView.ID_ATTRIBUTE.equals(string)) {
                    return "N/A";
                }
                if (PopulationInspectView.ID_ATTRIBUTE.equals(string)) {
                    return String.valueOf(iAgent.getIndex());
                }
                if (iAgent.getSpecies().hasVar(string)) {
                    return StringUtils.toGaml((Object)PopulationInspectView.this.getScope().getAgentVarValue(iAgent, string), (boolean)false);
                }
                return StringUtils.toGaml((Object)iAgent.getAttribute(string), (boolean)false);
            }
        };
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn tableColumn, final String string) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PopulationInspectView.this.comparator.setColumn(string);
                int n = PopulationInspectView.this.comparator.getDirection();
                PopulationInspectView.this.viewer.getTable().setSortDirection(n);
                PopulationInspectView.this.viewer.getTable().setSortColumn(tableColumn);
                if (PopulationInspectView.this.getScope().isPaused() || PopulationInspectView.this.getOutput().isPaused()) {
                    Arrays.sort(PopulationInspectView.this.elements, PopulationInspectView.this.comparator);
                }
                PopulationInspectView.this.viewer.refresh();
            }
        };
    }

    private TableViewerColumn createTableViewerColumn(String string, int n, int n2) {
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn tableColumn = tableViewerColumn.getColumn();
        tableColumn.setText(string);
        tableColumn.setWidth(n);
        tableColumn.setResizable(true);
        tableColumn.setMoveable(true);
        tableColumn.addSelectionListener((SelectionListener)this.getSelectionAdapter(tableColumn, string));
        tableViewerColumn.setLabelProvider((CellLabelProvider)this.getColumnLabelProvider(string));
        return tableViewerColumn;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    IScope getScope() {
        return this.scope;
    }

    public void saveAsCSV() {
        try {
            Files.newFolder((IScope)this.getScope(), (String)exportFolder);
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            gamaRuntimeException.addContext("Impossible to create folder exports");
            GAMA.reportError((IScope)this.getScope(), (GamaRuntimeException)gamaRuntimeException, (boolean)false);
            gamaRuntimeException.printStackTrace();
            return;
        }
        String string = FileUtils.constructAbsoluteFilePath((IScope)this.getScope(), (String)("exports/" + this.getSpeciesName() + "_population" + this.getScope().getClock().getCycle() + ".csv"), (boolean)false);
        Table table = this.viewer.getTable();
        TableColumn[] tableColumnArray = table.getColumns();
        Throwable throwable = null;
        Object var5_7 = null;
        try (CsvWriter csvWriter = new CsvWriter(string);){
            TableItem[] tableItemArray;
            csvWriter.setDelimiter(';');
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            String[] stringArray = new String[tableColumnArray.length];
            int n = 0;
            TableColumn[] tableColumnArray2 = tableColumnArray;
            int n2 = tableColumnArray.length;
            int n3 = 0;
            while (n3 < n2) {
                tableItemArray = tableColumnArray2[n3];
                stringArray[n++] = tableItemArray.getText();
                ++n3;
            }
            arrayList.add(stringArray);
            TableItem[] tableItemArray2 = tableItemArray = table.getItems();
            int n4 = tableItemArray.length;
            n2 = 0;
            while (n2 < n4) {
                TableItem tableItem = tableItemArray2[n2];
                String[] stringArray2 = new String[tableColumnArray.length];
                int n5 = 0;
                while (n5 < tableColumnArray.length) {
                    stringArray2[n5] = tableItem.getText(n5);
                    ++n5;
                }
                arrayList.add(stringArray2);
                ++n2;
            }
            try {
                for (String[] stringArray3 : arrayList) {
                    csvWriter.writeRecord(stringArray3);
                }
            }
            catch (IOException iOException) {
                throw GamaRuntimeException.create((Throwable)iOException, (IScope)this.getScope());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Control getSizableFontControl() {
        if (this.viewer == null) {
            return null;
        }
        return this.viewer.getTable();
    }

    public void createToolItems(GamaToolbar2 gamaToolbar2) {
        if (this.getOutput() == null) {
            return;
        }
        super.createToolItems(gamaToolbar2);
        gamaToolbar2.check("display/camera.lock", "", "Lock the current population (prevents editing it)", selectionEvent -> {
            this.locked = !this.locked;
            this.editor.getControl().setEnabled(!this.locked);
            this.populationMenu.setEnabled(!this.locked);
        }, 131072);
        this.createExpressionComposite();
        this.populationMenu = gamaToolbar2.menu("agents/agents.submenu", "", "Browse a species", selectionEvent -> {
            if (this.locked) {
                return;
            }
            GamaMenu gamaMenu = new GamaMenu(){

                protected void fillMenu() {
                    IPopulation[] iPopulationArray;
                    IPopulation[] iPopulationArray2 = iPopulationArray = PopulationInspectView.this.getOutput().getRootAgent().getMicroPopulations();
                    int n = iPopulationArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        final IPopulation iPopulation = iPopulationArray2[n2];
                        this.action(iPopulation.getName(), (SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent selectionEvent) {
                                (this).PopulationInspectView.this.editor.getControl().setText(iPopulation.getName());
                                (this).PopulationInspectView.this.editor.widgetDefaultSelected(null);
                            }
                        }, GamaIcon.named((String)"agents/agents.submenu").image());
                        ++n2;
                    }
                }
            };
            gamaMenu.open((Control)this.toolbar.getToolbar(131072), selectionEvent);
        }, 131072);
        gamaToolbar2.sep(4, 131072);
        gamaToolbar2.button("generic/menu.saveas", "Save as CSV", "Save the agents and their attributes into a CSV file", selectionEvent -> this.saveAsCSV(), 131072);
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        super.dispose();
        if (this.viewer != null && this.viewer.getTable() != null && !this.viewer.getTable().isDisposed()) {
            this.viewer.getTable().dispose();
        }
        if (this.attributesMenu != null && !this.attributesMenu.isDisposed()) {
            this.attributesMenu.dispose();
        }
        this.provider.dispose();
        GAMA.releaseScope((IScope)this.scope);
        this.scope = null;
    }

    public void pauseChanged() {
    }

    public class AgentComparator
    extends ViewerComparator
    implements Comparator {
        private String attribute = null;
        private int direction = 128;
        private final NaturalOrderComparator stringComparator = new NaturalOrderComparator();

        public int getDirection() {
            return this.direction;
        }

        public void setColumn(String string) {
            if (string.equals(this.attribute)) {
                this.direction = this.direction == 128 ? 1024 : 128;
            } else {
                this.attribute = string;
                this.direction = 128;
            }
        }

        public int compare(Viewer viewer, Object object, Object object2) {
            return this.compare(object, object2);
        }

        public int compare(Object object, Object object2) {
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            IAgent iAgent = (IAgent)object;
            IAgent iAgent2 = (IAgent)object2;
            IScope iScope = PopulationInspectView.this.getScope();
            int n = 0;
            if (this.attribute == null || PopulationInspectView.ID_ATTRIBUTE.equals(this.attribute)) {
                n = iAgent.compareTo((Object)iAgent2);
            } else {
                try {
                    Object object3 = iScope.getAgentVarValue(iAgent, this.attribute);
                    if (object3 == null) {
                        n = -1;
                    } else {
                        Object object4 = iScope.getAgentVarValue(iAgent2, this.attribute);
                        if (object4 == null) {
                            n = 1;
                        } else {
                            VariableDescription variableDescription = PopulationInspectView.this.getOutput().getSpeciesDescription().getAttribute(this.attribute);
                            int n2 = variableDescription.getGamlType().id();
                            n = switch (n2) {
                                case 1 -> ((Integer)object3).compareTo((Integer)object4);
                                case 2 -> ((Double)object3).compareTo((Double)object4);
                                case 4 -> this.stringComparator.compare(object3, object4);
                                case 7 -> ((GamaPoint)object3).compareTo((Coordinate)((GamaPoint)object4));
                                default -> StringUtils.toGaml((Object)object3, (boolean)false).compareTo(StringUtils.toGaml((Object)object4, (boolean)false));
                            };
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (this.direction == 1024) {
                n = -n;
            }
            return n;
        }
    }

    class AgentContentProvider
    implements ILazyContentProvider {
        AgentContentProvider() {
        }

        public void dispose() {
            PopulationInspectView.this.elements = new IAgent[0];
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            IAgent[] iAgentArray = object2 == null ? new IAgent[]{} : (IAgent[])object2;
            PopulationInspectView.this.elements = iAgentArray;
            if (PopulationInspectView.this.elements.length > 1 && PopulationInspectView.this.comparator != null) {
                Arrays.sort(PopulationInspectView.this.elements, PopulationInspectView.this.comparator);
            }
            PopulationInspectView.this.viewer.setItemCount(PopulationInspectView.this.elements.length);
        }

        public void updateElement(int n) {
            if (n > PopulationInspectView.this.elements.length - 1) {
                return;
            }
            IAgent iAgent = PopulationInspectView.this.elements[n];
            if (iAgent != null) {
                PopulationInspectView.this.viewer.replace((Object)iAgent, n);
            } else {
                PopulationInspectView.this.viewer.refresh();
            }
        }
    }

    public static class NaturalOrderComparator
    implements Comparator {
        int compareRight(String string, String string2) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (true) {
                char c = this.charAt(string, n2);
                char c2 = this.charAt(string2, n3);
                if (!Character.isDigit(c) && !Character.isDigit(c2)) {
                    return n;
                }
                if (!Character.isDigit(c)) {
                    return -1;
                }
                if (!Character.isDigit(c2)) {
                    return 1;
                }
                if (c < c2) {
                    if (n == 0) {
                        n = -1;
                    }
                } else if (c > c2) {
                    if (n == 0) {
                        n = 1;
                    }
                } else if (c == '\u0000' && c2 == '\u0000') {
                    return n;
                }
                ++n2;
                ++n3;
            }
        }

        public int compare(Object object, Object object2) {
            String string = object.toString();
            String string2 = object2.toString();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (true) {
                int n5;
                n4 = 0;
                n3 = 0;
                char c = this.charAt(string, n);
                char c2 = this.charAt(string2, n2);
                while (Character.isSpaceChar(c) || c == '0') {
                    n3 = c == '0' ? ++n3 : 0;
                    c = this.charAt(string, ++n);
                }
                while (Character.isSpaceChar(c2) || c2 == '0') {
                    n4 = c2 == '0' ? ++n4 : 0;
                    c2 = this.charAt(string2, ++n2);
                }
                if (Character.isDigit(c) && Character.isDigit(c2) && (n5 = this.compareRight(string.substring(n), string2.substring(n2))) != 0) {
                    return n5;
                }
                if (c == '\u0000' && c2 == '\u0000') {
                    return n3 - n4;
                }
                if (c < c2) {
                    return -1;
                }
                if (c > c2) {
                    return 1;
                }
                ++n;
                ++n2;
            }
        }

        char charAt(String string, int n) {
            if (n >= string.length()) {
                return '\u0000';
            }
            return string.charAt(n);
        }
    }
}

