/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.parameters;

import gama.core.common.interfaces.ItemList;
import gama.core.kernel.experiment.IExperimentDisplayable;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.simulation.SimulationClock;
import gama.core.metamodel.agent.IAgent;
import gama.core.util.GamaColor;
import gama.ui.experiment.parameters.EditorsList;
import gama.ui.shared.interfaces.IParameterEditor;
import gama.ui.shared.parameters.AbstractEditor;
import gama.ui.shared.parameters.EditorFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AgentAttributesEditorsList
extends EditorsList<IAgent> {
    private static final String DEAD_MARKER = " dead at step ";
    private static final String AGENT_MARKER = "Agent" + String.valueOf(ItemList.SEPARATION_CODE);
    private static final Set<String> HIDDEN = new HashSet<String>(Arrays.asList("peers", "members", "agents"));

    @Override
    public String getItemDisplayName(IAgent iAgent, String string) {
        if (string == null) {
            return AGENT_MARKER + iAgent.getName();
        }
        if (iAgent.dead() && !string.contains(DEAD_MARKER)) {
            SimulationClock simulationClock = iAgent.getScope().getClock();
            long l = simulationClock == null ? 0 : simulationClock.getCycle();
            return AGENT_MARKER + String.valueOf(ItemList.ERROR_CODE) + string.substring(string.indexOf(ItemList.SEPARATION_CODE.charValue()) + 1) + DEAD_MARKER + l;
        }
        return string;
    }

    public GamaColor getItemDisplayColor(IAgent iAgent) {
        return null;
    }

    public void add(Collection<? extends IExperimentDisplayable> collection, IAgent iAgent) {
        if (this.addItem(iAgent) && !iAgent.dead()) {
            for (IExperimentDisplayable iExperimentDisplayable : collection) {
                if (!(iExperimentDisplayable instanceof IParameter) || HIDDEN.contains(iExperimentDisplayable.getName())) continue;
                AbstractEditor abstractEditor = EditorFactory.getInstance().create(iAgent, (IParameter)iExperimentDisplayable, null);
                ((Map)this.sections.get(iAgent)).put(abstractEditor.getParam().getName(), abstractEditor);
            }
        }
    }

    public boolean addItem(IAgent iAgent) {
        if (!this.sections.containsKey(iAgent)) {
            this.sections.put(iAgent, new HashMap());
            return true;
        }
        return false;
    }

    @Override
    public void updateItemValues(boolean bl) {
        for (Map.Entry entry : this.sections.entrySet()) {
            if (((IAgent)entry.getKey()).dead()) continue;
            for (IParameterEditor iParameterEditor : ((Map)entry.getValue()).values()) {
                iParameterEditor.updateWithValueOfParameter(bl, false);
            }
        }
    }

    public Map<String, Runnable> handleMenu(IAgent iAgent, int n, int n2) {
        return null;
    }
}

