/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.parameters;

import gama.core.common.preferences.GamaPreferences;
import gama.core.kernel.experiment.ICategory;
import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.kernel.experiment.IExperimentDisplayable;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.kernel.experiment.TextStatement;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.outputs.MonitorOutput;
import gama.core.outputs.SimulationOutputManager;
import gama.core.runtime.IScope;
import gama.core.util.GamaColor;
import gama.gaml.operators.Cast;
import gama.gaml.statements.IExecutable;
import gama.gaml.statements.UserCommandStatement;
import gama.ui.experiment.parameters.EditorsCategory;
import gama.ui.experiment.parameters.EditorsList;
import gama.ui.shared.interfaces.IParameterEditor;
import gama.ui.shared.parameters.EditorFactory;
import gama.ui.shared.parameters.MonitorDisplayer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;

public class ExperimentsParametersList
extends EditorsList<String> {
    final Map<String, Boolean> activations = new HashMap<String, Boolean>();
    final Map<MonitorOutput, MonitorDisplayer> monitors = new HashMap<MonitorOutput, MonitorDisplayer>();
    final Map<String, EditorsCategory> categories = new LinkedHashMap<String, EditorsCategory>();

    public ExperimentsParametersList(ITopLevelAgent iTopLevelAgent) {
        SimulationOutputManager simulationOutputManager;
        if (iTopLevelAgent == null || iTopLevelAgent.getExperiment() == null) {
            return;
        }
        IExperimentAgent iExperimentAgent = iTopLevelAgent.getExperiment();
        ArrayList arrayList = new ArrayList(iExperimentAgent.getDisplayables());
        if (iTopLevelAgent.isSimulation() && ((Boolean)GamaPreferences.Runtime.CORE_MONITOR_PARAMETERS.getValue()).booleanValue() && (simulationOutputManager = ((SimulationAgent)iTopLevelAgent).getOutputManager()) != null) {
            arrayList.addAll(simulationOutputManager.getMonitors());
        }
        Collections.sort(arrayList);
        this.add((ITopLevelAgent)iExperimentAgent, arrayList);
    }

    @Override
    public boolean isEnabled(IParameterEditor<?> iParameterEditor) {
        IParameter iParameter = iParameterEditor.getParam();
        if (iParameter == null) {
            return true;
        }
        Boolean bl = this.activations.get(iParameter.getName());
        return bl == null ? true : bl;
    }

    @Override
    public String getItemDisplayName(String string, String string2) {
        return string;
    }

    public GamaColor getItemDisplayColor(String string) {
        EditorsCategory editorsCategory = this.categories.get(string);
        return editorsCategory == null ? null : editorsCategory.color();
    }

    private IParameterEditor getEditorForVar(String string) {
        for (Map map : this.sections.values()) {
            for (IParameterEditor iParameterEditor : map.values()) {
                IParameter iParameter = iParameterEditor.getParam();
                if (iParameter == null || !iParameter.getName().equals(string)) continue;
                return iParameterEditor;
            }
        }
        return null;
    }

    public void add(ITopLevelAgent iTopLevelAgent, Collection<? extends IExperimentDisplayable> collection) {
        IScope iScope3 = iTopLevelAgent.getScope();
        for (IExperimentDisplayable iExperimentDisplayable : collection) {
            String[] stringArray;
            String[] stringArray2;
            String[] stringArray3;
            if (iExperimentDisplayable instanceof ICategory) {
                ICategory iCategory = (ICategory)iExperimentDisplayable;
                this.addCategory(iCategory.getName(), iCategory.getColor(iScope3), iCategory.isExpanded(iScope3));
                continue;
            }
            if (iExperimentDisplayable instanceof IParameter) {
                String string;
                int n;
                int n2;
                String[] stringArray4;
                boolean bl;
                IParameter iParameter = (IParameter)iExperimentDisplayable;
                this.addEditor(iExperimentDisplayable, (IParameterEditor)EditorFactory.getInstance().create((IAgent)iTopLevelAgent, iParameter, null));
                stringArray3 = iParameter.getEnablement();
                stringArray2 = iParameter.getDisablement();
                stringArray = iParameter.getRefreshment();
                if (stringArray3.length > 0) {
                    bl = Cast.asBool((IScope)iScope3, (Object)iParameter.getInitialValue(iScope3));
                    stringArray4 = stringArray3;
                    n2 = stringArray3.length;
                    n = 0;
                    while (n < n2) {
                        string = stringArray4[n];
                        this.activations.put(string, bl);
                        ++n;
                    }
                    iParameter.addChangedListener((iScope2, object) -> {
                        String[] stringArray2 = stringArray3;
                        int n = stringArray3.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String string = stringArray2[n2];
                            IParameterEditor iParameterEditor = this.getEditorForVar(string);
                            if (iParameterEditor != null && !iParameterEditor.isDisposed()) {
                                iParameterEditor.setActive(Cast.asBool((IScope)iScope3, (Object)object));
                            }
                            ++n2;
                        }
                    });
                }
                if (stringArray2.length > 0) {
                    bl = Cast.asBool((IScope)iScope3, (Object)iParameter.getInitialValue(iScope3));
                    stringArray4 = stringArray2;
                    n2 = stringArray2.length;
                    n = 0;
                    while (n < n2) {
                        string = stringArray4[n];
                        this.activations.put(string, !bl);
                        ++n;
                    }
                    iParameter.addChangedListener((iScope2, object) -> {
                        String[] stringArray2 = stringArray2;
                        int n = stringArray2.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String string = stringArray2[n2];
                            IParameterEditor iParameterEditor = this.getEditorForVar(string);
                            if (iParameterEditor != null && !iParameterEditor.isDisposed()) {
                                iParameterEditor.setActive(Boolean.valueOf(Cast.asBool((IScope)iScope3, (Object)object) == false));
                            }
                            ++n2;
                        }
                    });
                }
                if (stringArray.length <= 0) continue;
                iParameter.addChangedListener((iScope, object) -> {
                    String[] stringArray2 = stringArray;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = stringArray2[n2];
                        IParameterEditor iParameterEditor = this.getEditorForVar(string);
                        if (iParameterEditor != null) {
                            iParameterEditor.updateWithValueOfParameter(false, true);
                        }
                        ++n2;
                    }
                });
                continue;
            }
            if (iExperimentDisplayable instanceof TextStatement) {
                stringArray3 = (String[])iExperimentDisplayable;
                this.addEditor(iExperimentDisplayable, EditorFactory.getInstance().create(iScope3, (TextStatement)stringArray3));
                continue;
            }
            if (iExperimentDisplayable instanceof MonitorOutput) {
                stringArray2 = (String[])iExperimentDisplayable;
                this.addMonitor(iScope3, (MonitorOutput)stringArray2);
                continue;
            }
            if (!(iExperimentDisplayable instanceof UserCommandStatement)) continue;
            stringArray = (String[])iExperimentDisplayable;
            this.addEditor(iExperimentDisplayable, EditorFactory.getInstance().create(iScope3, (UserCommandStatement)stringArray, arg_0 -> ExperimentsParametersList.lambda$3(iTopLevelAgent, iScope3, (UserCommandStatement)stringArray, arg_0)));
        }
    }

    public MonitorDisplayer addMonitor(IScope iScope, MonitorOutput monitorOutput) {
        MonitorDisplayer monitorDisplayer = EditorFactory.getInstance().create(iScope, monitorOutput);
        this.monitors.put(monitorOutput, monitorDisplayer);
        return monitorDisplayer;
    }

    public MonitorDisplayer removeMonitor(MonitorOutput monitorOutput) {
        return this.monitors.remove(monitorOutput);
    }

    private void addEditor(IExperimentDisplayable iExperimentDisplayable, IParameterEditor iParameterEditor) {
        String string = iExperimentDisplayable.getCategory();
        this.addItem(string);
        ((Map)this.sections.get(string)).put(iExperimentDisplayable.getName(), iParameterEditor);
    }

    public void addCategory(String string, GamaColor gamaColor, boolean bl) {
        this.categories.put(string, new EditorsCategory(string, gamaColor, bl));
    }

    public void addCategory(String string) {
        if (!this.categories.containsKey(string)) {
            this.categories.put(string, new EditorsCategory(string, null, (Boolean)GamaPreferences.Runtime.CORE_EXPAND_PARAMS.getValue()));
        }
    }

    @Override
    public boolean getItemExpanded(String string) {
        EditorsCategory editorsCategory = this.categories.get(string);
        if (editorsCategory == null) {
            return super.getItemExpanded(string);
        }
        return editorsCategory.expanded();
    }

    public boolean addItem(String string) {
        this.addCategory(string);
        if (!this.sections.containsKey(string)) {
            this.sections.put(string, new HashMap());
            return true;
        }
        return false;
    }

    @Override
    public void updateItemValues(boolean bl) {
        for (Map.Entry entry : this.sections.entrySet()) {
            for (IParameterEditor iParameterEditor : ((Map)entry.getValue()).values()) {
                iParameterEditor.updateWithValueOfParameter(bl, false);
            }
        }
        this.updateMonitors(bl);
    }

    public Map<String, Object> getItemValues() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry entry : this.sections.entrySet()) {
            for (IParameterEditor iParameterEditor : ((Map)entry.getValue()).values()) {
                hashMap.put(iParameterEditor.getParam().getName(), iParameterEditor.getCurrentValue());
            }
        }
        return hashMap;
    }

    public void setItemValues(Map<String, Object> map) {
        for (String string : map.keySet()) {
            IParameterEditor iParameterEditor = this.getEditorForVar(string);
            if (iParameterEditor == null) continue;
            iParameterEditor.getParam().setValueNoCheckNoNotification(map.get(string));
            iParameterEditor.updateWithValueOfParameter(false, false);
        }
    }

    public void updateMonitors(boolean bl) {
        this.monitors.forEach((monitorOutput, monitorDisplayer) -> monitorDisplayer.updateWithValueOfParameter(bl, false));
    }

    public Map<String, Runnable> handleMenu(String string, int n, int n2) {
        return null;
    }

    public boolean hasMonitors() {
        return this.monitors.size() > 0;
    }

    public Map<MonitorOutput, MonitorDisplayer> getMonitors() {
        return this.monitors;
    }

    private static /* synthetic */ void lambda$3(ITopLevelAgent iTopLevelAgent, IScope iScope, UserCommandStatement userCommandStatement, SelectionEvent selectionEvent) {
        iTopLevelAgent.executeAction(iScope2 -> {
            Object object = iScope.execute((IExecutable)userCommandStatement).getValue();
            if (iTopLevelAgent.dead()) {
                iTopLevelAgent.getExperiment().getSpecies().refreshAllOutputs();
            }
            return object;
        });
    }
}

