/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.commands;

import com.google.common.collect.Iterables;
import gama.core.common.interfaces.IGamaView;
import gama.core.common.preferences.GamaPreferences;
import gama.core.outputs.LayeredDisplayOutput;
import gama.core.util.tree.GamaNode;
import gama.core.util.tree.GamaTree;
import gama.dev.DEBUG;
import gama.ui.application.workbench.PerspectiveHelper;
import gama.ui.application.workbench.ThemeHelper;
import gama.ui.experiment.commands.LayoutTreeConverter;
import gama.ui.shared.utils.ViewsHelper;
import gama.ui.shared.utils.WorkbenchHelper;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IWorkbenchPart;

public class ArrangeDisplayViews
extends AbstractHandler {
    public static final String LAYOUT_KEY = "gama.displays.layout";
    static final String DISPLAY_INDEX_KEY = "GamaIndex";

    static {
        DEBUG.ON();
    }

    private static EPartService getPartService() {
        return (EPartService)WorkbenchHelper.getService(EPartService.class);
    }

    private static MApplication getApplication() {
        return (MApplication)WorkbenchHelper.getService(MApplication.class);
    }

    private static EModelService getModelService() {
        return (EModelService)WorkbenchHelper.getService(EModelService.class);
    }

    public Object execute(ExecutionEvent executionEvent) {
        ArrangeDisplayViews.execute(GamaPreferences.Displays.LAYOUTS.indexOf(executionEvent.getParameter(LAYOUT_KEY)));
        return true;
    }

    public static void execute(Object object) {
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            ArrangeDisplayViews.execute(LayoutTreeConverter.convert(n));
        } else if (object instanceof GamaTree) {
            GamaTree gamaTree = (GamaTree)object;
            ArrangeDisplayViews.execute((GamaTree<String>)gamaTree);
        } else if (object instanceof GamaNode) {
            GamaNode gamaNode = (GamaNode)object;
            GamaTree<String> gamaTree = LayoutTreeConverter.newLayoutTree();
            gamaNode.attachTo(gamaTree.getRoot());
            ArrangeDisplayViews.execute(gamaTree);
        }
    }

    public static void execute(GamaTree<String> gamaTree) {
        try {
            List<MPlaceholder> list = ArrangeDisplayViews.collectAndPrepareDisplayViews();
            if (gamaTree != null && gamaTree.getRoot().hasChildren()) {
                MPartStack mPartStack;
                GamaNode gamaNode = (GamaNode)gamaTree.getRoot().getChildren().get(0);
                if (gamaNode.getWeight() == null) {
                    gamaNode.setWeight(Integer.valueOf(5000));
                }
                if ((mPartStack = ArrangeDisplayViews.getDisplaysPlaceholder()) == null) {
                    return;
                }
                mPartStack.setToBeRendered(true);
                MElementContainer mElementContainer = mPartStack.getParent();
                mPartStack.getChildren().addAll(list);
                ArrangeDisplayViews.process(mElementContainer, (GamaNode<String>)gamaNode, list);
                ArrangeDisplayViews.showDisplays(mElementContainer, list);
            }
            ArrangeDisplayViews.decorateDisplays();
        }
        catch (Exception exception) {
            DEBUG.ERR((Object)exception);
        }
    }

    public static MPartStack getDisplaysPlaceholder() {
        MUIElement mUIElement = ArrangeDisplayViews.getModelService().find("displays", (MUIElement)ArrangeDisplayViews.getApplication());
        return mUIElement instanceof MPartStack ? (MPartStack)mUIElement : null;
    }

    private static void showDisplays(MElementContainer<?> mElementContainer, List<MPlaceholder> list) {
        mElementContainer.setVisible(true);
        list.forEach(mPlaceholder -> {
            MUIElement mUIElement = mPlaceholder.getRef();
            if (mUIElement instanceof MPart) {
                MPart mPart = (MPart)mUIElement;
                mPlaceholder.setToBeRendered(true);
                mPlaceholder.setVisible(true);
                ArrangeDisplayViews.getPartService().showPart(mPart, EPartService.PartState.VISIBLE);
            }
        });
    }

    public static void decorateDisplays() {
        List list = ViewsHelper.getDisplayViews(null);
        list.forEach(display -> {
            Boolean bl = PerspectiveHelper.keepToolbars();
            if (bl != null) {
                display.showToolbar(bl.booleanValue());
            }
            display.showOverlay(PerspectiveHelper.showOverlays());
        });
        list.forEach(display -> {
            LayeredDisplayOutput layeredDisplayOutput = display.getOutput();
            if (layeredDisplayOutput != null && layeredDisplayOutput.getData().fullScreen() > -1) {
                WorkbenchHelper.runInUI((String)("Expand " + layeredDisplayOutput.getName()), (int)100, iProgressMonitor -> {
                    WorkbenchHelper.getPage().bringToTop((IWorkbenchPart)display);
                    display.showCanvas();
                    display.focusCanvas();
                    display.getOutput().update();
                });
            }
        });
        if (PerspectiveHelper.getBackground() != null) {
            ThemeHelper.changeSashBackground((Color)PerspectiveHelper.getBackground());
            PerspectiveHelper.getActiveSimulationPerspective().setRestoreBackground(ThemeHelper::restoreSashBackground);
        }
        list.forEach(display -> {
            if (display.is2D()) {
                display.focusCanvas();
            }
        });
    }

    public static void process(MElementContainer mElementContainer, GamaNode<String> gamaNode, List<MPlaceholder> list) {
        String string = (String)gamaNode.getData();
        String string2 = String.valueOf(gamaNode.getWeight());
        Boolean bl = !"horizontal".equals(string) && !"vertical".equals(string) ? null : Boolean.valueOf("horizontal".equals(string));
        MPlaceholder mPlaceholder2 = (MPlaceholder)Iterables.find(list, mPlaceholder -> {
            Object v = mPlaceholder.getTransientData().get(DISPLAY_INDEX_KEY);
            return v != null && v.equals(string);
        }, null);
        MElementContainer mElementContainer2 = ArrangeDisplayViews.create(mElementContainer, string2, bl);
        if (mPlaceholder2 != null) {
            if (mElementContainer2.equals(mElementContainer)) {
                mPlaceholder2.setContainerData(string2);
            }
            mElementContainer2.getChildren().add(mPlaceholder2);
        } else {
            for (GamaNode gamaNode2 : gamaNode.getChildren()) {
                ArrangeDisplayViews.process(mElementContainer2, (GamaNode<String>)gamaNode2, list);
            }
        }
    }

    static final List<MPlaceholder> collectAndPrepareDisplayViews() {
        List list = ArrangeDisplayViews.getModelService().findElements((MApplicationElement)ArrangeDisplayViews.getApplication(), MPlaceholder.class, 2, mApplicationElement -> ViewsHelper.isDisplay((String)mApplicationElement.getElementId()));
        int n = 0;
        for (MPlaceholder mPlaceholder : list) {
            IGamaView.Display display = ViewsHelper.findDisplay((String)mPlaceholder.getElementId());
            if (display == null) continue;
            display.setIndex(n++);
            mPlaceholder.getTransientData().put(DISPLAY_INDEX_KEY, String.valueOf(n - 1));
        }
        return list;
    }

    static MElementContainer create(MElementContainer mElementContainer, String string, Boolean bl) {
        MPartSashContainer mPartSashContainer;
        if (bl == null && (mElementContainer instanceof MPartStack || !PerspectiveHelper.keepTabs().booleanValue())) {
            return mElementContainer;
        }
        if (bl != null) {
            mPartSashContainer = MBasicFactory.INSTANCE.createPartSashContainer();
            mPartSashContainer.setHorizontal(bl.booleanValue());
        } else {
            mPartSashContainer = MBasicFactory.INSTANCE.createPartStack();
        }
        mPartSashContainer.setContainerData(string);
        if (mElementContainer != null) {
            mElementContainer.getChildren().add(mPartSashContainer);
        }
        return mPartSashContainer;
    }
}

