/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.controls;

import gama.core.common.IStatusMessage;
import gama.core.common.interfaces.IStatusControl;
import gama.core.common.interfaces.IStatusDisplayer;
import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.kernel.root.PlatformAgent;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.kernel.simulation.SimulationClock;
import gama.core.kernel.simulation.SimulationPopulation;
import gama.core.runtime.GAMA;
import gama.gaml.operators.Strings;
import gama.ui.experiment.controls.SimulationPopupMenu;
import gama.ui.shared.controls.FlatButton;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.resources.IGamaColors;
import gama.ui.shared.utils.WorkbenchHelper;
import java.awt.Color;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;

public class ExperimentControlContribution
extends WorkbenchWindowControlContribution
implements IStatusControl {
    private volatile boolean isUpdating;
    private FlatButton label;
    private SimulationPopupMenu popup;
    private static final int WIDTH = 400;
    private final StringBuilder text = new StringBuilder(2000);

    public ExperimentControlContribution() {
        ((IStatusDisplayer)WorkbenchHelper.getService(IStatusDisplayer.class)).setExperimentTarget((IStatusControl)this);
    }

    public ExperimentControlContribution(String string) {
        super(string);
        ((IStatusDisplayer)WorkbenchHelper.getService(IStatusDisplayer.class)).setExperimentTarget((IStatusControl)this);
    }

    protected int computeWidth(Control control) {
        return 400;
    }

    protected Control createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0x20000000);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).applyTo(composite2);
        this.label = FlatButton.label((Composite)composite2, (GamaColors.GamaUIColor)IGamaColors.NEUTRAL, (String)"No experiment running", (int)400).setImage(GamaIcon.named((String)"overlays/status.clock").image()).withMinimalHeight(24);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).hint(400, 24).applyTo((Control)this.label);
        this.popup = new SimulationPopupMenu(this);
        this.label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                if (ExperimentControlContribution.this.popup.isVisible()) {
                    ExperimentControlContribution.this.popup.hide();
                } else {
                    ITopLevelAgent iTopLevelAgent = GAMA.getCurrentTopLevelAgent();
                    if (!(iTopLevelAgent == null || iTopLevelAgent.dead() || iTopLevelAgent.getScope().isClosed() || iTopLevelAgent.getExperiment() == null || iTopLevelAgent instanceof PlatformAgent)) {
                        WorkbenchHelper.asyncRun(ExperimentControlContribution.this.popup::display);
                    }
                }
            }
        });
        return composite2;
    }

    public boolean isDisposed() {
        return this.label.isDisposed();
    }

    public void setSelection(ITopLevelAgent iTopLevelAgent) {
        if (iTopLevelAgent instanceof IExperimentAgent) {
            IExperimentAgent iExperimentAgent = (IExperimentAgent)iTopLevelAgent;
            GAMA.changeCurrentTopLevelAgent((ITopLevelAgent)iExperimentAgent, (boolean)false);
        } else if (iTopLevelAgent instanceof SimulationAgent) {
            SimulationAgent simulationAgent = (SimulationAgent)iTopLevelAgent;
            GAMA.getExperiment().getAgent().setCurrentSimulation(simulationAgent);
        }
    }

    String popupTextFor(ITopLevelAgent iTopLevelAgent) {
        if (iTopLevelAgent == null) {
            return "";
        }
        this.text.setLength(0);
        SimulationClock simulationClock = iTopLevelAgent.getClock();
        simulationClock.getInfo(this.text).append(Strings.LN);
        this.text.append("Durations: cycle ").append(simulationClock.getDuration()).append("ms; average ").append((int)simulationClock.getAverageDuration()).append("ms; total ").append(simulationClock.getTotalDuration()).append("ms");
        return this.text.toString();
    }

    public Shell getControllingShell() {
        return this.label.getShell();
    }

    public Point getLocation() {
        return this.label.toDisplay(this.label.getLocation());
    }

    public int getWidth() {
        return this.label.getSize().x;
    }

    public int getHeight() {
        return this.label.getSize().y;
    }

    public void updateWith(IStatusMessage iStatusMessage) {
        if (this.isUpdating) {
            return;
        }
        try {
            try {
                this.isUpdating = true;
                if (GAMA.getExperiment() == null) {
                    this.label.removeMenuSign();
                    this.popup.wipe();
                    if (this.popup.isVisible()) {
                        this.popup.hide();
                    }
                } else {
                    this.label.addMenuSign();
                }
                ITopLevelAgent iTopLevelAgent = GAMA.getCurrentTopLevelAgent();
                this.label.setColor(GamaColors.get((Color)iTopLevelAgent.getColor()));
                this.label.setTextWithoutRecomputingSize(this.getClockMessage(iTopLevelAgent));
                if (this.popup.isVisible()) {
                    this.popup.display();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.isUpdating = false;
            }
        }
        finally {
            this.isUpdating = false;
        }
    }

    private String getClockMessage(ITopLevelAgent iTopLevelAgent) {
        int n;
        if (iTopLevelAgent == null) {
            return "";
        }
        if (iTopLevelAgent instanceof PlatformAgent) {
            return "No experiment running";
        }
        IExperimentAgent iExperimentAgent = iTopLevelAgent.getExperiment();
        if (iExperimentAgent == null) {
            return "";
        }
        this.text.setLength(0);
        iTopLevelAgent.getClock().getInfo(this.text);
        SimulationPopulation simulationPopulation = iExperimentAgent.getSimulationPopulation();
        int n2 = n = simulationPopulation == null ? 1 : simulationPopulation.getNumberOfActiveThreads();
        if (iTopLevelAgent.getScope().isOnUserHold()) {
            this.text.append(" (waiting)");
        } else if (n > 1) {
            this.text.append(" (" + n + " threads)");
        }
        IExperimentPlan iExperimentPlan = iExperimentAgent.getSpecies();
        if (iExperimentPlan.shouldBeBenchmarked()) {
            this.text.append(" [benchmarking]");
        }
        return this.text.toString();
    }
}

