/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.commands;

import gama.core.common.interfaces.IGamaView;
import gama.core.common.preferences.GamaPreferences;
import gama.core.util.tree.GamaNode;
import gama.core.util.tree.GamaTree;
import gama.ui.experiment.commands.ArrangeDisplayViews;
import gama.ui.shared.utils.ViewsHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;

public class LayoutTreeConverter {
    public static GamaTree<String> convert(int n) {
        if (n < 0 || n >= GamaPreferences.Displays.LAYOUTS.size()) {
            return null;
        }
        ArrangeDisplayViews.collectAndPrepareDisplayViews();
        int[] nArray = StreamEx.of((Collection)ViewsHelper.getDisplayViews(null)).mapToInt(IGamaView.Display::getIndex).toArray();
        Arrays.sort(nArray);
        GamaTree<String> gamaTree = LayoutTreeConverter.newLayoutTree();
        switch (n) {
            case 0: 
            case 1: {
                return LayoutTreeConverter.buildStackTree(gamaTree, nArray);
            }
            case 2: {
                return LayoutTreeConverter.buildGridTree(gamaTree, nArray);
            }
            case 3: 
            case 4: {
                return LayoutTreeConverter.buildHorizontalOrVerticalTree(gamaTree, nArray, n == 3);
            }
        }
        return null;
    }

    static GamaTree<String> newLayoutTree() {
        return GamaTree.withRoot((Object)"layout");
    }

    static GamaTree<String> buildStackTree(GamaTree<String> gamaTree, int[] nArray) {
        if (nArray.length == 0) {
            return gamaTree;
        }
        GamaNode gamaNode = gamaTree.getRoot().addChild((Object)"stack");
        IntStreamEx.of((int[])nArray).forEach(n -> {
            GamaNode gamaNode2 = gamaNode.addChild((Object)String.valueOf(n), Integer.valueOf(5000));
        });
        return gamaTree;
    }

    static GamaTree<String> buildGridTree(GamaTree<String> gamaTree, int[] nArray) {
        if (nArray.length == 0) {
            return gamaTree;
        }
        GamaNode gamaNode = gamaTree.getRoot().addChild((Object)"horizontal");
        ArrayList<GamaNode<String>> arrayList = new ArrayList<GamaNode<String>>();
        LayoutTreeConverter.buildPlaceholders((GamaNode<String>)gamaNode, arrayList, nArray.length);
        int n = 0;
        for (GamaNode gamaNode2 : arrayList) {
            gamaNode2.setData((Object)String.valueOf(nArray[n++]));
        }
        return gamaTree;
    }

    static void buildPlaceholders(GamaNode<String> gamaNode, List<GamaNode<String>> list, int n) {
        if (n == 0) {
            return;
        }
        if (n == 1) {
            list.add(gamaNode);
        } else {
            int n2 = n / 2;
            String string = "horizontal".equals(gamaNode.getData()) ? "vertical" : "horizontal";
            LayoutTreeConverter.buildPlaceholders((GamaNode<String>)gamaNode.addChild((Object)string, Integer.valueOf(5000)), list, n2);
            LayoutTreeConverter.buildPlaceholders((GamaNode<String>)gamaNode.addChild((Object)string, Integer.valueOf(5000)), list, n - n2);
        }
    }

    static GamaTree<String> buildHorizontalOrVerticalTree(GamaTree<String> gamaTree, int[] nArray, boolean bl) {
        GamaNode gamaNode = gamaTree.getRoot().addChild((Object)(bl ? "horizontal" : "vertical"));
        IntStreamEx.of((int[])nArray).forEach(n -> {
            GamaNode gamaNode2 = gamaNode.addChild((Object)String.valueOf(n), Integer.valueOf(5000));
        });
        return gamaTree;
    }

    public static GamaTree<String> convertCurrentLayout(List<MPlaceholder> list) {
        MPartStack mPartStack = ArrangeDisplayViews.getDisplaysPlaceholder();
        if (mPartStack == null) {
            return null;
        }
        GamaTree<String> gamaTree = LayoutTreeConverter.newLayoutTree();
        LayoutTreeConverter.save((MUIElement)mPartStack.getParent(), list, (GamaNode<String>)gamaTree.getRoot(), null);
        return gamaTree;
    }

    private static String getWeight(MUIElement mUIElement) {
        String string = mUIElement.getContainerData();
        MElementContainer mElementContainer = mUIElement.getParent();
        while (string == null && mElementContainer != null) {
            string = mElementContainer.getContainerData();
        }
        return string;
    }

    private static void save(MUIElement mUIElement2, List<MPlaceholder> list, GamaNode<String> gamaNode, String string) {
        String string2;
        String string3 = string2 = string == null ? LayoutTreeConverter.getWeight(mUIElement2) : string;
        if (mUIElement2 instanceof MPlaceholder && list.contains(mUIElement2)) {
            gamaNode.addChild((Object)String.valueOf(mUIElement2.getTransientData().get("GamaIndex")), Integer.valueOf(LayoutTreeConverter.parseInt(string2)));
        } else if (mUIElement2 instanceof MElementContainer) {
            MElementContainer mElementContainer = (MElementContainer)mUIElement2;
            List<? extends MUIElement> list2 = LayoutTreeConverter.getNonEmptyChildren((MElementContainer<? extends MUIElement>)mElementContainer, list);
            if (list2.size() == 0) {
                return;
            }
            if (list2.size() == 1) {
                LayoutTreeConverter.save(list2.get(0), list, gamaNode, string2);
            } else {
                GamaNode gamaNode2 = gamaNode.addChild((Object)LayoutTreeConverter.prefix(mElementContainer), Integer.valueOf(LayoutTreeConverter.parseInt(string2)));
                list2.forEach(mUIElement -> LayoutTreeConverter.save(mUIElement, list, (GamaNode<String>)gamaNode2, null));
            }
        }
    }

    static int parseInt(String string) {
        try {
            return string == null ? 0 : Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private static String prefix(MElementContainer<?> mElementContainer) {
        return mElementContainer instanceof MPartStack ? "stack" : (mElementContainer instanceof MPartSashContainer ? (((MPartSashContainer)mElementContainer).isHorizontal() ? "horizontal" : "vertical") : "");
    }

    private static boolean isEmpty(MUIElement mUIElement2, List<MPlaceholder> list) {
        if (mUIElement2 instanceof MElementContainer) {
            return StreamEx.of((Collection)((MElementContainer)mUIElement2).getChildren()).allMatch(mUIElement -> LayoutTreeConverter.isEmpty(mUIElement, list));
        }
        return !list.contains(mUIElement2);
    }

    static List<? extends MUIElement> getNonEmptyChildren(MElementContainer<? extends MUIElement> mElementContainer, List<MPlaceholder> list) {
        return ((StreamEx)StreamEx.of((Collection)mElementContainer.getChildren()).filter(mUIElement -> !LayoutTreeConverter.isEmpty(mUIElement, list))).toList();
    }
}

