/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.views.user;

import gama.core.kernel.experiment.IParameter;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.gaml.architecture.user.UserInputStatement;
import gama.gaml.architecture.user.UserPanelStatement;
import gama.gaml.statements.IExecutable;
import gama.gaml.statements.IStatement;
import gama.gaml.statements.UserCommandStatement;
import gama.ui.experiment.parameters.AgentAttributesEditorsList;
import gama.ui.shared.dialogs.AbstractDetailsDialog;
import gama.ui.shared.interfaces.IParameterEditor;
import gama.ui.shared.parameters.AbstractEditor;
import gama.ui.shared.parameters.EditorFactory;
import gama.ui.shared.parameters.EditorsGroup;
import gama.ui.shared.resources.GamaIcon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class UserControlDialog
extends AbstractDetailsDialog {
    public static UserControlDialog current = null;
    private static PreviousDialog previous = null;
    private final List<IStatement> userCommands;
    final IScope scope;

    public UserControlDialog(IScope iScope, UserPanelStatement userPanelStatement) {
        super(null, "[" + iScope.getAgent().getName() + "] " + userPanelStatement.getName(), null, null);
        this.setShellStyle(2132);
        this.userCommands = userPanelStatement.getUserCommands();
        this.scope = iScope;
    }

    public boolean close() {
        previous = new PreviousDialog(this);
        current = null;
        this.scope.setOnUserHold(false);
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (previous == null || !UserControlDialog.previous.name.equals(this.title)) {
            return;
        }
        shell.setLocation(UserControlDialog.previous.location);
        shell.setSize(UserControlDialog.previous.extent);
    }

    public int open() {
        current = this;
        return super.open();
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = (Composite)super.createContents(composite);
        if (previous != null && UserControlDialog.previous.name.equals(this.title) && UserControlDialog.previous.toggled) {
            this.detailsArea = this.createDetailsArea(composite2);
        }
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, "Continue", true);
        this.detailsButton = this.createButton(composite, 13, "Inspect " + this.scope.getAgent().getName() + "...", false);
        this.detailsButton.setImage(GamaIcon.named((String)"views/open.inspector").image());
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        EditorsGroup editorsGroup = new EditorsGroup(composite2);
        for (final IStatement iStatement : this.userCommands) {
            UserInputStatement userInputStatement2;
            if (!(iStatement instanceof UserCommandStatement)) continue;
            List list = ((UserCommandStatement)iStatement).getInputs();
            int n = list.size() > 1 ? list.size() : 1;
            int n2 = list.size() > 0 ? 1 : 3;
            Button button = new Button((Composite)editorsGroup, 8);
            button.setText(iStatement.getName());
            button.setEnabled(((UserCommandStatement)iStatement).isEnabled(this.scope));
            GridData gridData = new GridData(16384, 128, true, true, n2, n);
            button.setLayoutData((Object)gridData);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    UserControlDialog.this.scope.execute((IExecutable)iStatement);
                    GAMA.getExperiment().refreshAllOutputs();
                }
            });
            for (UserInputStatement userInputStatement2 : list) {
                this.scope.addVarWithValue(userInputStatement2.getTempVarName(), userInputStatement2.value(this.scope));
                EditorFactory.create((IScope)this.scope, (EditorsGroup)editorsGroup, (IParameter)userInputStatement2, object -> {
                    userInputStatement2.setValue(this.scope, object);
                    this.scope.execute((IExecutable)userInputStatement2);
                }, (boolean)false);
            }
            userInputStatement2 = new Label((Composite)editorsGroup, 258);
            GridData gridData2 = new GridData(4, 4, true, true, 3, 1);
            userInputStatement2.setLayoutData((Object)gridData2);
        }
        editorsGroup.layout();
        editorsGroup.pack();
        return editorsGroup;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void toggleDetailsArea() {
        Point point = this.getShell().getSize();
        Point point2 = this.cachedWindowSize;
        this.cachedWindowSize = point;
        if (this.detailsArea == null) {
            this.detailsArea = this.createDetailsArea((Composite)this.getContents());
        } else {
            this.detailsArea.dispose();
            this.detailsArea = null;
        }
        Point point3 = this.getContents().getSize();
        Point point4 = this.getContents().computeSize(-1, -1);
        if (point2 == null) {
            point2 = new Point(point.x + point4.x - point3.x, point.y + point4.y - point3.y);
        }
        Point point5 = this.getShell().getLocation();
        Rectangle rectangle = this.getContents().getDisplay().getClientArea();
        if (point2.y > rectangle.height - (point5.y - rectangle.y)) {
            point2.y = rectangle.height - (point5.y - rectangle.y);
        }
        if (point2.x > rectangle.width - (point5.x - rectangle.x)) {
            point2.x = rectangle.width - (point5.x - rectangle.x);
        }
        this.getShell().setSize(point2);
        ((Composite)this.getContents()).layout();
    }

    protected Control createDetailsArea(Composite composite) {
        EditorsGroup editorsGroup = new EditorsGroup(composite, 2052);
        FillLayout fillLayout = new FillLayout();
        editorsGroup.setLayout((Layout)fillLayout);
        IAgent iAgent = this.scope.getAgent();
        AgentAttributesEditorsList agentAttributesEditorsList = new AgentAttributesEditorsList();
        agentAttributesEditorsList.add(new ArrayList(iAgent.getSpecies().getVars()), iAgent);
        Map<String, IParameterEditor<?>> map = agentAttributesEditorsList.getSections().get(iAgent);
        if (map != null) {
            ArrayList arrayList = new ArrayList(map.values());
            Collections.sort(arrayList);
            for (AbstractEditor abstractEditor : arrayList) {
                abstractEditor.createControls(editorsGroup);
            }
        }
        return editorsGroup;
    }

    public static class PreviousDialog {
        final Point location;
        final Point extent;
        final boolean toggled;
        final String name;

        PreviousDialog(UserControlDialog userControlDialog) {
            this.location = userControlDialog.getShell().getLocation();
            this.extent = userControlDialog.getShell().getSize();
            this.toggled = userControlDialog.detailsArea != null;
            this.name = userControlDialog.title;
        }
    }
}

