/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.controls;

import gama.core.common.preferences.GamaPreferences;
import gama.core.kernel.experiment.ExperimentAgent;
import gama.core.runtime.GAMA;
import gama.dev.DEBUG;
import gama.gaml.operators.Maths;
import gama.ui.shared.controls.IPositionChangeListener;
import gama.ui.shared.controls.SimpleSlider;
import gama.ui.shared.interfaces.ISpeedDisplayer;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.IGamaColors;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;

public class SimulationSpeedContributionItem
extends WorkbenchWindowControlContribution
implements ISpeedDisplayer {
    private static SimulationSpeedContributionItem INSTANCE;
    static double max;
    static double lambda;
    protected static final GamaColors.GamaUIColor sliderColor;
    public static final int widthSize = 100;
    public static final int marginWidth = 16;
    public static final int heightSize = 16;
    protected static final List<SimpleSlider> sliders;
    static IPositionChangeListener POSITION_LISTENER;

    static {
        DEBUG.OFF();
        max = 1000.0;
        lambda = 0.3;
        sliderColor = IGamaColors.GRAY_LABEL;
        sliders = new ArrayList<SimpleSlider>();
        POSITION_LISTENER = (simpleSlider, d) -> {
            GAMA.getExperiment().getAgent().setMinimumDurationExternal(Double.valueOf(SimulationSpeedContributionItem.valueFromPosition(d) / 1000.0));
            for (SimpleSlider simpleSlider2 : sliders) {
                simpleSlider2.setToolTipText("Minimum duration of a cycle " + String.valueOf(Maths.opTruncate((Double)(SimulationSpeedContributionItem.valueFromPosition(d) / 1000.0), (Integer)3)) + " s");
                if (simpleSlider2 == simpleSlider) continue;
                simpleSlider2.updateSlider(d, false);
            }
        };
    }

    public static double positionFromValue(double d) {
        if (((Boolean)GamaPreferences.Runtime.CORE_SLIDER_TYPE.getValue()).booleanValue()) {
            return 1.0 - d / max;
        }
        return 1.0 - lambda * Math.log(d / max * (Math.exp(1.0 / lambda) - 1.0) + 1.0);
    }

    protected int computeWidth(Control control) {
        return control.computeSize((int)100, (int)-1, (boolean)true).x;
    }

    public static double valueFromPosition(double d) {
        if (((Boolean)GamaPreferences.Runtime.CORE_SLIDER_TYPE.getValue()).booleanValue()) {
            return max - d * max;
        }
        return (Math.exp((1.0 - d) / lambda) - 1.0) / (Math.exp(1.0 / lambda) - 1.0) * max;
    }

    public SimulationSpeedContributionItem() {
        INSTANCE = this;
    }

    public static int totalWidth() {
        return 132;
    }

    public Control createControl(Composite composite) {
        return SimulationSpeedContributionItem.create(composite);
    }

    public static Control create(Composite composite) {
        Composite composite2 = new Composite(composite, 0x20000001);
        GamaColors.setBackground((Color)composite.getBackground(), (Control[])new Control[]{composite2});
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 16;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = 100;
        gridData.minimumWidth = 100;
        SimpleSlider simpleSlider = new SimpleSlider(composite2, sliderColor.color(), sliderColor.color(), IGamaColors.BLUE.color(), true);
        simpleSlider.setLayoutData((Object)gridData);
        simpleSlider.setSize(100, 16);
        simpleSlider.addPositionChangeListener(POSITION_LISTENER);
        simpleSlider.updateSlider(SimulationSpeedContributionItem.getInitialValue(), false);
        simpleSlider.setBackground(composite.getBackground());
        simpleSlider.addDisposeListener(disposeEvent -> sliders.remove(simpleSlider));
        sliders.add(simpleSlider);
        return composite2;
    }

    protected static double getInitialValue() {
        ExperimentAgent experimentAgent = GAMA.getExperiment() == null ? null : GAMA.getExperiment().getAgent();
        double d = 0.0;
        double d2 = 1000.0;
        if (experimentAgent != null) {
            d = experimentAgent.getMinimumDuration() * 1000.0;
            d2 = experimentAgent.getMaximumDuration() * 1000.0;
        }
        max = d2;
        return SimulationSpeedContributionItem.positionFromValue(d);
    }

    public void setInit(double d, boolean bl) {
        if (d > max) {
            max = d;
        }
        for (SimpleSlider simpleSlider : sliders) {
            if (simpleSlider == null || simpleSlider.isDisposed()) continue;
            simpleSlider.updateSlider(d, bl);
        }
    }

    public void setMaximum(Double d) {
        if (d <= 0.0) {
            d = 1.0;
        }
        max = d;
        for (SimpleSlider simpleSlider : sliders) {
            if (simpleSlider == null || simpleSlider.isDisposed()) continue;
            simpleSlider.updateSlider(d.doubleValue(), false);
        }
    }

    public static SimulationSpeedContributionItem getInstance() {
        return INSTANCE;
    }
}

