/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.views.displays;

import gama.core.common.interfaces.IDisplaySurface;
import gama.core.common.interfaces.ILayer;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.IShape;
import gama.core.outputs.layers.AgentLayer;
import gama.core.outputs.layers.GraphicLayer;
import gama.core.outputs.layers.GridAgentLayer;
import gama.core.outputs.layers.GridLayer;
import gama.core.outputs.layers.GridLayerStatement;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.outputs.layers.ImageLayer;
import gama.core.outputs.layers.MeshLayer;
import gama.core.outputs.layers.OverlayLayer;
import gama.core.outputs.layers.SpeciesLayer;
import gama.core.outputs.layers.SpeciesLayerStatement;
import gama.core.outputs.layers.charts.ChartLayer;
import gama.core.outputs.layers.charts.ChartLayerStatement;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.PlatformHelper;
import gama.core.util.IList;
import gama.gaml.types.Types;
import gama.ui.experiment.menus.AgentsMenu;
import gama.ui.experiment.views.displays.SWTChartEditor;
import gama.ui.shared.menus.GamaMenu;
import gama.ui.shared.menus.MenuAction;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.utils.WorkbenchHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;

public class DisplaySurfaceMenu {
    public static final Map<Class<? extends ILayer>, Image> layer_images = new LinkedHashMap<Class<? extends ILayer>, Image>();
    Menu menu;
    private final IDisplaySurface surface;
    private final Control swtControl;
    private final Function<Menu, Menu> presentationMenu;
    static int MAX_RETRIES;

    static {
        layer_images.put(GridLayer.class, GamaIcon.named((String)"layer/layer.grid").image());
        layer_images.put(GridAgentLayer.class, GamaIcon.named((String)"layer/layer.grid").image());
        layer_images.put(MeshLayer.class, GamaIcon.named((String)"layer/layer.grid").image());
        layer_images.put(AgentLayer.class, GamaIcon.named((String)"layer/layer.agents").image());
        layer_images.put(ImageLayer.class, GamaIcon.named((String)"layer/layer.image").image());
        layer_images.put(OverlayLayer.class, GamaIcon.named((String)"layer/layer.image").image());
        layer_images.put(SpeciesLayer.class, GamaIcon.named((String)"layer/layer.species").image());
        layer_images.put(ChartLayer.class, GamaIcon.named((String)"layer/layer.chart").image());
        layer_images.put(GraphicLayer.class, GamaIcon.named((String)"layer/layer.graphics").image());
        MAX_RETRIES = 10;
    }

    public DisplaySurfaceMenu(IDisplaySurface iDisplaySurface, Control control, Function<Menu, Menu> function) {
        this.surface = iDisplaySurface;
        this.swtControl = control;
        if (iDisplaySurface != null) {
            iDisplaySurface.setMenuManager((Object)this);
        }
        this.presentationMenu = function;
    }

    public void prepareNewMenu(Control control, int n, int n2, boolean bl) {
        this.disposeMenu();
        this.menu = new Menu(control);
        if (bl) {
            this.presentationMenu.apply(this.menu);
            GamaMenu.separate((Menu)this.menu);
        }
    }

    public void buildMenu(int n, int n2, int n3, int n4, List<ILayer> list) {
        if (list.isEmpty()) {
            return;
        }
        LinkedHashSet<IAgent> linkedHashSet = new LinkedHashSet<IAgent>();
        for (ILayer iLayer : list) {
            Set set;
            if (!iLayer.getData().isSelectable().booleanValue() || (set = iLayer.collectAgentsAt(n3, n4, this.surface)).isEmpty()) continue;
            linkedHashSet.addAll(set);
        }
        this.buildMenu(false, n, n2, linkedHashSet, null, new MenuAction[0]);
    }

    public void buildMenu(int n, int n2, IAgent iAgent, Runnable runnable, MenuAction ... menuActionArray) {
        this.buildMenu(false, n, n2, (Collection<IAgent>)(iAgent == null ? Collections.EMPTY_LIST : Collections.singleton(iAgent)), runnable, menuActionArray);
    }

    private void buildMenu(boolean bl, int n, int n2, Collection<IAgent> collection, final Runnable runnable, MenuAction ... menuActionArray) {
        WorkbenchHelper.asyncRun(() -> {
            this.prepareNewMenu(this.swtControl, n, n2, true);
            this.fill(this.menu, -1, true, bl, collection, menuActionArray);
            this.menu.setVisible(true);
            this.retryVisible(this.menu, MAX_RETRIES);
            if (runnable != null) {
                this.menu.addMenuListener((MenuListener)new MenuAdapter(){

                    public void menuHidden(MenuEvent menuEvent) {
                        DisplaySurfaceMenu.this.menu.removeMenuListener((MenuListener)this);
                        runnable.run();
                    }
                });
            }
        });
    }

    public void buildToolbarMenu(SelectionEvent selectionEvent, ToolItem toolItem) {
        this.prepareNewMenu((Control)toolItem.getParent(), toolItem.getBounds().x + toolItem.getBounds().width, toolItem.getBounds().y + toolItem.getBounds().height, false);
        this.fill(this.menu, -1, false, true, null, new MenuAction[0]);
        this.menu.setVisible(true);
    }

    private void retryVisible(Menu menu, int n) {
        if (!PlatformHelper.isLinux()) {
            return;
        }
        WorkbenchHelper.asyncRun(() -> {
            if (!menu.isVisible() && n > 0) {
                menu.setVisible(false);
                Shell shell = new Shell(WorkbenchHelper.getDisplay(), 67680);
                shell.setSize(10, 10);
                shell.setLocation(menu.getShell().getLocation());
                shell.setText("Not visible");
                shell.setVisible(false);
                shell.open();
                shell.dispose();
                menu.getShell().forceActive();
                menu.setVisible(true);
                this.retryVisible(menu, n - 1);
            }
        });
    }

    private void fill(Menu menu, int n, boolean bl, boolean bl2, Collection<IAgent> collection, MenuAction ... menuActionArray) {
        if (bl) {
            AgentsMenu.cascadingAgentMenuItem(menu, (IAgent)this.surface.getScope().getSimulation(), "World", menuActionArray);
            if (collection == null || collection.isEmpty()) {
                return;
            }
            GamaMenu.separate((Menu)menu);
            if (bl2) {
                GamaMenu.separate((Menu)menu, (String)"Layers");
            }
        }
        if (!bl2) {
            if (collection == null || collection.isEmpty() || collection.size() == 1 && collection.contains(this.surface.getScope().getSimulation())) {
                return;
            }
            FocusOnSelection focusOnSelection = new FocusOnSelection(this.surface);
            MenuAction menuAction = new MenuAction((SelectionListener)focusOnSelection, GamaIcon.named((String)"agents/action.focus").image(), "Focus on this display");
            MenuAction[] menuActionArray2 = new MenuAction[menuActionArray.length + 1];
            int n2 = 0;
            while (n2 < menuActionArray.length) {
                menuActionArray2[n2 + 1] = menuActionArray[n2];
                ++n2;
            }
            menuActionArray2[0] = menuAction;
            AgentsMenu.fillPopulationSubMenu(menu, collection, menuActionArray2);
        } else {
            for (ILayer iLayer : this.surface.getManager().getItems()) {
                Object object2;
                boolean bl3 = iLayer.getData().isSelectable();
                boolean bl4 = iLayer.getData().isVisible();
                ILayerStatement iLayerStatement = iLayer.getDefinition();
                IList iList = iLayer.getAgentsForMenu((IScope)this.surface.getScope());
                iList = iList.listValue(null, Types.AGENT, false);
                if (collection != null) {
                    iList.retainAll(collection);
                }
                MenuItem menuItem = new MenuItem(menu, 64);
                menuItem.setText(iLayer.getType() + ": " + iLayer.getName());
                menuItem.setImage(layer_images.get(iLayer.getClass()));
                if (!iLayer.isControllable().booleanValue()) continue;
                Menu menu2 = new Menu(menuItem);
                menuItem.setMenu(menu2);
                GamaMenu.separate((Menu)menu2, (String)"Actions");
                GamaMenu.action((Menu)menu2, (String)(bl4 ? "Hide" : "Show"), selectionEvent -> {
                    iLayer.getData().setVisible(Boolean.valueOf(!bl4));
                    this.surface.updateDisplay(true);
                }, (Image)GamaIcon.named((String)"views/open.inspector").image());
                if (!iList.isEmpty()) {
                    GamaMenu.action((Menu)menu2, (String)(bl3 ? "Forbid selection" : "Allow selection"), selectionEvent -> iLayer.getData().setSelectable(Boolean.valueOf(!bl3)), (Image)GamaIcon.named((String)"layer/layer.selection").image());
                }
                Menu menu3 = GamaMenu.sub((Menu)menu2, (String)"Transparency", (String)"", (Image)GamaIcon.named((String)"layer/layer.transparency").image());
                menu3.setEnabled(iLayer.getData().isDynamic());
                Double d = iLayer.getData().getTransparency(GAMA.getRuntimeScope());
                int n3 = (int)(d == null ? 0L : Math.round(d * 10.0) * 10L);
                int n4 = 0;
                while (n4 <= 100) {
                    double d2 = n4;
                    GamaMenu.check((Menu)menu3, (String)(" " + n4 + "%"), (n3 == n4 ? 1 : 0) != 0, selectionEvent -> {
                        iLayer.getData().setTransparency(d2 / 100.0);
                        this.surface.updateDisplay(true);
                    }, null);
                    n4 += 10;
                }
                if (iLayerStatement instanceof SpeciesLayerStatement) {
                    SpeciesLayerStatement speciesLayerStatement = (SpeciesLayerStatement)iLayerStatement;
                    Menu menu4 = GamaMenu.sub((Menu)menu2, (String)"Aspect", (String)"", (Image)GamaIcon.named((String)"agents/agent.submenu").image());
                    menu4.setEnabled(iLayer.getData().isDynamic());
                    var20_27 = speciesLayerStatement.getAspectName();
                    for (Object object2 : speciesLayerStatement.getAspects()) {
                        GamaMenu.check((Menu)menu4, (String)object2, (boolean)((String)object2).equals(var20_27), arg_0 -> this.lambda$5(speciesLayerStatement, (String)object2, arg_0), null);
                    }
                } else if (iLayerStatement instanceof ChartLayerStatement) {
                    ChartLayerStatement chartLayerStatement = (ChartLayerStatement)iLayerStatement;
                    GamaMenu.action((Menu)menu2, (String)"Properties", selectionEvent -> {
                        Point point = WorkbenchHelper.getDisplay().getCursorLocation();
                        point.x -= 100;
                        point.y += 100;
                        SWTChartEditor sWTChartEditor = new SWTChartEditor(WorkbenchHelper.getDisplay(), ((ChartLayerStatement)iLayerStatement).getChart(), point);
                        sWTChartEditor.open();
                        this.surface.updateDisplay(true);
                    }, (Image)GamaIcon.named((String)"layer/chart.parameters").image());
                    if (chartLayerStatement.keepsHistory()) {
                        GamaMenu.action((Menu)menu2, (String)"Save history...", selectionEvent -> chartLayerStatement.saveHistory(), (Image)GamaIcon.named((String)"views/open.browser").image());
                    }
                } else if (iLayerStatement instanceof GridLayerStatement) {
                    var20_27 = (GridLayerStatement)iLayerStatement;
                    boolean bl5 = ((ILayer.IGridLayer)iLayer).getData().drawLines();
                    GamaMenu.action((Menu)menu2, (String)(bl5 ? "Hide lines" : "Draw lines"), selectionEvent -> {
                        ((ILayer.IGridLayer)iLayer).getData().setDrawLines(Boolean.valueOf(!bl5));
                        this.surface.updateDisplay(true);
                    }, (Image)GamaIcon.named((String)"views/open.browser").image());
                }
                if (!bl3) continue;
                object2 = new FocusOnSelection(this.surface);
                MenuAction menuAction = new MenuAction((SelectionListener)object2, GamaIcon.named((String)"agents/action.focus").image(), "Focus on this display");
                MenuAction[] menuActionArray3 = new MenuAction[]{menuAction};
                Menu menu5 = GamaMenu.sub((Menu)menu2, (String)"Agents", (String)"", (Image)GamaIcon.named((String)"agents/agents.submenu").image());
                AgentsMenu.fillPopulationSubMenu(menu5, (Collection<? extends IAgent>)iList, menuActionArray3);
            }
        }
    }

    public Menu buildROIMenu(int n, int n2, Collection<IAgent> collection, final Map<String, Runnable> map, Map<String, Image> map2) {
        this.prepareNewMenu(this.swtControl, n, n2, true);
        this.fill(this.menu, -1, false, true, collection, new MenuAction[0]);
        int n3 = 0;
        for (final String string : map.keySet()) {
            MenuItem menuItem = new MenuItem(this.menu, 8, n3++);
            menuItem.setText(string);
            menuItem.setImage(map2.get(string));
            menuItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ((Runnable)map.get(string)).run();
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    this.widgetSelected(selectionEvent);
                }
            });
        }
        new MenuItem(this.menu, 2, n3);
        return this.menu;
    }

    public void disposeMenu() {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.menu = null;
    }

    private /* synthetic */ void lambda$5(SpeciesLayerStatement speciesLayerStatement, String string, SelectionEvent selectionEvent) {
        speciesLayerStatement.setAspect(string);
        this.surface.updateDisplay(true);
    }

    private static class FocusOnSelection
    extends SelectionAdapter {
        IDisplaySurface surface;

        FocusOnSelection(IDisplaySurface iDisplaySurface) {
            this.surface = iDisplaySurface;
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            MenuItem menuItem = (MenuItem)selectionEvent.widget;
            IAgent iAgent = (IAgent)menuItem.getData("agent");
            if (iAgent != null && !iAgent.dead()) {
                this.surface.runAndUpdate(() -> {
                    if (!iAgent.dead()) {
                        this.surface.focusOn((IShape)iAgent);
                    }
                });
            }
        }
    }
}

