/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.views.user;

import gama.core.common.interfaces.IGamaView;
import gama.core.kernel.experiment.IParameter;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.gaml.architecture.user.UserInputStatement;
import gama.gaml.architecture.user.UserPanelStatement;
import gama.gaml.statements.IExecutable;
import gama.gaml.statements.IStatement;
import gama.gaml.statements.UserCommandStatement;
import gama.ui.shared.controls.FlatButton;
import gama.ui.shared.parameters.EditorFactory;
import gama.ui.shared.parameters.EditorsGroup;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.resources.IGamaColors;
import gama.ui.shared.utils.ViewsHelper;
import gama.ui.shared.views.GamaViewPart;
import gama.ui.shared.views.toolbar.GamaToolbar2;
import java.awt.Color;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IViewPart;

public class UserControlView
extends GamaViewPart
implements IGamaView.User {
    public static String ID = "gama.ui.application.view.userControlView";
    IScope scope;
    UserPanelStatement panel;
    private Composite body;
    ToolItem inspectItem;
    ToolItem continueItem;

    public void initFor(IScope iScope, UserPanelStatement userPanelStatement) {
        this.panel = userPanelStatement;
        this.scope = iScope;
        if (this.body != null && !this.body.isDisposed()) {
            this.body.dispose();
            this.body = null;
        }
        this.ownCreatePartControl(this.getParentComposite());
        this.getParentComposite().layout();
    }

    private void deactivate(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Composite) {
                this.deactivate((Composite)control);
            } else {
                control.setEnabled(false);
            }
            ++n2;
        }
    }

    public void ownCreatePartControl(Composite composite) {
        if (this.scope == null) {
            return;
        }
        this.inspectItem.setEnabled(true);
        this.continueItem.setEnabled(true);
        this.setPartName("[" + this.scope.getAgent().getName() + " in " + this.scope.getSimulation().getName() + "] " + this.panel.getName());
        composite.setLayout((Layout)new FillLayout());
        this.toolbar.status(null, "User control, agent " + this.scope.getAgent().getName() + ", cycle " + this.scope.getClock().getCycle(), null);
        this.body = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        this.body.setLayout((Layout)gridLayout);
        for (IStatement iStatement : this.panel.getUserCommands()) {
            if (!(iStatement instanceof UserCommandStatement)) continue;
            final UserCommandStatement userCommandStatement = (UserCommandStatement)iStatement;
            EditorsGroup editorsGroup = new EditorsGroup(this.body, 0);
            GridData gridData = new GridData(4, 4, true, false, 3, 1);
            editorsGroup.setLayoutData((Object)gridData);
            List list = userCommandStatement.getInputs();
            int n = list.size() > 1 ? list.size() : 1;
            int n2 = list.size() > 0 ? 1 : 3;
            GamaColors.GamaUIColor gamaUIColor = GamaColors.get((Color)userCommandStatement.getColor(this.scope));
            if (gamaUIColor == null) {
                gamaUIColor = IGamaColors.BLUE;
            }
            Image image = GamaIcon.named((String)(userCommandStatement.isContinue(this.scope) ? "overlays/small.continue" : "overlays/small.exp.run.white")).image();
            FlatButton flatButton = FlatButton.button((Composite)editorsGroup, (GamaColors.GamaUIColor)gamaUIColor, (String)userCommandStatement.getName(), (Image)image);
            flatButton.setEnabled(userCommandStatement.isEnabled(this.scope));
            GridData gridData2 = new GridData(16384, 0x1000000, true, true, n2, n);
            flatButton.setLayoutData((Object)gridData2);
            flatButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    UserControlView.this.scope.execute((IExecutable)userCommandStatement);
                    GAMA.getExperiment().refreshAllOutputs();
                    if (userCommandStatement.isContinue(UserControlView.this.scope)) {
                        UserControlView.this.doContinue();
                    }
                }
            });
            for (UserInputStatement userInputStatement : list) {
                this.scope.addVarWithValue(userInputStatement.getTempVarName(), userInputStatement.value(this.scope));
                EditorFactory.create((IScope)this.scope, (EditorsGroup)editorsGroup, (IParameter)userInputStatement, object -> {
                    userInputStatement.setValue(this.scope, object);
                    this.scope.execute((IExecutable)userInputStatement);
                }, (boolean)false);
            }
        }
    }

    protected void doContinue() {
        this.scope.setOnUserHold(false);
        this.deactivate(this.getParentComposite());
        ViewsHelper.hideView((IViewPart)this);
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        this.scope.setOnUserHold(false);
        super.widgetDisposed(disposeEvent);
    }

    protected GamaViewPart.ViewUpdateUIJob createUpdateJob() {
        return new GamaViewPart.ViewUpdateUIJob(this){

            protected GamaViewPart.UpdatePriority jobPriority() {
                return GamaViewPart.UpdatePriority.HIGH;
            }

            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                UserControlView.this.initFor(UserControlView.this.scope, UserControlView.this.panel);
                return Status.OK_STATUS;
            }
        };
    }

    public void createToolItems(GamaToolbar2 gamaToolbar2) {
        super.createToolItems(gamaToolbar2);
        this.inspectItem = gamaToolbar2.button("views/open.inspector", "Inspect", "Inspect", selectionEvent -> this.scope.getGui().setSelectedAgent(this.scope.getAgent()), 131072);
        this.inspectItem.setEnabled(false);
        this.continueItem = gamaToolbar2.button("experiment/experiment.continue", "Continue", "Continue", selectionEvent -> this.doContinue(), 131072);
        this.continueItem.setEnabled(false);
    }

    protected boolean needsOutput() {
        return false;
    }
}

