/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.experiment.views;

import gama.core.common.interfaces.IGamaView;
import gama.core.common.interfaces.IRuntimeExceptionHandler;
import gama.core.common.interfaces.ItemList;
import gama.core.common.preferences.GamaPreferences;
import gama.core.runtime.GAMA;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.ui.shared.controls.ParameterExpandItem;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.utils.PreferencesHelper;
import gama.ui.shared.utils.WebHelper;
import gama.ui.shared.utils.WorkbenchHelper;
import gama.ui.shared.views.ExpandableItemsView;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ErrorView
extends ExpandableItemsView<GamaRuntimeException>
implements IGamaView.Error {
    public static final String ID = "gama.ui.application.view.ErrorView";
    int numberOfDisplayedErrors = (Integer)GamaPreferences.Runtime.CORE_ERRORS_NUMBER.getValue();
    boolean mostRecentFirst = (Boolean)GamaPreferences.Runtime.CORE_RECENT.getValue();

    protected boolean areItemsClosable() {
        return true;
    }

    public boolean addItem(GamaRuntimeException gamaRuntimeException) {
        this.createItem(this.getParentComposite(), gamaRuntimeException, false, (GamaColors.GamaUIColor)null);
        return true;
    }

    public void displayErrors(boolean bl) {
        if (bl) {
            this.reset();
        } else {
            WorkbenchHelper.run(() -> {
                this.displayItems();
                if (this.getParentComposite() != null && !this.getParentComposite().isDisposed()) {
                    this.getParentComposite().layout(true, true);
                }
            });
        }
    }

    public void ownCreatePartControl(Composite composite) {
    }

    protected ParameterExpandItem createItem(Composite composite, GamaRuntimeException gamaRuntimeException, boolean bl, GamaColors.GamaUIColor gamaUIColor) {
        this.createViewer(composite);
        if (this.getViewer() == null) {
            return null;
        }
        Composite composite2 = this.createItemContentsFor(gamaRuntimeException);
        ParameterExpandItem parameterExpandItem = this.createItem(composite, gamaRuntimeException, composite2, bl, gamaUIColor);
        if (bl) {
            this.createStackTrace(composite2, gamaRuntimeException);
        } else {
            parameterExpandItem.onExpand(() -> this.createStackTrace(composite2, gamaRuntimeException));
        }
        return parameterExpandItem;
    }

    protected Composite createItemContentsFor(GamaRuntimeException gamaRuntimeException) {
        Composite composite = new Composite((Composite)this.getViewer(), 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 5;
        composite.setLayout((Layout)gridLayout);
        return composite;
    }

    private void createStackTrace(Composite composite, final GamaRuntimeException gamaRuntimeException) {
        Table table = new Table(composite, 256);
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GAMA.getGui().editModel((Object)gamaRuntimeException.getEditorContext());
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        GridData gridData = new GridData(4, 4, true, true);
        table.setLayoutData((Object)gridData);
        List list = gamaRuntimeException.getContextAsList();
        table.setForeground(gamaRuntimeException.isWarning() ? GamaColors.get((Color)((Color)PreferencesHelper.WARNING_TEXT_COLOR.getValue())).color() : GamaColors.get((Color)((Color)PreferencesHelper.ERROR_TEXT_COLOR.getValue())).color());
        TableColumn tableColumn = new TableColumn(table, 0);
        for (String string : list) {
            if (string.isBlank()) continue;
            TableItem tableItem = new TableItem(table, 0);
            tableItem.setText(new String[]{string});
        }
        tableColumn.pack();
        table.setSize(table.computeSize(-1, -1));
        table.requestLayout();
        composite.requestLayout();
    }

    public void setFocus() {
    }

    private IRuntimeExceptionHandler getExceptionHandler() {
        return (IRuntimeExceptionHandler)WorkbenchHelper.getService(IRuntimeExceptionHandler.class);
    }

    public void removeItem(GamaRuntimeException gamaRuntimeException) {
        this.getExceptionHandler().remove(gamaRuntimeException);
    }

    public void pauseItem(GamaRuntimeException gamaRuntimeException) {
    }

    public void resumeItem(GamaRuntimeException gamaRuntimeException) {
    }

    public String getItemDisplayName(GamaRuntimeException gamaRuntimeException, String string) {
        StringBuilder stringBuilder = new StringBuilder(300);
        String string2 = gamaRuntimeException.getAgentSummary();
        if (string2 != null) {
            stringBuilder.append(string2).append(" at ");
        }
        stringBuilder.append("cycle ").append(gamaRuntimeException.getCycle()).append(ItemList.SEPARATION_CODE).append(gamaRuntimeException.isWarning() ? ItemList.WARNING_CODE : ItemList.ERROR_CODE).append(gamaRuntimeException.getMessage());
        return stringBuilder.toString();
    }

    public void focusItem(GamaRuntimeException gamaRuntimeException) {
    }

    public List<GamaRuntimeException> getItems() {
        ArrayList<GamaRuntimeException> arrayList = new ArrayList<GamaRuntimeException>();
        List list = this.getExceptionHandler().getCleanExceptions();
        int n = list.size();
        if (n == 0) {
            return arrayList;
        }
        int n2 = n;
        int n3 = n2 - this.numberOfDisplayedErrors;
        n3 = n3 < 0 ? 0 : n3;
        ArrayList arrayList2 = new ArrayList(list);
        arrayList.addAll(arrayList2.subList(n3, n2));
        if (this.mostRecentFirst) {
            Collections.reverse(arrayList);
        }
        return arrayList;
    }

    public void updateItemValues(boolean bl) {
        this.getViewer().updateItemNames();
    }

    public void reset() {
        WorkbenchHelper.run(() -> {
            ErrorView.super.reset();
            this.displayItems();
            if (this.getParentComposite() != null && !this.getParentComposite().isDisposed()) {
                this.getParentComposite().layout(true, true);
            }
        });
    }

    public Map<String, Runnable> handleMenu(GamaRuntimeException gamaRuntimeException, int n, int n2) {
        HashMap<String, Runnable> hashMap = new HashMap<String, Runnable>();
        hashMap.put("Copy error to clipboard", () -> WorkbenchHelper.copy((String)gamaRuntimeException.getAllText()));
        hashMap.put("Show in editor", () -> GAMA.getGui().editModel((Object)gamaRuntimeException.getEditorContext()));
        hashMap.put("Report issue on GitHub", () -> this.reportError(gamaRuntimeException));
        return hashMap;
    }

    private void reportError(GamaRuntimeException gamaRuntimeException) {
        WebHelper.openPage((String)"https://github.com/gama-platform/gama/issues/new");
    }

    protected boolean needsOutput() {
        return false;
    }
}

