/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view.actions;

import gama.ui.application.workspace.WorkspaceModelsManager;
import gama.ui.navigator.view.contents.UserProjectsFolder;
import gama.ui.shared.utils.WorkbenchHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.CopyProjectOperation;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.part.ResourceTransfer;

public class PasteAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.PasteAction";
    private final Shell shell;
    private final Clipboard clipboard;

    public PasteAction(Shell shell, Clipboard clipboard) {
        super(WorkbenchNavigatorMessages.PasteAction_Past_);
        this.shell = shell;
        this.clipboard = clipboard;
        this.setToolTipText(WorkbenchNavigatorMessages.PasteAction_Paste_selected_resource_s_);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "HelpId");
    }

    private IContainer getTarget() {
        List<? extends IResource> list = this.getSelectedResources();
        Iterator<? extends IResource> iterator = list.iterator();
        if (iterator.hasNext()) {
            IResource iResource = iterator.next();
            if (iResource instanceof IProject && !((IProject)iResource).isOpen()) {
                return ResourcesPlugin.getWorkspace().getRoot();
            }
            if (iResource.getType() == 1) {
                return iResource.getParent();
            }
            return (IContainer)iResource;
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private boolean isLinked(IResource[] iResourceArray) {
        IResource[] iResourceArray2 = iResourceArray;
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource iResource = iResourceArray2[n2];
            if (iResource.isLinked()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected List<?> getSelectedNonResources() {
        ArrayList<Object> arrayList = new ArrayList<Object>(super.getSelectedNonResources());
        arrayList.removeIf(object -> object instanceof UserProjectsFolder);
        return arrayList;
    }

    protected List<? extends IResource> getSelectedResources() {
        List list = this.getStructuredSelection().toList();
        boolean bl = this.hasUser(list);
        ArrayList<IWorkspaceRoot> arrayList = new ArrayList<IWorkspaceRoot>(super.getSelectedResources());
        if (bl) {
            arrayList.add(ResourcesPlugin.getWorkspace().getRoot());
        }
        return arrayList;
    }

    private boolean hasUser(List<?> list) {
        boolean bl = false;
        for (Object obj : list) {
            if (!(obj instanceof UserProjectsFolder)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void run() {
        ResourceTransfer resourceTransfer = ResourceTransfer.getInstance();
        IResource[] iResourceArray = (IResource[])this.clipboard.getContents((Transfer)resourceTransfer);
        if (iResourceArray != null && iResourceArray.length > 0) {
            if (iResourceArray[0].getType() == 4) {
                IResource[] iResourceArray2 = iResourceArray;
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource iResource = iResourceArray2[n2];
                    CopyProjectOperation copyProjectOperation = new CopyProjectOperation(this.shell);
                    copyProjectOperation.copyProject((IProject)iResource);
                    ++n2;
                }
            } else {
                IContainer iContainer = this.getTarget();
                CopyFilesAndFoldersOperation copyFilesAndFoldersOperation = new CopyFilesAndFoldersOperation(this.shell);
                copyFilesAndFoldersOperation.copyResources(iResourceArray, iContainer);
            }
            return;
        }
        FileTransfer fileTransfer = FileTransfer.getInstance();
        String[] stringArray = (String[])this.clipboard.getContents((Transfer)fileTransfer);
        if (stringArray != null) {
            IContainer iContainer = this.getTarget();
            if (iContainer == ResourcesPlugin.getWorkspace().getRoot()) {
                PasteAction.handlePaste(stringArray);
                return;
            }
            CopyFilesAndFoldersOperation copyFilesAndFoldersOperation = new CopyFilesAndFoldersOperation(this.shell);
            copyFilesAndFoldersOperation.copyFiles(stringArray, iContainer);
        }
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        boolean bl;
        if (!super.updateSelection(iStructuredSelection)) {
            return false;
        }
        IResource[][] iResourceArrayArray = new IResource[1][];
        this.shell.getDisplay().syncExec(() -> {
            ResourceTransfer resourceTransfer = ResourceTransfer.getInstance();
            iResourceArray[0] = (IResource[])this.clipboard.getContents((Transfer)resourceTransfer);
        });
        IResource[] iResourceArray = iResourceArrayArray[0];
        boolean bl2 = bl = iResourceArray != null && iResourceArray.length > 0 && iResourceArray[0].getType() == 4;
        if (bl) {
            IResource[] iResourceArray2 = iResourceArray;
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource = iResourceArray2[n2];
                if (iResource.getType() != 4 || !((IProject)iResource).isOpen()) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        IContainer iContainer = this.getTarget();
        if (iContainer == null) {
            return false;
        }
        List<? extends IResource> list = this.getSelectedResources();
        if (list.size() > 1) {
            for (IResource iResource3 : list) {
                if (iResource3.getType() == 1 && iContainer.equals((Object)iResource3.getParent())) continue;
                return false;
            }
        }
        if (iResourceArray != null) {
            if (this.isLinked(iResourceArray) && iContainer.getType() != 4 && iContainer.getType() != 2) {
                return false;
            }
            if (iContainer.getType() == 2) {
                IResource[] iResourceArray2 = iResourceArray;
                int n = iResourceArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IResource iResource = iResourceArray2[n3];
                    if (iContainer.equals((Object)iResource)) {
                        return false;
                    }
                    ++n3;
                }
            }
            return true;
        }
        TransferData[] transferDataArray = this.clipboard.getAvailableTypes();
        FileTransfer fileTransfer = FileTransfer.getInstance();
        TransferData[] transferDataArray2 = transferDataArray;
        int n = transferDataArray.length;
        int n3 = 0;
        while (n3 < n) {
            TransferData transferData = transferDataArray2[n3];
            if (fileTransfer.isSupportedType(transferData)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static void handlePaste(String[] stringArray) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                String string = stringArray2[n2];
                File file = new File(string);
                Shell shell = WorkbenchHelper.getWorkbench().getActiveWorkbenchWindow().getShell();
                if (file.isDirectory()) {
                    try {
                        if (WorkspaceModelsManager.instance.isGamaProject(file)) {
                            var6_6 = WorkspaceModelsManager.instance.createOrUpdateProject(file.getName());
                            var8_8 = new CopyFilesAndFoldersOperation(shell);
                            var8_8.setVirtualFolders(false);
                            File[] fileArray = file.listFiles();
                            List<File> list = fileArray == null ? Collections.EMPTY_LIST : Arrays.asList(fileArray);
                            ArrayList<String> arrayList = new ArrayList<String>();
                            for (File file2 : list) {
                                if (".project".equals(file2.getName())) continue;
                                arrayList.add(file2.getAbsolutePath());
                            }
                            var8_8.copyFiles(arrayList.toArray(new String[0]), (IContainer)var6_6);
                            break block9;
                        }
                        var6_6 = WorkspaceModelsManager.instance.createUnclassifiedModelsProject((IPath)new Path(string));
                        var8_8 = new CopyFilesAndFoldersOperation(shell);
                        var8_8.setVirtualFolders(false);
                        var8_8.copyFiles(new String[]{string}, (IContainer)var6_6);
                    }
                    catch (CoreException coreException) {
                        coreException.printStackTrace();
                    }
                } else {
                    try {
                        var6_6 = WorkspaceModelsManager.instance.createUnclassifiedModelsProject((IPath)new Path(string));
                        var8_8 = new CopyFilesAndFoldersOperation(shell);
                        var8_8.setVirtualFolders(false);
                        var8_8.copyFiles(new String[]{string}, (IContainer)var6_6);
                    }
                    catch (CoreException coreException) {
                        coreException.printStackTrace();
                    }
                }
            }
            ++n2;
        }
    }
}

