/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view.contents;

import gama.ui.navigator.view.contents.VirtualContent;
import gama.ui.navigator.view.contents.WrappedResource;
import one.util.streamex.StreamEx;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public abstract class WrappedContainer<C extends IContainer>
extends WrappedResource<VirtualContent<?>, C> {
    int modelsCount = Integer.MAX_VALUE;
    String suffix = null;
    Object[] children;

    public WrappedContainer(VirtualContent<?> virtualContent, C c) {
        super(virtualContent, c);
        this.initializeChildren();
    }

    public void initializeChildren() {
        if (!this.isOpen()) {
            this.children = EMPTY;
            return;
        }
        try {
            Object[] objectArray = ((IContainer)this.getResource()).members();
            int n = objectArray.length;
            this.children = n == 0 ? EMPTY : StreamEx.of((Object[])objectArray).map(iResource -> this.getManager().wrap(this, (IResource)iResource)).toArray(WrappedResource.class);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        this.countModels();
    }

    @Override
    public boolean hasChildren() {
        return this.isOpen() && this.children.length > 0;
    }

    @Override
    public Object[] getNavigatorChildren() {
        return this.children;
    }

    @Override
    public int countModels() {
        if (this.modelsCount == Integer.MAX_VALUE) {
            this.modelsCount = 0;
            this.suffix = null;
            if (this.isOpen()) {
                Object[] objectArray = this.children;
                int n = this.children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    this.modelsCount += ((WrappedResource)object).countModels();
                    ++n2;
                }
                if (this.modelsCount > 0) {
                    this.suffix = this.modelsCount + " model" + (this.modelsCount > 1 ? "s" : "");
                }
            }
        }
        return this.modelsCount;
    }

    public void invalidateModelsCount() {
        this.modelsCount = Integer.MAX_VALUE;
        Object p = this.getParent();
        if (p instanceof WrappedContainer) {
            ((WrappedContainer)p).invalidateModelsCount();
        }
    }

    @Override
    public void getSuffix(StringBuilder stringBuilder) {
        this.countModels();
        if (this.suffix != null) {
            stringBuilder.append(this.suffix);
        }
    }
}

