/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view.contents;

import gama.ui.navigator.view.contents.VirtualContent;
import gama.ui.navigator.view.contents.WrappedContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;

public abstract class WrappedResource<P extends VirtualContent<?>, T extends IResource>
extends VirtualContent<P>
implements IAdaptable {
    static final int NOT_COMPUTED = Integer.MAX_VALUE;
    final T resource;
    int severity = Integer.MAX_VALUE;

    public WrappedResource(P p, T t) {
        super(p, t.getName());
        this.resource = t;
        this.findMaxProblemSeverity();
    }

    public <C> C getAdapter(Class<C> clazz) {
        if (clazz.isInstance(this.resource)) {
            return (C)this.resource;
        }
        return null;
    }

    public T getResource() {
        return this.resource;
    }

    public abstract boolean canBeDecorated();

    public boolean isOpen() {
        return this.resource.isAccessible();
    }

    @Override
    public int findMaxProblemSeverity() {
        if (this.severity == Integer.MAX_VALUE) {
            if (this.isOpen()) {
                try {
                    this.severity = this.resource.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2);
                }
                catch (CoreException coreException) {}
            } else {
                this.severity = -2;
            }
        }
        return this.severity;
    }

    @Override
    public ImageDescriptor getOverlay() {
        return this.canBeDecorated() ? (ImageDescriptor)DESCRIPTORS.get(this.findMaxProblemSeverity()) : null;
    }

    public void invalidateSeverity() {
        this.severity = Integer.MAX_VALUE;
        Object p = this.getParent();
        if (p instanceof WrappedContainer) {
            ((WrappedContainer)p).invalidateSeverity();
        }
    }

    public abstract int countModels();
}

