/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view.actions;

import gama.ui.navigator.view.contents.ResourceManager;
import gama.ui.shared.dialogs.Messages;
import gama.ui.shared.utils.WorkbenchHelper;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.internal.AddFromHistoryAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.history.LocalHistoryPage;
import org.eclipse.team.internal.ui.history.LocalHistoryPageSource;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.team.ui.history.IHistoryPageSource;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceAction;

public class ShowLocalHistory
extends WorkspaceAction {
    boolean isFile;
    AddFromHistoryAction projectAction = new AddFromHistoryAction();
    private IStructuredSelection fSelection;

    protected ShowLocalHistory(IShellProvider iShellProvider) {
        super(iShellProvider, "Local history...");
    }

    public void run() {
        if (!this.isFile) {
            this.projectAction.run(null);
            return;
        }
        IFileState[] iFileStateArray = this.getLocalHistory();
        if (iFileStateArray == null || iFileStateArray.length == 0) {
            return;
        }
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(iProgressMonitor -> {
                IResource iResource = (IResource)this.getSelectedResources().get(0);
                Runnable runnable = () -> {
                    IHistoryView iHistoryView = TeamUI.showHistoryFor((IWorkbenchPage)TeamUIPlugin.getActivePage(), (Object)iResource, (IHistoryPageSource)LocalHistoryPageSource.getInstance());
                    IHistoryPage iHistoryPage = iHistoryView.getHistoryPage();
                    if (iHistoryPage instanceof LocalHistoryPage) {
                        LocalHistoryPage localHistoryPage = (LocalHistoryPage)iHistoryPage;
                        localHistoryPage.setClickAction(this.isCompare());
                    }
                };
                WorkbenchHelper.asyncRun((Runnable)runnable);
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            Messages.error((String)TeamUIMessages.ShowLocalHistory_1);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        this.fSelection = iStructuredSelection;
        this.projectAction.selectionChanged(null, (ISelection)iStructuredSelection);
        this.isFile = this.selectionIsOfType(1);
        if (!this.isFile) {
            return iStructuredSelection.size() == 1 && this.selectionIsOfType(6);
        }
        return true;
    }

    protected boolean isCompare() {
        return false;
    }

    public IStructuredSelection getSelection() {
        return this.fSelection;
    }

    protected IFileState[] getLocalHistory() {
        IFile iFile = ResourceManager.getFile(this.getSelection().getFirstElement());
        IFileState[] iFileStateArray = null;
        try {
            if (iFile != null) {
                iFileStateArray = iFile.getHistory(null);
            }
        }
        catch (CoreException coreException) {
            Messages.error((String)coreException.getMessage());
            return null;
        }
        if (iFileStateArray == null || iFileStateArray.length <= 0) {
            Messages.tell((String)TeamUIMessages.ShowLocalHistory_0);
        }
        return iFileStateArray;
    }

    protected String getPromptTitle() {
        return TeamUIMessages.ShowLocalHistory_2;
    }

    protected String getOperationMessage() {
        return TeamUIMessages.ShowLocalHistory_2;
    }
}

