/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view.actions;

import gama.ui.navigator.view.actions.CopyAction;
import gama.ui.navigator.view.actions.DeleteResourceAction;
import gama.ui.navigator.view.actions.PasteAction;
import gama.ui.shared.resources.GamaIcon;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class EditActionProvider
extends CommonActionProvider {
    private Clipboard clipboard;
    private CopyAction copyAction;
    private DeleteResourceAction deleteAction;
    private PasteAction pasteAction;
    private TextActionHandler textActionHandler;
    private Shell shell;
    private ICommonActionExtensionSite site;

    public void init(ICommonActionExtensionSite iCommonActionExtensionSite) {
        this.site = iCommonActionExtensionSite;
        this.shell = this.site.getViewSite().getShell();
        this.makeActions();
    }

    protected void makeActions() {
        this.clipboard = new Clipboard(this.shell.getDisplay());
        this.pasteAction = new PasteAction(this.shell, this.clipboard);
        this.pasteAction.setImageDescriptor(GamaIcon.named((String)"generic/menu.paste").descriptor());
        this.pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.copyAction = new CopyAction(this.shell, this.clipboard, this.pasteAction);
        this.copyAction.setImageDescriptor(GamaIcon.named((String)"generic/menu.copy").descriptor());
        this.copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        IShellProvider iShellProvider = () -> this.shell;
        this.deleteAction = new DeleteResourceAction(iShellProvider);
        this.deleteAction.setImageDescriptor(GamaIcon.named((String)"generic/menu.delete").descriptor());
        this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        super.dispose();
    }

    public void handleKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.character == '\u007f' && keyEvent.stateMask == 0) {
            if (this.deleteAction.isEnabled()) {
                this.deleteAction.run();
            }
            keyEvent.doit = false;
        }
    }

    public void fillActionBars(IActionBars iActionBars) {
        if (this.textActionHandler == null) {
            this.textActionHandler = new TextActionHandler(iActionBars);
        }
        this.textActionHandler.setCopyAction((IAction)this.copyAction);
        this.textActionHandler.setPasteAction((IAction)this.pasteAction);
        this.textActionHandler.setDeleteAction((IAction)this.deleteAction);
        this.updateActionBars();
        this.textActionHandler.updateActionBars();
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        this.copyAction.selectionChanged(iStructuredSelection);
        iMenuManager.appendToGroup("group.copy", (IAction)this.copyAction);
        this.pasteAction.selectionChanged(iStructuredSelection);
        iMenuManager.appendToGroup("group.copy", (IAction)this.pasteAction);
        this.deleteAction.selectionChanged(iStructuredSelection);
        iMenuManager.appendToGroup("group.copy", (IAction)this.deleteAction);
    }

    public void updateActionBars() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        this.copyAction.selectionChanged(iStructuredSelection);
        this.pasteAction.selectionChanged(iStructuredSelection);
        this.deleteAction.selectionChanged(iStructuredSelection);
    }
}

