/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view.actions;

import gama.core.common.preferences.GamaPreferences;
import gama.core.common.util.FileUtils;
import gama.core.runtime.GAMA;
import gama.core.util.file.IGamaFile;
import gama.gaml.operators.Files;
import gama.ui.navigator.view.contents.WrappedExperimentContent;
import gama.ui.navigator.view.contents.WrappedSyntacticContent;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class GamlActionProvider
extends CommonActionProvider {
    WrappedSyntacticContent selection;
    SelectionListenerAction runAction;
    SelectionListenerAction revealAction;
    SelectionListenerAction setStartupAction;

    public void init(ICommonActionExtensionSite iCommonActionExtensionSite) {
        super.init(iCommonActionExtensionSite);
        this.makeActions();
    }

    private void makeActions() {
        this.runAction = new SelectionListenerAction("Run..."){

            public void run() {
                GamlActionProvider.this.selection.handleDoubleClick();
            }
        };
        this.runAction.setId("run.experiment");
        this.runAction.setEnabled(true);
        this.revealAction = new SelectionListenerAction("Reveal..."){

            public void run() {
                GAMA.getGui().editModel((Object)GamlActionProvider.this.selection.getElement().getElement());
            }
        };
        this.revealAction.setId("reveal.item");
        this.revealAction.setEnabled(true);
        this.setStartupAction = new SelectionListenerAction("Set as startup..."){

            protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
                IGamaFile iGamaFile;
                String string;
                if (!super.updateSelection(iStructuredSelection)) {
                    return false;
                }
                this.setText("Set as startup...");
                if (((Boolean)GamaPreferences.Interface.CORE_STARTUP_MODEL.getValue()).booleanValue() && iStructuredSelection.getFirstElement() instanceof WrappedSyntacticContent && (string = FileUtils.constructAbsoluteFilePath(null, (String)((IFile)((WrappedSyntacticContent)iStructuredSelection.getFirstElement()).getFile().getResource()).getLocation().toOSString(), (boolean)true)) != null && (iGamaFile = (IGamaFile)GamaPreferences.Interface.CORE_DEFAULT_MODEL.getValue()) != null && iGamaFile.exists(null).booleanValue() && iGamaFile.getOriginalPath().equals(string)) {
                    this.setText("Unset as startup...");
                }
                return true;
            }

            public void run() {
                String string = FileUtils.constructAbsoluteFilePath(null, (String)((IFile)GamlActionProvider.this.selection.getFile().getResource()).getLocation().toOSString(), (boolean)true);
                if (string != null) {
                    IGamaFile iGamaFile = (IGamaFile)GamaPreferences.Interface.CORE_DEFAULT_MODEL.getValue();
                    if (((Boolean)GamaPreferences.Interface.CORE_STARTUP_MODEL.getValue()).booleanValue() && iGamaFile != null && iGamaFile.exists(null).booleanValue() && iGamaFile.getOriginalPath().equals(string)) {
                        GamaPreferences.Interface.CORE_STARTUP_MODEL.set((Object)false).save();
                    } else {
                        GamaPreferences.Interface.CORE_STARTUP_MODEL.set((Object)true).save();
                        IGamaFile iGamaFile2 = Files.from(null, (String)string);
                        GamaPreferences.Interface.CORE_DEFAULT_MODEL.setValue(null, (Object)iGamaFile2);
                        GamaPreferences.Interface.CORE_DEFAULT_MODEL.save();
                        GamaPreferences.Interface.CORE_DEFAULT_EXPERIMENT.set((Object)GamlActionProvider.this.selection.getElement().getName()).save();
                    }
                }
            }
        };
        this.setStartupAction.setId("startup.experiment");
        this.setStartupAction.setEnabled(true);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        if (this.selection == null) {
            return;
        }
        iMenuManager.add((IContributionItem)new Separator());
        if (this.selection instanceof WrappedExperimentContent) {
            iMenuManager.appendToGroup("group.copy", (IAction)this.runAction);
            iMenuManager.appendToGroup("group.copy", (IAction)this.setStartupAction);
        }
        iMenuManager.appendToGroup("group.copy", (IAction)this.revealAction);
    }

    public void updateActionBars() {
        StructuredSelection structuredSelection = (StructuredSelection)this.getContext().getSelection();
        if (structuredSelection.isEmpty()) {
            this.selection = null;
            return;
        }
        Object object = structuredSelection.getFirstElement();
        if (!(object instanceof WrappedSyntacticContent)) {
            this.selection = null;
            return;
        }
        this.selection = (WrappedSyntacticContent)object;
        this.runAction.selectionChanged((IStructuredSelection)structuredSelection);
        this.setStartupAction.selectionChanged((IStructuredSelection)structuredSelection);
        this.revealAction.selectionChanged((IStructuredSelection)structuredSelection);
    }
}

