/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view.actions;

import gama.ui.navigator.view.actions.CompareWithEachOtherAction;
import gama.ui.navigator.view.actions.RenameResourceAction;
import gama.ui.navigator.view.actions.ShowLocalHistory;
import gama.ui.shared.resources.GamaIcon;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class RefactorActionProvider
extends CommonActionProvider {
    private RenameResourceAction renameAction;
    private ShowLocalHistory historyAction;
    private CompareWithEachOtherAction compareAction;
    private Shell shell;

    public void init(ICommonActionExtensionSite iCommonActionExtensionSite) {
        this.shell = iCommonActionExtensionSite.getViewSite().getShell();
        this.makeActions();
    }

    protected void makeActions() {
        IShellProvider iShellProvider = () -> this.shell;
        this.renameAction = new RenameResourceAction(iShellProvider);
        this.renameAction.setImageDescriptor(GamaIcon.named((String)"navigator/file.rename").descriptor());
        this.renameAction.setDisabledImageDescriptor(GamaIcon.named((String)"navigator/file.rename").disabledDescriptor());
        this.renameAction.setActionDefinitionId("org.eclipse.ui.edit.rename");
        this.historyAction = new ShowLocalHistory(iShellProvider);
        this.historyAction.setImageDescriptor(GamaIcon.named((String)"navigator/local.history").descriptor());
        this.historyAction.setDisabledImageDescriptor(GamaIcon.named((String)"navigator/local.history").disabledDescriptor());
        this.compareAction = new CompareWithEachOtherAction(iShellProvider);
        this.compareAction.setImageDescriptor(GamaIcon.named((String)"views/layout.horizontal").descriptor());
        this.compareAction.setDisabledImageDescriptor(GamaIcon.named((String)"views/layout.horizontal").disabledDescriptor());
    }

    public void fillActionBars(IActionBars iActionBars) {
        this.updateActionBars();
        iActionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameAction);
    }

    public void handleKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.keyCode == 0x100000B && keyEvent.stateMask == 0) {
            if (this.renameAction.isEnabled()) {
                this.renameAction.run();
            }
            keyEvent.doit = false;
        }
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        boolean bl;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        boolean bl2 = bl = !iStructuredSelection.isEmpty();
        if (bl) {
            this.renameAction.selectionChanged(iStructuredSelection);
            this.historyAction.selectionChanged(iStructuredSelection);
            this.compareAction.selectionChanged(iStructuredSelection);
            iMenuManager.insertBefore("org.eclipse.ui.CopyAction", (IAction)this.renameAction);
            iMenuManager.insertAfter("additions", (IAction)this.historyAction);
            if (iStructuredSelection.size() == 2) {
                iMenuManager.insertAfter("additions", (IAction)this.compareAction);
            }
        }
    }

    public void updateActionBars() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        this.renameAction.selectionChanged(iStructuredSelection);
        this.historyAction.selectionChanged(iStructuredSelection);
        this.compareAction.selectionChanged(iStructuredSelection);
    }
}

