/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.metadata;

import gama.core.util.file.GamaFileMetaData;
import gama.gaml.operators.Strings;
import java.util.HashMap;
import java.util.Map;

public class ImageInfo
extends GamaFileMetaData {
    public static final Map<Integer, String> formatsShortNames = new HashMap<Integer, String>(){
        {
            this.put(0, "BMP");
            this.put(1, "BMP");
            this.put(7, "BMP");
            this.put(2, "GIF");
            this.put(4, "JPEG");
            this.put(5, "PNG");
            this.put(3, "ICO");
            this.put(6, "TIFF");
            this.put(-1, "Unknown Format");
            this.put(8, "ASCII");
            this.put(9, "PGM");
        }
    };
    private final int type;
    private final int width;
    private final int height;

    public ImageInfo(long l, int n, int n2, int n3) {
        super(l);
        this.type = n;
        this.width = n2;
        this.height = n3;
    }

    public ImageInfo(String string) {
        super(string);
        String[] stringArray = this.split(string);
        this.type = Integer.parseInt(stringArray[1]);
        this.width = Integer.parseInt(stringArray[2]);
        this.height = Integer.parseInt(stringArray[3]);
    }

    public String getShortLabel(int n) {
        return formatsShortNames.containsKey(n) ? formatsShortNames.get(n) : formatsShortNames.get(-1);
    }

    public String getSuffix() {
        return this.width + "x" + this.height + ", " + this.getShortLabel(this.type);
    }

    public void appendSuffix(StringBuilder stringBuilder) {
        stringBuilder.append(this.width).append("x").append(this.height).append(" | ").append(this.getShortLabel(this.type));
    }

    public String getDocumentation() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getShortLabel(this.type)).append(" Image File").append(Strings.LN);
        stringBuilder.append("Dimensions: ").append(this.width + " pixels x " + this.height + " pixels").append(Strings.LN);
        return stringBuilder.toString();
    }

    public int getType() {
        return this.type;
    }

    public String toPropertyString() {
        return super.toPropertyString() + "_!_" + this.type + "_!_" + this.width + "_!_" + this.height;
    }
}

