/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view;

import gama.core.runtime.PlatformHelper;
import gama.ui.navigator.view.FileFolderSorter;
import gama.ui.navigator.view.NavigatorCommonViewer;
import gama.ui.navigator.view.NavigatorSearchControl;
import gama.ui.navigator.view.contents.NavigatorRoot;
import gama.ui.navigator.view.contents.Tag;
import gama.ui.navigator.view.contents.TopLevelFolder;
import gama.ui.navigator.view.contents.VirtualContent;
import gama.ui.navigator.view.contents.WrappedContainer;
import gama.ui.navigator.view.contents.WrappedFile;
import gama.ui.navigator.view.contents.WrappedSyntacticContent;
import gama.ui.shared.utils.PreferencesHelper;
import gama.ui.shared.views.toolbar.GamaCommand;
import gama.ui.shared.views.toolbar.GamaToolbar2;
import gama.ui.shared.views.toolbar.GamaToolbarFactory;
import gama.ui.shared.views.toolbar.IToolbarDecoratedView;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.internal.navigator.CommonNavigatorActionGroup;
import org.eclipse.ui.internal.navigator.actions.CollapseAllAction;
import org.eclipse.ui.internal.navigator.actions.LinkEditorAction;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonNavigatorManager;
import org.eclipse.ui.navigator.CommonViewer;

public class GamaNavigator
extends CommonNavigator
implements IToolbarDecoratedView,
ISelectionChangedListener,
IToolbarDecoratedView.Expandable {
    IAction link;
    ToolItem linkItem;
    protected Composite parent;
    protected GamaToolbar2 toolbar;
    private NavigatorSearchControl findControl;
    final GamaCommand byDate = new GamaCommand("mini/tree.sort", "", "Sort by modification date", selectionEvent -> {
        boolean bl = ((ToolItem)selectionEvent.widget).getSelection();
        try {
            IDecoratorManager iDecoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
            iDecoratorManager.setEnabled("gama.ui.application.date.decorator", bl);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        this.getCommonViewer().refresh();
        FileFolderSorter.BY_DATE = bl;
    });
    final GamaCommand linkCommand = new GamaCommand("navigator/editor.link", "", "Stay in sync with the editor", selectionEvent -> this.link.run());

    protected CommonNavigatorManager createCommonManager() {
        CommonNavigatorManager commonNavigatorManager = new CommonNavigatorManager((CommonNavigator)this, this.memento);
        this.getCommonViewer().addPostSelectionChangedListener((ISelectionChangedListener)this);
        return commonNavigatorManager;
    }

    public void createPartControl(Composite composite) {
        IContributionItem iContributionItem;
        this.parent = GamaToolbarFactory.createToolbars((IToolbarDecoratedView)this, (Composite)composite);
        super.createPartControl(this.parent);
        this.restoreState();
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        IContributionItem[] iContributionItemArray = iToolBarManager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            iContributionItem = iContributionItemArray[n2];
            if (iContributionItem instanceof ActionContributionItem) {
                ActionContributionItem actionContributionItem = (ActionContributionItem)iContributionItem;
                IAction iAction = actionContributionItem.getAction();
                if (iAction instanceof LinkEditorAction) {
                    this.link = iAction;
                    iToolBarManager.remove((IContributionItem)actionContributionItem);
                } else if (iAction instanceof CollapseAllAction) {
                    iToolBarManager.remove((IContributionItem)actionContributionItem);
                }
            }
            ++n2;
        }
        this.linkItem.setSelection(this.link.isChecked());
        iToolBarManager.update(true);
        iToolBarManager.insertBefore("toolbar.toggle", (IAction)this.byDate.toCheckAction());
        try {
            iContributionItem = PlatformUI.getWorkbench().getDecoratorManager();
            iContributionItem.setEnabled("gama.ui.application.date.decorator", false);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        this.findControl.initialize();
    }

    public void saveState(IMemento iMemento) {
        if (((Boolean)PreferencesHelper.KEEP_NAVIGATOR_STATE.getValue()).booleanValue()) {
            StringBuilder stringBuilder = new StringBuilder();
            Object[] objectArray = this.getCommonViewer().getExpandedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string;
                Object object = objectArray[n2];
                String string2 = object instanceof WrappedContainer ? ((IContainer)((WrappedContainer)object).getResource()).getFullPath().toString() : (string = object instanceof TopLevelFolder ? ((TopLevelFolder)object).getName() : null);
                if (string != null) {
                    stringBuilder.append(string);
                    stringBuilder.append("@@");
                }
                ++n2;
            }
            if (stringBuilder.length() > 2) {
                stringBuilder.setLength(stringBuilder.length() - 2);
            }
            iMemento.putString("EXPANDED_STATE", stringBuilder.toString());
        }
        super.saveState(iMemento);
    }

    private void restoreState() {
        if (this.memento == null) {
            return;
        }
        String string = this.memento.getString("EXPANDED_STATE");
        if (string == null) {
            return;
        }
        if (((Boolean)PreferencesHelper.KEEP_NAVIGATOR_STATE.getValue()).booleanValue()) {
            VirtualContent[] virtualContentArray;
            String[] stringArray;
            ArrayList<TopLevelFolder> arrayList = new ArrayList<TopLevelFolder>();
            String[] stringArray2 = stringArray = string.split("@@");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                virtualContentArray = stringArray2[n2];
                if (virtualContentArray.startsWith("/")) {
                    var8_8 = NavigatorRoot.getInstance().getManager().findWrappedInstanceOf(ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path((String)virtualContentArray)));
                    if (var8_8 != null) {
                        arrayList.add((TopLevelFolder)var8_8);
                    }
                } else {
                    var8_8 = NavigatorRoot.getInstance().getFolder((String)virtualContentArray);
                    if (var8_8 != null) {
                        arrayList.add((TopLevelFolder)var8_8);
                    }
                }
                ++n2;
            }
            virtualContentArray = arrayList.toArray(new VirtualContent[0]);
            if (virtualContentArray.length > 0) {
                this.getCommonViewer().setExpandedElements(new Object[]{virtualContentArray});
                this.getCommonViewer().setSelection((ISelection)new StructuredSelection((Object)virtualContentArray[virtualContentArray.length - 1]));
            }
        }
    }

    public void selectReveal(ISelection iSelection) {
        Object object;
        Object object2 = this.getCommonViewer().getStructuredSelection().getFirstElement();
        VirtualContent virtualContent = object2 instanceof IResource ? NavigatorRoot.getInstance().getManager().findWrappedInstanceOf(object2) : (VirtualContent)this.getCommonViewer().getStructuredSelection().getFirstElement();
        StructuredSelection structuredSelection = new StructuredSelection();
        if (iSelection instanceof StructuredSelection) {
            structuredSelection = (StructuredSelection)iSelection;
            object = ((StructuredSelection)iSelection).getFirstElement();
            if (object instanceof IResource && (object = NavigatorRoot.getInstance().getManager().findWrappedInstanceOf(object)) != null) {
                structuredSelection = new StructuredSelection(object);
            }
        }
        if (virtualContent instanceof WrappedSyntacticContent && (object = structuredSelection.getFirstElement()) instanceof WrappedFile) {
            if (virtualContent.isContainedIn((VirtualContent)object)) {
                this.getCommonViewer().setSelection((ISelection)new StructuredSelection((Object)virtualContent));
            }
            return;
        }
        if (!structuredSelection.isEmpty()) {
            super.selectReveal((ISelection)structuredSelection);
        }
    }

    protected CommonViewer createCommonViewerObject(Composite composite) {
        return new NavigatorCommonViewer(this.getViewSite().getId(), composite, 770);
    }

    protected Object getInitialInput() {
        return NavigatorRoot.getInstance();
    }

    protected void handleDoubleClick(DoubleClickEvent doubleClickEvent) {
        Object[] objectArray;
        CommonViewer commonViewer;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)doubleClickEvent.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof VirtualContent && ((VirtualContent)object).handleDoubleClick()) {
            if (object instanceof Tag) {
                Tag tag = (Tag)object;
                this.findControl.searchFor(tag.getName());
                return;
            }
        } else {
            super.handleDoubleClick(doubleClickEvent);
        }
        if ((object instanceof WrappedContainer || object instanceof TopLevelFolder) && (commonViewer = this.getCommonViewer()).getExpandedState(object) && (objectArray = ((VirtualContent)object).getNavigatorChildren()).length > 0) {
            commonViewer.reveal(objectArray[objectArray.length - 1]);
        }
    }

    protected ActionGroup createCommonActionGroup() {
        return new CommonNavigatorActionGroup(this, this.getCommonViewer(), this.getLinkHelperService()){

            protected void fillViewMenu(IMenuManager iMenuManager) {
                iMenuManager.removeAll();
            }
        };
    }

    public void createToolItems(GamaToolbar2 gamaToolbar2) {
        this.toolbar = gamaToolbar2;
        gamaToolbar2.noLeftToolbar();
        if (PlatformHelper.isWindows() || PlatformHelper.isLinux()) {
            gamaToolbar2.sep(24, 131072);
            this.findControl = new NavigatorSearchControl(this).fill(this.toolbar.getToolbar(131072));
        } else {
            this.findControl = new NavigatorSearchControl(this).fill(this.toolbar.getToolbar(131072));
            gamaToolbar2.sep(4, 131072);
        }
        this.linkItem = gamaToolbar2.check(this.linkCommand, 131072);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
        VirtualContent virtualContent = iStructuredSelection == null || iStructuredSelection.isEmpty() ? NavigatorRoot.getInstance() : (VirtualContent)iStructuredSelection.getFirstElement();
        virtualContent.handleSingleClick();
    }

    public void expandAll() {
        this.getCommonViewer().expandAll();
    }

    public void collapseAll() {
        this.getCommonViewer().collapseAll();
    }

    public IStructuredSelection getSelection() {
        return this.getCommonViewer().getStructuredSelection();
    }
}

