/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.commands;

import gama.core.runtime.GAMA;
import gama.core.util.file.IFileMetaDataProvider;
import gama.dev.DEBUG;
import gama.ui.application.workspace.WorkspaceModelsManager;
import gama.ui.navigator.metadata.FileMetaDataProvider;
import gama.ui.navigator.view.GamaNavigator;
import gama.ui.navigator.view.contents.NavigatorRoot;
import gama.ui.navigator.view.contents.ResourceManager;
import gama.ui.shared.dialogs.Messages;
import gama.ui.shared.interfaces.IRefreshHandler;
import gama.ui.shared.utils.WorkbenchHelper;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;

public class RefreshHandler
implements IRefreshHandler {
    GamaNavigator navigator;

    private GamaNavigator getNavigator() {
        IWorkbenchPage iWorkbenchPage;
        if (this.navigator == null && (iWorkbenchPage = WorkbenchHelper.getPage()) != null) {
            this.navigator = (GamaNavigator)iWorkbenchPage.findView("gama.ui.application.view.GamaNavigator");
        }
        return this.navigator;
    }

    public void refreshResource(final IResource iResource) {
        if (iResource.getType() == 4) {
            try {
                this.checkLocationDeleted((IProject)iResource);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
                return;
            }
        }
        if (iResource.getType() == 8) {
            IProject[] iProjectArray;
            IProject[] iProjectArray2 = iProjectArray = ((IWorkspaceRoot)iResource).getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject iProject = iProjectArray2[n2];
                try {
                    this.checkLocationDeleted(iProject);
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                    return;
                }
                ++n2;
            }
        }
        WorkbenchHelper.runInUI((String)("Refreshing " + iResource.getName()), (int)0, iProgressMonitor -> {
            FileMetaDataProvider.getInstance().storeMetaData(iResource, null, true);
            FileMetaDataProvider.getInstance().getMetaData(iResource, false, true);
            this.getNavigator().getCommonViewer().refresh(ResourceManager.getInstance().findWrappedInstanceOf(iResource), true);
            WorkspaceJob workspaceJob = new WorkspaceJob("Refreshing " + iResource.getName()){

                public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) throws CoreException {
                    iResource.refreshLocal(2, iProgressMonitor);
                    iResource.getParent().refreshLocal(2, iProgressMonitor);
                    return Status.OK_STATUS;
                }
            };
            workspaceJob.schedule();
        });
    }

    public void completeRefresh(List<? extends IResource> list) {
        final IStatus[] iStatusArray = new IStatus[]{Status.OK_STATUS};
        final List<IWorkspaceRoot> list2 = list == null || list.isEmpty() ? Collections.singletonList(ResourcesPlugin.getWorkspace().getRoot()) : list;
        final WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor iProgressMonitor) {
                try {
                    for (IResource iResource : list2) {
                        try {
                            if (iResource.getType() == 4) {
                                RefreshHandler.this.checkLocationDeleted((IProject)iResource);
                            } else if (iResource.getType() == 8) {
                                IProject[] iProjectArray;
                                IProject[] iProjectArray2 = iProjectArray = ((IWorkspaceRoot)iResource).getProjects();
                                int n = iProjectArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IProject iProject = iProjectArray2[n2];
                                    RefreshHandler.this.checkLocationDeleted(iProject);
                                    ++n2;
                                }
                            }
                            iResource.refreshLocal(2, iProgressMonitor);
                            if (iProgressMonitor != null) {
                                iProgressMonitor.worked(1);
                            }
                        }
                        catch (CoreException coreException) {}
                        if (iProgressMonitor == null || !iProgressMonitor.isCanceled()) continue;
                        throw new OperationCanceledException();
                    }
                }
                finally {
                    if (iProgressMonitor != null) {
                        iProgressMonitor.done();
                    }
                }
            }
        };
        WorkspaceJob workspaceJob = new WorkspaceJob("Refreshing the GAMA Workspace"){

            public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) throws CoreException {
                try {
                    try {
                        IResource iResource2;
                        ResourceManager.block();
                        iProgressMonitor.beginTask("Refreshing GAMA Workspace: updating the library of models", 100);
                        DEBUG.LOG((Object)"Refreshing GAMA Workspace: updating the library of models");
                        WorkspaceModelsManager.instance.loadModelsLibrary();
                        iProgressMonitor.beginTask("Refreshing GAMA Workspace: recreating files metadata", 1000);
                        DEBUG.LOG((Object)"Refreshing GAMA Workspace: recreating files metadata");
                        for (IResource iResource2 : list2) {
                            iResource2.accept(iResourceProxy -> {
                                IFileMetaDataProvider iFileMetaDataProvider = GAMA.getGui().getMetaDataProvider();
                                IResource iResource = iResourceProxy.requestResource();
                                iFileMetaDataProvider.storeMetaData(iResource, null, true);
                                iFileMetaDataProvider.getMetaData((Object)iResource, false, true);
                                iProgressMonitor.worked(1);
                                return true;
                            }, 0);
                        }
                        iProgressMonitor.beginTask("Refreshing GAMA Workspace: refreshing resources", list2.size());
                        DEBUG.LOG((Object)"Refreshing GAMA Workspace: refreshing resources");
                        workspaceModifyOperation.run(iProgressMonitor);
                        iProgressMonitor.beginTask("Refreshing GAMA Workspace: deleting virtual folders caches", 1);
                        DEBUG.LOG((Object)"Refreshing GAMA Workspace: deleting virtual folders caches");
                        NavigatorRoot.getInstance().resetVirtualFolders(NavigatorRoot.getInstance().getManager());
                        iProgressMonitor.beginTask("Refreshing GAMA Workspace: refreshing the navigator", 1);
                        DEBUG.LOG((Object)"Refreshing GAMA Workspace: deleting virtual folders caches");
                        iResource2 = ResourcesPlugin.getWorkspace();
                        iProgressMonitor.beginTask("Refreshing GAMA Workspace: rebuilding models", 100);
                        try {
                            iResource2.build(15, (IProgressMonitor)new ProgressMonitorWrapper(iProgressMonitor){});
                        }
                        catch (CoreException coreException) {
                            coreException.printStackTrace();
                        }
                    }
                    catch (Exception exception) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        ResourceManager.unblock(iProgressMonitor);
                        WorkbenchHelper.refreshNavigator();
                        iProgressMonitor.done();
                        return iStatus;
                    }
                }
                finally {
                    ResourceManager.unblock(iProgressMonitor);
                    WorkbenchHelper.refreshNavigator();
                    iProgressMonitor.done();
                }
                return iStatusArray[0];
            }
        };
        workspaceJob.setUser(true);
        workspaceJob.schedule();
    }

    void checkLocationDeleted(IProject iProject) throws CoreException {
        if (!iProject.exists()) {
            return;
        }
        IFileInfo iFileInfo = IDEResourceInfoUtils.getFileInfo((URI)iProject.getLocationURI());
        if (!iFileInfo.exists() && Messages.confirm((String)"Project location has been deleted", (String)("The location for project " + iProject.getName() + " (" + iFileInfo.toString() + ") has been deleted. Do you want to remove " + iProject.getName() + " from the workspace ?"))) {
            iProject.delete(true, true, null);
        }
    }
}

