/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view.actions;

import gama.ui.navigator.metadata.FileMetaDataProvider;
import gama.ui.navigator.view.GamaNavigator;
import gama.ui.navigator.view.contents.ResourceManager;
import gama.ui.shared.dialogs.Messages;
import gama.ui.shared.interfaces.IRefreshHandler;
import gama.ui.shared.utils.WorkbenchHelper;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;

public class RefreshAction
extends WorkspaceAction {
    GamaNavigator navigator;
    public static final String ID = "org.eclipse.ui.RefreshAction";
    public List<? extends IResource> resources;

    private GamaNavigator getNavigator() {
        IWorkbenchPage iWorkbenchPage;
        if (this.navigator == null && (iWorkbenchPage = WorkbenchHelper.getPage()) != null) {
            this.navigator = (GamaNavigator)iWorkbenchPage.findView("gama.ui.application.view.GamaNavigator");
        }
        return this.navigator;
    }

    public RefreshAction(IShellProvider iShellProvider) {
        super(iShellProvider, IDEWorkbenchMessages.RefreshAction_text);
        this.initAction();
    }

    private void initAction() {
        this.setToolTipText(IDEWorkbenchMessages.RefreshAction_toolTip);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.refresh_action_context");
    }

    void checkLocationDeleted(IProject iProject) throws CoreException {
        if (!iProject.exists()) {
            return;
        }
        IFileInfo iFileInfo = IDEResourceInfoUtils.getFileInfo((URI)iProject.getLocationURI());
        if (!iFileInfo.exists() && Messages.confirm((String)"Project location has been deleted", (String)("The location for project " + iProject.getName() + " (" + iFileInfo.toString() + ") has been deleted. Do you want to remove " + iProject.getName() + " from the workspace ?"))) {
            iProject.delete(true, true, null);
        }
    }

    protected String getOperationMessage() {
        return IDEWorkbenchMessages.RefreshAction_progressMessage;
    }

    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.RefreshAction_problemMessage;
    }

    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.RefreshAction_problemTitle;
    }

    protected List<? extends IResource> getSelectedResources() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (IResource iResource : super.getSelectedResources()) {
            if (!iResource.isAccessible()) continue;
            arrayList.add(iResource);
        }
        if (arrayList.isEmpty()) {
            arrayList.add(ResourcesPlugin.getWorkspace().getRoot());
        }
        return arrayList;
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        this.resources = this.getSelectedResources();
        return true;
    }

    public final void refreshAll() {
        IStructuredSelection iStructuredSelection = this.getStructuredSelection();
        this.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY);
        this.run();
        this.selectionChanged(iStructuredSelection);
    }

    protected final IRunnableWithProgress createOperation(IStatus[] iStatusArray) {
        return new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor iProgressMonitor) {
                try {
                    for (IResource iResource : RefreshAction.this.resources) {
                        try {
                            RefreshAction.this.refreshResource(iResource, null);
                        }
                        catch (CoreException coreException) {}
                        if (!iProgressMonitor.isCanceled()) continue;
                        throw new OperationCanceledException();
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
    }

    protected void refreshResource(IResource iResource, IProgressMonitor iProgressMonitor2) throws CoreException {
        if (iResource.getType() == 4) {
            this.checkLocationDeleted((IProject)iResource);
        } else if (iResource.getType() == 8) {
            IProject[] iProjectArray;
            IProject[] iProjectArray2 = iProjectArray = ((IWorkspaceRoot)iResource).getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject iProject = iProjectArray2[n2];
                this.checkLocationDeleted(iProject);
                ++n2;
            }
        }
        iResource.refreshLocal(2, iProgressMonitor2);
        iResource.getParent().refreshLocal(2, iProgressMonitor2);
        WorkbenchHelper.runInUI((String)("Refreshing " + iResource.getName()), (int)0, iProgressMonitor -> {
            FileMetaDataProvider.getInstance().storeMetaData(iResource, null, true);
            FileMetaDataProvider.getInstance().getMetaData(iResource, false, true);
            this.getNavigator().getCommonViewer().refresh(ResourceManager.getInstance().findWrappedInstanceOf(iResource), true);
        });
    }

    public void run() {
        if (super.getSelectedResources().isEmpty()) {
            WorkspaceJob workspaceJob = new WorkspaceJob("Refreshing the GAMA Workspace"){

                public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) throws CoreException {
                    IRefreshHandler iRefreshHandler = (IRefreshHandler)WorkbenchHelper.getService(IRefreshHandler.class);
                    if (iRefreshHandler != null) {
                        iRefreshHandler.completeRefresh(RefreshAction.this.resources);
                    }
                    return Status.OK_STATUS;
                }
            };
            workspaceJob.setUser(true);
            workspaceJob.schedule();
        } else {
            super.run();
        }
    }
}

