/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view.contents;

import gama.ui.navigator.view.contents.NavigatorRoot;
import gama.ui.navigator.view.contents.ResourceManager;
import gama.ui.navigator.view.contents.TopLevelFolder;
import gama.ui.navigator.view.contents.WrappedProject;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.GamaIcon;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class VirtualContent<P extends VirtualContent<?>> {
    public static final ILabelProvider DEFAULT_LABEL_PROVIDER = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();
    public static final Map<Integer, ImageDescriptor> DESCRIPTORS = new HashMap<Integer, ImageDescriptor>(){
        {
            this.put(-2, GamaIcon.named((String)"navigator/overlays/overlay.closed").descriptor());
            this.put(-1, GamaIcon.named((String)"navigator/overlays/overlay.ok").descriptor());
            this.put(0, GamaIcon.named((String)"navigator/overlays/overlay.ok").descriptor());
            this.put(1, GamaIcon.named((String)"navigator/overlays/overlay.warning").descriptor());
            this.put(2, GamaIcon.named((String)"navigator/overlays/overlay.error").descriptor());
            this.put(-3, GamaIcon.named((String)"navigator/overlays/overlay.ok").descriptor());
            this.put(-4, GamaIcon.named((String)"navigator/overlays/overlay.error").descriptor());
        }
    };
    public static final int NO_PROBLEM = -1;
    public static final int CLOSED = -2;
    public static final int LINK_OK = -3;
    public static final int LINK_BROKEN = -4;
    public static final int WEBLINK_OK = -5;
    public static final int WEBLINK_BROKEN = -6;
    public static final Object[] EMPTY = new Object[0];
    private final P root;
    private final String name;

    public VirtualContent(P p, String string) {
        this.root = p;
        this.name = string;
    }

    public ResourceManager getManager() {
        return NavigatorRoot.getInstance().getManager();
    }

    public abstract VirtualContentType getType();

    public boolean handleDoubleClick() {
        return false;
    }

    public boolean handleSingleClick() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public P getParent() {
        return this.root;
    }

    public abstract boolean hasChildren();

    public abstract Object[] getNavigatorChildren();

    public abstract ImageDescriptor getImageDescriptor();

    public org.eclipse.swt.graphics.Color getColor() {
        return null;
    }

    public abstract void getSuffix(StringBuilder var1);

    public abstract int findMaxProblemSeverity();

    public abstract ImageDescriptor getOverlay();

    public TopLevelFolder getTopLevelFolder() {
        P p = this.getParent();
        if (p != null) {
            return ((VirtualContent)p).getTopLevelFolder();
        }
        return null;
    }

    public WrappedProject getProject() {
        P p = this.getParent();
        if (p != null) {
            return ((VirtualContent)p).getProject();
        }
        return null;
    }

    public String getStatusMessage() {
        return this.getName();
    }

    public String getStatusTooltip() {
        return this.getStatusMessage();
    }

    public Image getStatusImage() {
        ImageDescriptor imageDescriptor = this.getImageDescriptor();
        return imageDescriptor == null ? null : imageDescriptor.createImage();
    }

    public GamaColors.GamaUIColor getStatusColor() {
        return GamaColors.get((Color)Color.LIGHT_GRAY);
    }

    public boolean isContainedIn(VirtualContent<?> virtualContent) {
        if (this.root == null) {
            return false;
        }
        return this.root == virtualContent || ((VirtualContent)this.root).isContainedIn(virtualContent);
    }

    public static enum VirtualContentType {
        ROOT,
        VIRTUAL_FOLDER,
        PROJECT,
        FOLDER,
        FILE,
        FILE_REFERENCE,
        CATEGORY,
        GAML_ELEMENT;

    }
}

