/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view.contents;

import gama.core.common.GamlFileExtension;
import gama.core.runtime.GAMA;
import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.core.util.file.GamlFileInfo;
import gama.core.util.file.IGamaFileMetaData;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.ast.ISyntacticElement;
import gama.gaml.descriptions.IExpressionDescription;
import gama.ui.navigator.view.NavigatorContentProvider;
import gama.ui.navigator.view.contents.Category;
import gama.ui.navigator.view.contents.Tags;
import gama.ui.navigator.view.contents.VirtualContent;
import gama.ui.navigator.view.contents.WrappedContainer;
import gama.ui.navigator.view.contents.WrappedExperimentContent;
import gama.ui.navigator.view.contents.WrappedFile;
import gama.ui.navigator.view.contents.WrappedModelContent;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.utils.PreferencesHelper;
import java.util.ArrayList;
import java.util.Collection;
import one.util.streamex.StreamEx;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;

public class WrappedGamaFile
extends WrappedFile {
    boolean isExperiment;
    IMap<String, Integer> uriProblems;

    public WrappedGamaFile(WrappedContainer<?> wrappedContainer, IFile iFile) {
        super(wrappedContainer, iFile);
        this.computeURIProblems();
    }

    public void computeURIProblems() {
        try {
            IMarker[] iMarkerArray;
            this.uriProblems = null;
            IMarker[] iMarkerArray2 = iMarkerArray = ((IFile)this.getResource()).findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker iMarker = iMarkerArray2[n2];
                String string = iMarker.getAttribute("URI_KEY", "UNKNOWN");
                int n3 = iMarker.getAttribute("severity", 0);
                if (this.uriProblems == null) {
                    this.uriProblems = GamaMapFactory.createUnordered();
                }
                this.uriProblems.put((Object)string, (Object)n3);
                ++n2;
            }
        }
        catch (CoreException coreException) {}
    }

    @Override
    public boolean canBeDecorated() {
        return true;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public Object[] getNavigatorChildren() {
        if (NavigatorContentProvider.FILE_CHILDREN_ENABLED) {
            return this.getFileChildren();
        }
        return EMPTY;
    }

    @Override
    public boolean isGamaFile() {
        return true;
    }

    @Override
    public int countModels() {
        return 1;
    }

    @Override
    protected void computeFileImage() {
        this.image = this.isExperiment ? GamaIcon.named((String)"navigator/files/file.experiment").descriptor() : GamaIcon.named((String)"navigator/files/file.model").descriptor();
    }

    @Override
    protected void computeFileType() {
        IFile iFile = (IFile)this.getResource();
        this.isExperiment = GamlFileExtension.isExperiment((String)iFile.getName());
    }

    public boolean hasTag(String string) {
        IGamaFileMetaData iGamaFileMetaData = GAMA.getGui().getMetaDataProvider().getMetaData(this.getResource(), false, false);
        if (iGamaFileMetaData instanceof GamlFileInfo) {
            for (String string2 : ((GamlFileInfo)iGamaFileMetaData).getTags()) {
                if (!string2.contains(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object[] getFileChildren() {
        IGamaFileMetaData iGamaFileMetaData = GAMA.getGui().getMetaDataProvider().getMetaData(this.getResource(), false, false);
        if (iGamaFileMetaData instanceof GamlFileInfo) {
            Object object2;
            GamlFileInfo gamlFileInfo = (GamlFileInfo)iGamaFileMetaData;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (((Boolean)PreferencesHelper.NAVIGATOR_OUTLINE.getValue()).booleanValue()) {
                object2 = ((IFile)this.getResource()).getFullPath().toOSString();
                ISyntacticElement iSyntacticElement2 = GAML.getContents((URI)URI.createPlatformResourceURI((String)object2, (boolean)true));
                if (iSyntacticElement2 != null) {
                    if (!GamlFileExtension.isExperiment((String)object2)) {
                        arrayList.add(new WrappedModelContent(this, iSyntacticElement2));
                    }
                    iSyntacticElement2.visitExperiments(iSyntacticElement -> {
                        IExpressionDescription iExpressionDescription = iSyntacticElement.getExpressionAt("virtual");
                        if (iExpressionDescription == null || !iExpressionDescription.equalsString("true")) {
                            arrayList.add(new WrappedExperimentContent(this, iSyntacticElement));
                        }
                    });
                }
            } else {
                for (Object object2 : gamlFileInfo.getExperiments()) {
                    arrayList.add(new WrappedExperimentContent(this, (String)object2));
                }
            }
            if (!gamlFileInfo.getImports().isEmpty() && ((Category)(object2 = new Category(this, gamlFileInfo.getImports(), "Imports"))).getNavigatorChildren().length > 0) {
                arrayList.add(object2);
            }
            if (!gamlFileInfo.getUses().isEmpty() && ((Category)(object2 = new Category(this, gamlFileInfo.getUses(), "Uses"))).getNavigatorChildren().length > 0) {
                arrayList.add(object2);
            }
            if (!gamlFileInfo.getTags().isEmpty() && ((Tags)(object2 = new Tags(this, StreamEx.of((Collection)gamlFileInfo.getTags()).toMap(string -> "Double-click to search"), "Tags"))).getNavigatorChildren().length > 0) {
                arrayList.add(object2);
            }
            return arrayList.toArray();
        }
        return VirtualContent.EMPTY;
    }

    public int getURIProblem(URI uRI) {
        if (uRI == null || this.uriProblems == null) {
            return -1;
        }
        String string = uRI.toString();
        int[] nArray = new int[]{-1};
        this.uriProblems.forEachPair((string2, n) -> {
            if (string2.startsWith(string)) {
                nArray[0] = n;
                return false;
            }
            return true;
        });
        return nArray[0];
    }
}

