/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.wizards;

import gama.ui.navigator.wizards.AbstractNewModelWizard;
import gama.ui.navigator.wizards.AbstractNewModelWizardPage;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class NewExperimentWizardPage
extends AbstractNewModelWizardPage {
    Text modelChooser;
    String typeOfExperiment = "GUI";
    private FilteredResourcesSelectionDialog dialog;

    public NewExperimentWizardPage(ISelection iSelection) {
        super(iSelection);
        this.setTitle("Experiment file");
        this.setDescription("This wizard creates a new experiment file.");
    }

    @Override
    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.createContainerSection(composite2);
        this.createLabel(composite2, "Model to experiment on:");
        Composite composite3 = new Composite(composite2, 0);
        this.applyGridData((Control)composite3, 2);
        GridLayout gridLayout = new GridLayout(2, false);
        composite3.setLayout((Layout)gridLayout);
        this.modelChooser = new Text(composite3, 2060);
        this.modelChooser.setBackground(composite3.getBackground());
        this.applyGridData((Control)this.modelChooser, 1);
        this.modelChooser.addModifyListener(modifyEvent -> this.dialogChanged());
        Button button = new Button(composite3, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewExperimentWizardPage.this.handleBrowse();
            }
        });
        this.createFileNameSection(composite2);
        this.createAuthorSection(composite2);
        this.createNameSection(composite2);
        this.createLabel(composite2, "&Type of Experiment:");
        Composite composite4 = new Composite(composite2, 0);
        FillLayout fillLayout = new FillLayout();
        composite4.setLayout((Layout)fillLayout);
        this.applyGridData((Control)composite4, 2);
        Arrays.asList("GUI", "Headless").forEach(string -> {
            Button button = new Button(composite4, 16);
            button.setText(string);
            if ("GUI".equals(string)) {
                button.setSelection(true);
            }
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    NewExperimentWizardPage.this.typeOfExperiment = ((Button)selectionEvent.widget).getText();
                    NewExperimentWizardPage.this.updateStatus(null);
                    NewExperimentWizardPage.this.dialogChanged();
                    NewExperimentWizardPage.this.setDescription("GUI".equals(NewExperimentWizardPage.this.typeOfExperiment) ? "Creates a new experiment with a graphical user interface" : "Creates a new experiment intended to be used in headless runs");
                }
            });
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)composite2);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.modelChooser.setText("");
    }

    String getType() {
        return this.typeOfExperiment;
    }

    void handleBrowse() {
        Object[] objectArray;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.dialog = new FilteredResourcesSelectionDialog(this.getShell(), false, (IContainer)iWorkspaceRoot, 1);
        this.dialog.setInitialPattern("*.gaml");
        this.dialog.setTitle("Choose a gaml model in project " + iWorkspaceRoot.getName());
        if (this.dialog.open() == 0 && (objectArray = this.dialog.getResult()).length == 1) {
            IResource iResource = (IResource)objectArray[0];
            this.modelChooser.setText(iResource.getFullPath().toString());
        }
    }

    public String getExperimentedModelPath() {
        return this.modelChooser.getText();
    }

    @Override
    public String getExtension() {
        return ".experiment";
    }

    @Override
    public String gamlType() {
        return "Experiment";
    }

    @Override
    public String getTemplateType() {
        return "experiment";
    }

    @Override
    public String getTemplatePath() {
        return AbstractNewModelWizard.TEMPLATES.get(this.getTemplateType());
    }

    @Override
    public boolean createDoc() {
        return false;
    }
}

