/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.wizards;

import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class NewProjectWizardPage
extends WizardPage {
    String initialProjectFieldValue;
    boolean isTest;
    boolean createNewModel = true;
    Text projectNameField;
    private final Listener nameModifyListener = event -> {
        boolean bl = this.validatePage();
        this.setPageComplete(bl);
    };
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;

    public NewProjectWizardPage(String string) {
        super(string);
        this.setPageComplete(false);
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.initializeDialogUnits((Control)composite);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        this.createProjectNameGroup(composite2);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
    }

    private final void createProjectNameGroup(Composite composite) {
        final Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 0);
        label.setText("&Project name:");
        this.projectNameField = new Text(composite2, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.projectNameField.setLayoutData((Object)gridData);
        final Button button = new Button(composite2, 32);
        final Button button2 = new Button(composite2, 32);
        button.setText("Configure as a test project");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewProjectWizardPage.this.isTest = button.getSelection();
                if (NewProjectWizardPage.this.isTest) {
                    button2.setText("Create a new test experiment file");
                } else {
                    button2.setText("Create a new model file");
                }
                composite2.layout();
            }
        });
        button2.setText("Create a new model file");
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewProjectWizardPage.this.createNewModel = button2.getSelection();
            }
        });
        button2.setSelection(this.createNewModel);
        if (this.initialProjectFieldValue != null) {
            this.projectNameField.setText(this.initialProjectFieldValue);
        }
        this.projectNameField.addListener(24, this.nameModifyListener);
    }

    public boolean isTest() {
        return this.isTest;
    }

    public boolean createNewModel() {
        return this.createNewModel;
    }

    public URI getLocationURI() {
        return Platform.getLocation().addTrailingSeparator().append(this.getProjectName()).toFile().toURI();
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getProjectName() {
        return this.projectNameField == null ? this.initialProjectFieldValue : this.getProjectNameFieldValue();
    }

    private String getProjectNameFieldValue() {
        return this.projectNameField == null ? "" : this.projectNameField.getText().trim();
    }

    public void setInitialProjectName(String string) {
        this.initialProjectFieldValue = string == null ? null : string.trim();
    }

    protected boolean validatePage() {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        String string = this.getProjectNameFieldValue();
        if ("".equals(string)) {
            this.setErrorMessage(null);
            this.setMessage("Project name is empty");
            return false;
        }
        IStatus iStatus = iWorkspace.validateName(string, 4);
        if (!iStatus.isOK()) {
            this.setErrorMessage(iStatus.getMessage());
            return false;
        }
        IProject iProject = this.getProjectHandle();
        if (iProject.exists()) {
            this.getProjectHandle();
            this.setErrorMessage("Project already exists");
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.projectNameField.setFocus();
        }
    }
}

