/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view.contents;

import gama.core.runtime.GAMA;
import gama.core.util.file.GamaShapeFile;
import gama.core.util.file.IGamaFileMetaData;
import gama.gaml.compilation.kernel.GamaBundleLoader;
import gama.gaml.compilation.kernel.GamaMetaModel;
import gama.ui.navigator.metadata.FileMetaDataProvider;
import gama.ui.navigator.view.NavigatorContentProvider;
import gama.ui.navigator.view.contents.Tags;
import gama.ui.navigator.view.contents.VirtualContent;
import gama.ui.navigator.view.contents.WrappedContainer;
import gama.ui.navigator.view.contents.WrappedResource;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.utils.PreferencesHelper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class WrappedFile
extends WrappedResource<WrappedResource<?, ?>, IFile> {
    WrappedFile fileParent;
    boolean isShapeFile;
    boolean isShapeFileSupport;
    ImageDescriptor image;
    Color color;

    public WrappedFile(WrappedContainer<?> wrappedContainer, IFile iFile) {
        super(wrappedContainer, iFile);
        this.computeFileType();
        this.computeFileParent();
    }

    protected void computeFileImage() {
        IFile iFile = (IFile)this.getResource();
        this.image = GamaBundleLoader.HANDLED_FILE_EXTENSIONS.contains(iFile.getFileExtension()) ? (this.isShapeFileSupport ? GamaIcon.named((String)"navigator/files/file.shapesupport").descriptor() : ImageDescriptor.createFromImage((Image)DEFAULT_LABEL_PROVIDER.getImage((Object)iFile))) : GamaIcon.named((String)"navigator/files/file.text").descriptor();
    }

    protected void computeFileType() {
        IFile iFile = (IFile)this.getResource();
        this.isShapeFile = "gama.ui.shapefile.type".equals(FileMetaDataProvider.getContentTypeId(iFile));
        this.isShapeFileSupport = "gama.ui.shapefile.support.type".equals(FileMetaDataProvider.getContentTypeId(iFile));
    }

    private void computeFileParent() {
        IResource iResource;
        if (this.isShapeFileSupport && (iResource = FileMetaDataProvider.shapeFileSupportedBy((IFile)this.getResource())) != null) {
            this.fileParent = (WrappedFile)this.getManager().findWrappedInstanceOf(iResource);
        }
    }

    @Override
    public WrappedResource<?, ?> getParent() {
        if (this.fileParent != null) {
            return this.fileParent;
        }
        return (WrappedResource)super.getParent();
    }

    @Override
    public boolean canBeDecorated() {
        return false;
    }

    @Override
    public boolean hasChildren() {
        return this.isShapeFile;
    }

    @Override
    public Object[] getNavigatorChildren() {
        if (NavigatorContentProvider.FILE_CHILDREN_ENABLED && (this.isGamaFile() || this.isShapeFile)) {
            return this.getFileChildren();
        }
        return EMPTY;
    }

    public Object[] getFileChildren() {
        IFile iFile = (IFile)this.getResource();
        try {
            GamaShapeFile.ShapeInfo shapeInfo;
            Map map;
            IResource iResource;
            IContainer iContainer = iFile.getParent();
            ArrayList<VirtualContent> arrayList = new ArrayList<VirtualContent>();
            Object object = iContainer.members();
            int n = ((IResource[])object).length;
            int n2 = 0;
            while (n2 < n) {
                iResource = object[n2];
                if (iResource instanceof IFile && FileMetaDataProvider.isSupport(iFile, (IFile)iResource)) {
                    arrayList.add(this.getManager().findWrappedInstanceOf(iResource));
                }
                ++n2;
            }
            iResource = GAMA.getGui().getMetaDataProvider().getMetaData((Object)iFile, false, false);
            if (iResource instanceof GamaShapeFile.ShapeInfo && !(map = (shapeInfo = (GamaShapeFile.ShapeInfo)iResource).getAttributes()).isEmpty()) {
                object = new LinkedHashMap(map);
                map.forEach((arg_0, arg_1) -> this.lambda$0((Map)object, arg_0, arg_1));
                Tags tags = new Tags(this, (Map<String, String>)object, "Attributes");
                if (tags.getNavigatorChildren().length > 0) {
                    arrayList.add(tags);
                }
            }
            return arrayList.toArray();
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
            return VirtualContent.EMPTY;
        }
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        if (this.image == null) {
            this.computeFileImage();
        }
        return this.image;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void getSuffix(StringBuilder stringBuilder) {
        IGamaFileMetaData iGamaFileMetaData;
        if (((Boolean)PreferencesHelper.NAVIGATOR_METADATA.getValue()).booleanValue() && (iGamaFileMetaData = GAMA.getGui().getMetaDataProvider().getMetaData(this.getResource(), false, true)) != null) {
            iGamaFileMetaData.appendSuffix(stringBuilder);
        }
    }

    @Override
    public int countModels() {
        return 0;
    }

    public boolean isGamaFile() {
        return false;
    }

    @Override
    public VirtualContent.VirtualContentType getType() {
        return VirtualContent.VirtualContentType.FILE;
    }

    private /* synthetic */ void lambda$0(Map map, String string, String string2) {
        if (GamaMetaModel.getAgentSpeciesDescription().hasAttribute(string)) {
            map.put(string, (String)map.get(string) + " <- built-in attribute of agents");
            this.color = GamaColors.system((int)4);
        }
    }
}

