/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.wizards;

import gama.ui.navigator.view.contents.ResourceManager;
import gama.ui.shared.utils.WorkbenchHelper;
import java.net.InetAddress;
import javax.lang.model.SourceVersion;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public abstract class AbstractNewModelWizardPage
extends WizardPage {
    protected final ISelection selection;
    protected Text containerText;
    protected Text fileText;
    protected Text authorText;
    protected Text nameText;
    protected String templatePath;

    protected AbstractNewModelWizardPage(ISelection iSelection) {
        super("wizardPage");
        this.selection = iSelection;
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public abstract String getTemplateType();

    public String getFileName() {
        return this.fileText.getText();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.containerText.getText().isEmpty()) {
            WorkbenchHelper.asyncRun(this::handleContainerBrowse);
        }
        if (bl) {
            this.fileText.setFocus();
        }
    }

    public String getAuthor() {
        return this.authorText.getText();
    }

    public String getModelName() {
        return this.nameText.getText();
    }

    public static String getComputerFullName() {
        String string = System.getProperty("user.name");
        if (string == null || string.isEmpty()) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                string = inetAddress.getHostName();
            }
            catch (Exception exception) {}
        }
        return string;
    }

    protected void handleContainerBrowse() {
        Object[] objectArray;
        ContainerSelectionDialog containerSelectionDialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select a project or a folder");
        if (containerSelectionDialog.open() == 0 && (objectArray = containerSelectionDialog.getResult()).length == 1) {
            this.containerText.setText(((Path)objectArray[0]).toString());
        }
    }

    protected void updateStatus(String string) {
        this.setErrorMessage(string);
        this.setPageComplete(string == null);
    }

    protected void initialize() {
        IContainer iContainer = this.findContainer();
        if (iContainer != null) {
            this.containerText.setText(iContainer.getFullPath().toString());
            this.fileText.setText(this.getInitialFileName());
        } else {
            this.fileText.setText(this.getDefaultFileBody() + this.getExtension());
        }
    }

    protected String getInitialFileName() {
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        if (iResource instanceof IContainer) {
            IFile iFile = null;
            int n = 0;
            while ((iFile = ((IContainer)iResource).getFile((IPath)new Path(this.getInitialModelFileName(n++)))).exists()) {
            }
            return iFile.getName();
        }
        return this.getDefaultFileBody() + this.getExtension();
    }

    protected String getInitialModelFileName(int n) {
        String string = this.getDefaultFileBody();
        String string2 = this.getExtension();
        return string + (n == 0 ? "" : String.valueOf(n)) + string2;
    }

    protected String getDefaultFileBody() {
        return "New " + this.gamlType();
    }

    protected IContainer findContainer() {
        IResource iResource;
        Object object = null;
        if (this.selection instanceof IStructuredSelection && !this.selection.isEmpty()) {
            object = ((IStructuredSelection)this.selection).getFirstElement();
        }
        if ((iResource = ResourceManager.getResource(object)) == null) {
            return null;
        }
        if (iResource instanceof IProject) {
            iResource = ((IProject)iResource).getFolder(this.getInnerDefaultFolder());
        }
        if (iResource instanceof IContainer) {
            return (IContainer)iResource;
        }
        return iResource.getParent();
    }

    protected String getInnerDefaultFolder() {
        return "models";
    }

    Label createLabel(Composite composite, String string) {
        Label label = new Label(composite, string == null ? 0 : 131072);
        GridData gridData = new GridData(0x1000008, 0x1000000, false, false);
        label.setLayoutData((Object)gridData);
        label.setText(string == null ? " " : string);
        return label;
    }

    public void createAuthorSection(Composite composite) {
        this.createLabel(composite, "&Author:");
        this.authorText = new Text(composite, 2052);
        this.applyGridData((Control)this.authorText, 2);
        this.authorText.setText(AbstractNewModelWizardPage.getComputerFullName());
        this.authorText.addModifyListener(modifyEvent -> this.dialogChanged());
    }

    public void createContainerSection(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.verticalSpacing = 20;
        this.createLabel(composite, "&Container:");
        Composite composite2 = new Composite(composite, 0);
        this.applyGridData((Control)composite2, 2);
        gridLayout = new GridLayout(2, false);
        composite2.setLayout((Layout)gridLayout);
        this.containerText = new Text(composite2, 2052);
        this.applyGridData((Control)this.containerText, 1);
        this.containerText.addModifyListener(modifyEvent -> this.dialogChanged());
        Button button = new Button(composite2, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AbstractNewModelWizardPage.this.handleContainerBrowse();
            }
        });
    }

    public void createNameSection(Composite composite) {
        this.createLabel(composite, this.gamlType() + " name:");
        this.nameText = new Text(composite, 2052);
        this.applyGridData((Control)this.nameText, 2);
        this.nameText.setText("New " + this.gamlType());
        this.nameText.addModifyListener(modifyEvent -> this.dialogChanged());
    }

    void applyGridData(Control control, int n) {
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(n, 1).minSize(-1, 20).applyTo(control);
    }

    public void createFileNameSection(Composite composite) {
        this.createLabel(composite, "&File name:");
        this.fileText = new Text(composite, 2052);
        this.applyGridData((Control)this.fileText, 2);
        this.fileText.addModifyListener(modifyEvent -> {
            Text text = (Text)modifyEvent.getSource();
            String string = text.getText();
            int n = string.lastIndexOf(this.getExtension());
            if (n > 0) {
                this.nameText.setText(string.substring(0, n).replaceAll("[^\\p{Alnum}]", ""));
            }
            this.dialogChanged();
        });
    }

    public void dialogChanged() {
        IFile iFile;
        if (this.getContainerName().length() == 0) {
            this.updateStatus("The name of the containing folder must be specified");
            return;
        }
        String string = this.getFileName();
        if (string.length() == 0) {
            this.updateStatus("The name of the file must be specified");
            return;
        }
        if (string.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus("The name of the file is not valid");
            return;
        }
        if (!string.endsWith(this.getExtension())) {
            this.updateStatus("The file extension must be '" + this.getExtension() + "'");
            return;
        }
        String string2 = this.getAuthor();
        if (string2.length() == 0) {
            this.updateStatus("The name of the author must be specified");
            return;
        }
        String string3 = this.getModelName();
        if (string3.length() == 0) {
            this.updateStatus("The name of the " + this.gamlType() + " must be specified");
            return;
        }
        if (!SourceVersion.isName(string3)) {
            this.updateStatus("The name of the " + this.gamlType() + " is not a proper identifier");
            return;
        }
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        if (iResource instanceof IContainer && (iFile = ((IContainer)iResource).getFile((IPath)new Path(string))).exists()) {
            this.updateStatus("A file with the same name already exists");
            return;
        }
        this.updateStatus(null);
    }

    public abstract void createControl(Composite var1);

    public abstract String getExtension();

    public abstract String gamlType();

    public abstract boolean createDoc();

    public String getTemplatePath() {
        return this.templatePath;
    }
}

