/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view;

import gama.ui.navigator.view.FileFolderSorter;
import gama.ui.navigator.view.NavigatorCommonViewer;
import gama.ui.navigator.view.NavigatorSearchControl;
import gama.ui.navigator.view.contents.NavigatorRoot;
import gama.ui.navigator.view.contents.Tag;
import gama.ui.navigator.view.contents.TopLevelFolder;
import gama.ui.navigator.view.contents.VirtualContent;
import gama.ui.navigator.view.contents.WrappedContainer;
import gama.ui.navigator.view.contents.WrappedFile;
import gama.ui.navigator.view.contents.WrappedSyntacticContent;
import gama.ui.shared.menus.GamaMenu;
import gama.ui.shared.utils.PreferencesHelper;
import gama.ui.shared.views.toolbar.GamaCommand;
import gama.ui.shared.views.toolbar.GamaToolbar2;
import gama.ui.shared.views.toolbar.GamaToolbarFactory;
import gama.ui.shared.views.toolbar.GamaToolbarSimple;
import gama.ui.shared.views.toolbar.IToolbarDecoratedView;
import java.util.ArrayList;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.navigator.CommonNavigatorActionGroup;
import org.eclipse.ui.internal.navigator.actions.LinkEditorAction;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonNavigatorManager;
import org.eclipse.ui.navigator.CommonViewer;

public class GamaNavigator
extends CommonNavigator
implements IToolbarDecoratedView,
ISelectionChangedListener,
IToolbarDecoratedView.Expandable {
    ToolItem linkItem;
    ToolItem sortItem;
    protected Composite parent;
    protected GamaToolbar2 toolbar;
    private PropertyDialogAction properties;
    private NavigatorSearchControl findControl;
    private LinkEditorAction toggleLinkingAction;
    final GamaCommand byDate = new GamaCommand("editor/lexical.sort", "", "Sort by modification date", selectionEvent -> {
        boolean bl = this.sortItem.getSelection();
        try {
            IDecoratorManager iDecoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
            iDecoratorManager.setEnabled("gama.ui.application.date.decorator", !bl);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        FileFolderSorter.BY_DATE = !bl;
        this.getCommonViewer().refresh();
    });

    protected CommonNavigatorManager createCommonManager() {
        CommonNavigatorManager commonNavigatorManager = new CommonNavigatorManager((CommonNavigator)this, this.memento);
        this.getCommonViewer().addPostSelectionChangedListener((ISelectionChangedListener)this);
        return commonNavigatorManager;
    }

    protected ActionGroup createCommonActionGroup() {
        return new CommonNavigatorActionGroup(this, this.getCommonViewer(), this.getLinkHelperService()){

            protected void fillToolBar(IToolBarManager iToolBarManager) {
                iToolBarManager.removeAll();
            }

            protected void fillViewMenu(IMenuManager iMenuManager) {
                iMenuManager.removeAll();
            }
        };
    }

    public void createPartControl(Composite composite) {
        this.parent = GamaToolbarFactory.createToolbars((IToolbarDecoratedView)this, (Composite)composite);
        super.createPartControl(this.parent);
        this.restoreState();
        this.sortItem = this.toolbar.check(this.byDate, 131072);
        this.sortItem.setSelection(true);
        this.toggleLinkingAction = new LinkEditorAction((CommonNavigator)this, this.getCommonViewer(), this.getLinkHelperService());
        IHandlerService iHandlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        iHandlerService.activateHandler(this.toggleLinkingAction.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.toggleLinkingAction));
        GamaCommand gamaCommand = new GamaCommand("navigator/editor.link", "", "Stay in sync with the editor", selectionEvent -> this.toggleLinkingAction.run());
        this.linkItem = this.toolbar.check(gamaCommand, 131072);
        this.linkItem.setSelection(this.toggleLinkingAction.isChecked());
        GamaToolbarSimple gamaToolbarSimple = this.toolbar.getToolbar(131072);
        gamaToolbarSimple.button("editor/local.menu", "More...", "More options", selectionEvent -> {
            GamaMenu gamaMenu = new GamaMenu(){

                protected void fillMenu() {
                    boolean bl = (Boolean)PreferencesHelper.NAVIGATOR_METADATA.getValue();
                    GamaCommand.build(null, (String)(bl ? "Hide metadata" : "Display metadata"), (String)"Hide or display the metadata attached to the different categories of file", selectionEvent -> PreferencesHelper.NAVIGATOR_METADATA.setValue(null, (Object)(!bl ? 1 : 0))).toItem(this.mainMenu);
                    boolean bl2 = (Boolean)PreferencesHelper.NAVIGATOR_HIDDEN.getValue();
                    GamaCommand.build(null, (String)(bl2 ? "Hide hidden files" : "Show hidden files"), (String)"Hide or display the files considered as 'hidden' by the OS", selectionEvent -> PreferencesHelper.NAVIGATOR_HIDDEN.setValue(null, (Object)(!bl2 ? 1 : 0))).toItem(this.mainMenu);
                    boolean bl3 = (Boolean)PreferencesHelper.NAVIGATOR_OUTLINE.getValue();
                    GamaCommand.build(null, (String)(bl3 ? "Hide GAML outlines" : "Show GAML outlines"), (String)"Hide or display the outline of GAML files", selectionEvent -> PreferencesHelper.NAVIGATOR_OUTLINE.setValue(null, (Object)(!bl3 ? 1 : 0))).toItem(this.mainMenu);
                }
            };
            gamaMenu.open((Control)gamaToolbarSimple, selectionEvent, gamaToolbarSimple.getSize().y, 100);
        });
        try {
            IDecoratorManager iDecoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
            iDecoratorManager.setEnabled("gama.ui.application.date.decorator", false);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        this.properties = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)this.getSite().getShell()), this.getSite().getSelectionProvider());
        this.findControl.initialize();
    }

    public void saveState(IMemento iMemento) {
        if (((Boolean)PreferencesHelper.KEEP_NAVIGATOR_STATE.getValue()).booleanValue()) {
            StringBuilder stringBuilder = new StringBuilder();
            Object[] objectArray = this.getCommonViewer().getExpandedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string;
                Object object = objectArray[n2];
                String string2 = object instanceof WrappedContainer ? ((IContainer)((WrappedContainer)object).getResource()).getFullPath().toString() : (string = object instanceof TopLevelFolder ? ((TopLevelFolder)object).getName() : null);
                if (string != null) {
                    stringBuilder.append(string);
                    stringBuilder.append("@@");
                }
                ++n2;
            }
            if (stringBuilder.length() > 2) {
                stringBuilder.setLength(stringBuilder.length() - 2);
            }
            iMemento.putString("EXPANDED_STATE", stringBuilder.toString());
        }
        super.saveState(iMemento);
    }

    private void restoreState() {
        VirtualContent[] virtualContentArray;
        String[] stringArray;
        if (this.memento == null) {
            return;
        }
        String string = this.memento.getString("EXPANDED_STATE");
        if (string == null) {
            return;
        }
        ArrayList<TopLevelFolder> arrayList = new ArrayList<TopLevelFolder>();
        String[] stringArray2 = stringArray = string.split("@@");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            virtualContentArray = stringArray2[n2];
            if (virtualContentArray.startsWith("/")) {
                var8_8 = NavigatorRoot.getInstance().getManager().findWrappedInstanceOf(ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path((String)virtualContentArray)));
                if (var8_8 != null) {
                    arrayList.add((TopLevelFolder)var8_8);
                }
            } else {
                var8_8 = NavigatorRoot.getInstance().getFolder((String)virtualContentArray);
                if (var8_8 != null) {
                    arrayList.add((TopLevelFolder)var8_8);
                }
            }
            ++n2;
        }
        virtualContentArray = arrayList.toArray(new VirtualContent[0]);
        if (virtualContentArray.length > 0) {
            this.getCommonViewer().setExpandedElements(new Object[]{virtualContentArray});
            this.getCommonViewer().setSelection((ISelection)new StructuredSelection((Object)virtualContentArray[virtualContentArray.length - 1]));
        }
    }

    public void selectReveal(ISelection iSelection) {
        Object object;
        Object object2 = this.getCommonViewer().getStructuredSelection().getFirstElement();
        VirtualContent virtualContent = object2 instanceof IResource ? NavigatorRoot.getInstance().getManager().findWrappedInstanceOf(object2) : (VirtualContent)this.getCommonViewer().getStructuredSelection().getFirstElement();
        StructuredSelection structuredSelection = new StructuredSelection();
        if (iSelection instanceof StructuredSelection) {
            structuredSelection = (StructuredSelection)iSelection;
            object = ((StructuredSelection)iSelection).getFirstElement();
            if (object instanceof IResource && (object = NavigatorRoot.getInstance().getManager().findWrappedInstanceOf(object)) != null) {
                structuredSelection = new StructuredSelection(object);
            }
        }
        if (virtualContent instanceof WrappedSyntacticContent && (object = structuredSelection.getFirstElement()) instanceof WrappedFile) {
            if (virtualContent.isContainedIn((VirtualContent)object)) {
                this.getCommonViewer().setSelection((ISelection)new StructuredSelection((Object)virtualContent));
            }
            return;
        }
        if (!structuredSelection.isEmpty()) {
            super.selectReveal((ISelection)structuredSelection);
        }
    }

    protected CommonViewer createCommonViewerObject(Composite composite) {
        return new NavigatorCommonViewer(this.getViewSite().getId(), composite, 770);
    }

    protected Object getInitialInput() {
        return NavigatorRoot.getInstance();
    }

    protected void handleDoubleClick(DoubleClickEvent doubleClickEvent) {
        Object[] objectArray;
        CommonViewer commonViewer;
        VirtualContent virtualContent;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)doubleClickEvent.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof VirtualContent && (virtualContent = (VirtualContent)object).handleDoubleClick()) {
            if (object instanceof Tag) {
                Tag tag = (Tag)object;
                this.findControl.searchFor(tag.getName());
                return;
            }
        } else {
            super.handleDoubleClick(doubleClickEvent);
        }
        if ((object instanceof WrappedContainer || object instanceof TopLevelFolder) && (commonViewer = this.getCommonViewer()).getExpandedState(object) && (objectArray = ((VirtualContent)object).getNavigatorChildren()).length > 0) {
            commonViewer.reveal(objectArray[objectArray.length - 1]);
        }
    }

    public void createToolItems(GamaToolbar2 gamaToolbar2) {
        this.toolbar = gamaToolbar2;
        this.toolbar.button("navigator/status.info", "", "", selectionEvent -> this.properties.run(), 16384);
        this.findControl = new NavigatorSearchControl(this).fill(this.toolbar.getToolbar(16384));
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
        VirtualContent virtualContent = iStructuredSelection == null || iStructuredSelection.isEmpty() ? NavigatorRoot.getInstance() : (VirtualContent)iStructuredSelection.getFirstElement();
        virtualContent.handleSingleClick();
    }

    public void expandAll() {
        this.getCommonViewer().expandAll();
    }

    public void collapseAll() {
        this.getCommonViewer().collapseAll();
    }
}

