/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view.contents;

import gama.gaml.compilation.kernel.GamaBundleLoader;
import gama.ui.navigator.view.contents.NavigatorRoot;
import gama.ui.navigator.view.contents.VirtualContent;
import gama.ui.navigator.view.contents.WrappedProject;
import gama.ui.shared.resources.GamaColors;
import gama.ui.shared.resources.GamaIcon;
import gama.ui.shared.resources.IGamaColors;
import gama.ui.shared.resources.IGamaIcons;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import one.util.streamex.StreamEx;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;

public class TopLevelFolder
extends VirtualContent<NavigatorRoot>
implements IGamaIcons,
IGamaColors {
    WrappedProject[] children;
    final ImageDescriptor icon;
    final String statusMessage;
    final String nature;
    final GamaColors.GamaUIColor statusColor;
    final Location location;

    public TopLevelFolder(NavigatorRoot navigatorRoot, String string, String string2, String string3, GamaColors.GamaUIColor gamaUIColor, String string4, Location location) {
        super(navigatorRoot, string);
        this.statusColor = gamaUIColor;
        this.statusMessage = string3;
        this.nature = string4;
        this.location = location;
        this.icon = GamaIcon.named((String)string2).descriptor();
        this.initializeChildren();
    }

    public void initializeChildren() {
        this.children = (WrappedProject[])((StreamEx)StreamEx.of((Object[])ResourcesPlugin.getWorkspace().getRoot().getProjects()).filter(this::privateAccepts)).map(iProject -> (WrappedProject)this.getManager().wrap(this, (IResource)iProject)).toArray(WrappedProject.class);
    }

    @Override
    public boolean hasChildren() {
        return this.children.length > 0;
    }

    @Override
    public Object[] getNavigatorChildren() {
        return this.children;
    }

    @Override
    public int findMaxProblemSeverity() {
        int n = -1;
        WrappedProject[] wrappedProjectArray = this.children;
        int n2 = this.children.length;
        int n3 = 0;
        while (n3 < n2) {
            WrappedProject wrappedProject = wrappedProjectArray[n3];
            int n4 = wrappedProject.findMaxProblemSeverity();
            if (n4 > n) {
                n = n4;
            }
            if (n == 2) break;
            ++n3;
        }
        return n;
    }

    public final boolean privateAccepts(IProject iProject) {
        if (iProject == null || !iProject.exists()) {
            return false;
        }
        if (!iProject.isOpen()) {
            return this.estimateLocation(iProject.getLocation()) == this.location;
        }
        try {
            return this.accepts(iProject.getDescription());
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    protected Location estimateLocation(IPath iPath) {
        try {
            URL uRL = new URL("platform:/plugin/" + GamaBundleLoader.CORE_MODELS.getSymbolicName() + "/");
            URL uRL2 = FileLocator.toFileURL((URL)uRL);
            URI uRI = new URI(uRL2.getProtocol(), uRL2.getPath(), null).normalize();
            URL uRL3 = uRI.toURL();
            String string = iPath.toOSString();
            boolean bl = string.contains("tests");
            if (!bl && string.startsWith(uRL3.getPath())) {
                return Location.CoreModels;
            }
            if (string.startsWith(uRL3.getPath().replace(GamaBundleLoader.CORE_MODELS.getSymbolicName() + "/", ""))) {
                if (bl) {
                    return Location.Tests;
                }
                return Location.Plugins;
            }
            return Location.Other;
        }
        catch (IOException | URISyntaxException exception) {
            exception.printStackTrace();
            return Location.Unknown;
        }
    }

    public final boolean accepts(IProjectDescription iProjectDescription) {
        if (this.nature != null) {
            return iProjectDescription.hasNature(this.nature);
        }
        return iProjectDescription.getNatureIds().length < 3;
    }

    @Override
    public final ImageDescriptor getImageDescriptor() {
        return this.icon;
    }

    @Override
    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Override
    public void getSuffix(StringBuilder stringBuilder) {
        int n = this.children.length;
        stringBuilder.append(n).append(" project");
        if (n > 1) {
            stringBuilder.append("s");
        }
    }

    @Override
    public ImageDescriptor getOverlay() {
        return (ImageDescriptor)DESCRIPTORS.get(this.findMaxProblemSeverity());
    }

    @Override
    public TopLevelFolder getTopLevelFolder() {
        return this;
    }

    public String getNature() {
        return this.nature;
    }

    @Override
    public VirtualContent.VirtualContentType getType() {
        return VirtualContent.VirtualContentType.VIRTUAL_FOLDER;
    }

    public static enum Location {
        CoreModels,
        Plugins,
        Other,
        Unknown,
        Tests;

    }
}

