/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.wizards;

import com.google.common.net.UrlEscapers;
import gama.core.runtime.GAMA;
import gama.ui.navigator.view.contents.ResourceManager;
import gama.ui.navigator.wizards.AbstractNewModelWizardPage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.osgi.framework.Bundle;

public abstract class AbstractNewModelWizard
extends Wizard
implements INewWizard {
    static final String _AUTHOR = "modelAuthor";
    static final String _DESCRIPTION = "modelDescription";
    static final String _TITLE = "modelTitle";
    static final String _FILENAME = "modelFilename";
    static final String _DOC = "documentation";
    static final Map<String, String> TEMPLATES = new HashMap<String, String>(){
        {
            this.put(AbstractNewModelWizard.EXPERIMENT, "/templates/experiment.template.resource");
            this.put(AbstractNewModelWizard.TEST_EXP, "/templates/test.experiment.template.resource");
        }
    };
    public static final String GUI = "GUI";
    public static final String HEADLESS = "Headless";
    public static final String EXPERIMENT = "experiment";
    public static final String TEST_EXP = "test_experiment";
    protected AbstractNewModelWizardPage page;
    protected ISelection selection;

    static {
        Bundle bundle = Platform.getBundle((String)"gama.ui.navigator");
        Enumeration enumeration = bundle.findEntries("templates", "*.model.template.resource", false);
        while (enumeration.hasMoreElements()) {
            try {
                URI uRI = ((URL)enumeration.nextElement()).toURI();
                String string = uRI.getPath().replaceAll(".model.template.resource", "").replace("/templates/", "");
                TEMPLATES.put(string, uRI.getPath());
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        }
    }

    public AbstractNewModelWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.selection = iStructuredSelection;
    }

    public final void addPages() {
        this.page = this.createPage(this.selection);
        this.addPage((IWizardPage)this.getPage());
    }

    public abstract AbstractNewModelWizardPage createPage(ISelection var1);

    public AbstractNewModelWizardPage getPage() {
        return this.page;
    }

    public boolean performFinish() {
        IRunnableWithProgress iRunnableWithProgress = iProgressMonitor -> {
            try {
                try {
                    this.doFinish(iProgressMonitor);
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                    throw new InvocationTargetException(coreException);
                }
            }
            finally {
                iProgressMonitor.done();
            }
        };
        try {
            this.getContainer().run(false, false, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            Throwable throwable = invocationTargetException.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)throwable.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(IProgressMonitor iProgressMonitor) throws CoreException {
        IFile iFile;
        block24: {
            String string = this.getPage().getContainerName();
            String string2 = this.getPage().getFileName();
            String string3 = this.getPage().getAuthor();
            String string4 = this.getPage().getModelName();
            String string5 = this.getPage().getDescription();
            boolean bl = this.getPage().createDoc();
            iProgressMonitor.beginTask("Creating " + string2, 2);
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IContainer iContainer = this.findContainer(iProgressMonitor, string, iWorkspaceRoot);
            if (iContainer == null) {
                return;
            }
            IProject iProject = iContainer.getProject();
            IFolder iFolder = iProject.getFolder((IPath)new Path(this.getDefaultFolderForModels()));
            if (iProject == iContainer) {
                if (!iFolder.exists()) {
                    iFolder.create(true, true, iProgressMonitor);
                }
                iContainer = iFolder;
            }
            iFile = iContainer.getFile((IPath)new Path(string2));
            String string6 = this.getPage().getTemplatePath();
            try {
                Throwable throwable = null;
                Object var15_17 = null;
                try (InputStream inputStream = this.getInputStream(iContainer, string6, string4, string3, string5);){
                    ResourceManager.getInstance().reveal(iFile);
                    iFile.create(inputStream, true, iProgressMonitor);
                    if (!bl) break block24;
                    IFolder iFolder2 = iProject.getFolder((IPath)new Path(_DOC));
                    if (!iFolder2.exists()) {
                        iFolder2.create(true, true, iProgressMonitor);
                    }
                    Object object = iFolder.getFullPath().isPrefixOf(iFile.getFullPath()) ? iFile.getFullPath().removeLastSegments(1).makeRelativeTo(iFolder.getFullPath()) : new Path("");
                    String string7 = iFile.getFullPath().removeFileExtension().lastSegment();
                    Throwable throwable2 = null;
                    Object var21_25 = null;
                    try (InputStream inputStream2 = this.openContentStreamMDFile(string4, string5, string3, string7);){
                        IFolder iFolder3 = (IFolder)this.createRecursively(iWorkspaceRoot, iFolder2.getFullPath().append((IPath)object));
                        IFile iFile2 = iFolder3.getFile(string7 + ".md");
                        iFile2.create(inputStream2, true, iProgressMonitor);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        iProgressMonitor.worked(1);
        iProgressMonitor.setTaskName("Opening file for editing...");
        GAMA.getGui().editModel((Object)iFile);
        iProgressMonitor.worked(1);
    }

    private InputStream getInputStream(IContainer iContainer, String string, String string2, String string3, String string4) {
        InputStream inputStream;
        IFile iFile = iContainer.getProject().getFile((IPath)new Path(string));
        if (iFile.exists()) {
            try {
                inputStream = iFile.getContents();
            }
            catch (CoreException coreException) {
                return null;
            }
        } else {
            inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(string);
        }
        return this.replacePlaceHolders(iContainer, inputStream, string2, string3, string4);
    }

    public IContainer findContainer(IProgressMonitor iProgressMonitor, String string, IWorkspaceRoot iWorkspaceRoot) throws CoreException {
        IResource iResource = iWorkspaceRoot.findMember((IPath)new Path(string));
        if (iResource == null || !iResource.exists()) {
            boolean bl = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Folder does not exist", (String)("Folder \"" + string + "\" does not exist. Create it automatically ?"));
            if (!bl) {
                return null;
            }
            IContainer iContainer = this.createRecursively(iWorkspaceRoot, (IPath)new Path(string));
            iResource = iContainer;
        } else if (!(iResource instanceof IContainer)) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Not a folder", (String)(string + " is not a folder. Cannot proceed"));
            return null;
        }
        return (IContainer)iResource;
    }

    IContainer createRecursively(IWorkspaceRoot iWorkspaceRoot, IPath iPath) throws CoreException {
        IProject iProject = iWorkspaceRoot.getProject(iPath.segment(0));
        if (iProject == null) {
            return iWorkspaceRoot;
        }
        int n = 1;
        while (n < iPath.segmentCount()) {
            String string = iPath.segment(n);
            if (!(iProject = iProject.getFolder((IPath)new Path(string))).exists()) {
                ((IFolder)iProject).create(true, true, null);
            }
            ++n;
        }
        return iProject;
    }

    protected abstract String getDefaultFolderForModels();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected InputStream replacePlaceHolders(IContainer iContainer, InputStream inputStream, String string, String string2, String string3) {
        String string4;
        Object object;
        StringWriter stringWriter;
        block16: {
            String string5 = "";
            stringWriter = new StringWriter();
            try {
                object = null;
                string4 = null;
                try {
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                    try {
                        try (BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                            while ((string5 = bufferedReader.readLine()) != null) {
                                stringWriter.write(string5 + "\n");
                            }
                        }
                        if (inputStreamReader == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        if (inputStreamReader == null) throw object;
                        inputStreamReader.close();
                        throw object;
                    }
                    inputStreamReader.close();
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                        throw object;
                    }
                    if (object == throwable) throw object;
                    ((Throwable)object).addSuppressed(throwable);
                    throw object;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        object = stringWriter.toString();
        string4 = this.getHeader(iContainer, (String)object, string, string2, string3);
        return new ByteArrayInputStream(string4.getBytes());
    }

    protected String getHeader(IContainer iContainer, String string, String string2, String string3, String string4) {
        return string.replaceAll("\\$TITLE\\$", string2).replaceAll("\\$AUTHOR\\$", string3).replaceAll("\\$DESC\\$", string4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InputStream openContentStreamMDFile(String string, String string2, String string3, String string4) throws CoreException {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var8_9 = null;
            try {
                InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/templates/description-md-template.resource");
                try {
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
                        String string5;
                        while ((string5 = bufferedReader.readLine()) != null) {
                            string5 = string5.replaceAll(_AUTHOR, string3).replaceAll(_TITLE, "Documentation of " + string).replaceAll(_DESCRIPTION, string2).replaceAll(_FILENAME, UrlEscapers.urlFragmentEscaper().escape(string4));
                            stringBuilder.append(string5);
                            stringBuilder.append("\n");
                        }
                    }
                    if (inputStream == null) return new ByteArrayInputStream(stringBuilder.toString().getBytes());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
                return new ByteArrayInputStream(stringBuilder.toString().getBytes());
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Status status = new Status(4, "ExampleWizard", 0, iOException.getLocalizedMessage(), null);
            throw new CoreException((IStatus)status);
        }
    }
}

