/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.wizards;

import gama.ui.application.workspace.WorkspaceModelsManager;
import gama.ui.navigator.view.contents.ResourceManager;
import gama.ui.navigator.wizards.AbstractNewModelWizard;
import gama.ui.navigator.wizards.NewFileWizard;
import gama.ui.navigator.wizards.NewProjectWizardPage;
import gama.ui.navigator.wizards.NewTestExperimentWizard;
import gama.ui.shared.utils.WorkbenchHelper;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class NewProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private NewProjectWizardPage wizardPage;
    private IProject project;

    public void addPages() {
        this.wizardPage = new NewProjectWizardPage("NewGAMAProject");
        this.wizardPage.setDescription("Create a new GAMA Project.");
        this.wizardPage.setTitle("New GAMA Project");
        this.addPage((IWizardPage)this.wizardPage);
    }

    public boolean performFinish() {
        if (this.project != null) {
            return true;
        }
        final boolean bl = this.wizardPage.isTest();
        boolean bl2 = this.wizardPage.createNewModel();
        final IProject iProject = this.wizardPage.getProjectHandle();
        URI uRI = this.wizardPage.getLocationURI();
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription iProjectDescription = iWorkspace.newProjectDescription(iProject.getName());
        iProjectDescription.setLocationURI(uRI);
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                NewProjectWizard.this.createProject(iProjectDescription, iProject, bl, iProgressMonitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)workspaceModifyOperation);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)throwable.getMessage());
            return false;
        }
        this.project = iProject;
        if (bl2) {
            WorkbenchHelper.runInUI((String)"Opening model creation wizard", (int)100, iProgressMonitor -> {
                AbstractNewModelWizard abstractNewModelWizard = bl ? new NewTestExperimentWizard() : new NewFileWizard();
                abstractNewModelWizard.init(WorkbenchHelper.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)this.project));
                WizardDialog wizardDialog = new WizardDialog(this.getShell(), (IWizard)abstractNewModelWizard);
                wizardDialog.open();
            });
        }
        return true;
    }

    void createProject(IProjectDescription iProjectDescription, IProject iProject, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        try {
            try {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)"", (int)2000);
                iProject.create(iProjectDescription, (IProgressMonitor)subMonitor.split(1000));
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                iProject.open((IProgressMonitor)subMonitor.split(1000));
                WorkspaceModelsManager.instance.setValuesProjectDescription(iProject, false, false, bl, null);
                IProject iProject2 = iProject;
                IFolder iFolder = iProject2.getFolder((IPath)new Path("models"));
                iFolder.create(true, true, iProgressMonitor);
                IFolder iFolder2 = iProject2.getFolder((IPath)new Path("includes"));
                iFolder2.create(true, true, iProgressMonitor);
                if (bl) {
                    IFolder iFolder3 = iProject2.getFolder((IPath)new Path("tests"));
                    iFolder3.create(true, true, iProgressMonitor);
                }
            }
            catch (CoreException coreException) {
                Status status = new Status(4, "ProjectWizard", 0, coreException.getLocalizedMessage(), null);
                throw new CoreException((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            iProgressMonitor.done();
            ResourceManager.getInstance().reveal(iProject.getFolder(bl ? "tests" : "models"));
            throw throwable;
        }
        iProgressMonitor.done();
        ResourceManager.getInstance().reveal(iProject.getFolder(bl ? "tests" : "models"));
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) throws CoreException {
    }
}

