/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view.contents;

import gama.core.runtime.GAMA;
import gama.core.util.file.IGamaFileMetaData;
import gama.gaml.statements.test.CompoundSummary;
import gama.ui.navigator.view.contents.TestModelsFolder;
import gama.ui.navigator.view.contents.TopLevelFolder;
import gama.ui.navigator.view.contents.VirtualContent;
import gama.ui.navigator.view.contents.WrappedContainer;
import gama.ui.shared.resources.GamaIcon;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xml.type.internal.DataValue;
import org.eclipse.jface.resource.ImageDescriptor;

public class WrappedProject
extends WrappedContainer<IProject> {
    private String plugin;
    final boolean isTest;

    public WrappedProject(TopLevelFolder topLevelFolder, IProject iProject) {
        super(topLevelFolder, iProject);
        this.isTest = topLevelFolder instanceof TestModelsFolder;
    }

    @Override
    public boolean canBeDecorated() {
        return true;
    }

    @Override
    public boolean isOpen() {
        return super.isOpen() && ((IProject)this.getResource()).isOpen();
    }

    @Override
    public boolean handleDoubleClick() {
        if (!this.isOpen()) {
            try {
                ((IProject)this.getResource()).open(null);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            return true;
        }
        return false;
    }

    @Override
    public Object[] getNavigatorChildren() {
        return this.isOpen() ? super.getNavigatorChildren() : EMPTY;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return GamaIcon.named((String)"navigator/files/folder.project").descriptor();
    }

    @Override
    public void getSuffix(StringBuilder stringBuilder) {
        if (!this.isOpen()) {
            stringBuilder.append("closed");
            return;
        }
        if (this.getPlugin() != null && !this.getPlugin().isEmpty()) {
            stringBuilder.append(this.getPlugin()).append(", ");
        }
        if (this.isTestProject()) {
            this.getTestSuffix(stringBuilder);
        } else {
            super.getSuffix(stringBuilder);
        }
    }

    private void getTestSuffix(StringBuilder stringBuilder) {
        URI uRI = URI.createPlatformResourceURI((String)DataValue.URI.encode((String)this.getName()), (boolean)false);
        String string = this.getSuffixOfTestSummary(uRI);
        if (string.isEmpty()) {
            super.getSuffix(stringBuilder);
        } else {
            stringBuilder.append(string);
        }
    }

    public String getSuffixOfTestSummary(URI uRI) {
        CompoundSummary<?, ?> compoundSummary = this.getManager().getTestsSummary();
        if (compoundSummary == null) {
            return "";
        }
        ArrayList arrayList = new ArrayList();
        compoundSummary.getSubSummariesBelongingTo(uRI, arrayList);
        CompoundSummary compoundSummary2 = new CompoundSummary(arrayList);
        return compoundSummary2.getStringSummary();
    }

    private boolean isTestProject() {
        return this.isTest;
    }

    @Override
    public VirtualContent.VirtualContentType getType() {
        return VirtualContent.VirtualContentType.PROJECT;
    }

    String getPlugin() {
        if (this.plugin == null) {
            IGamaFileMetaData iGamaFileMetaData = GAMA.getGui().getMetaDataProvider().getMetaData(this.getResource(), false, false);
            if (iGamaFileMetaData != null) {
                this.setPlugin(iGamaFileMetaData.getSuffix());
            } else {
                this.setPlugin("");
            }
        }
        return this.plugin;
    }

    void setPlugin(String string) {
        this.plugin = string;
    }

    @Override
    public WrappedProject getProject() {
        return this;
    }

    @Override
    public int findMaxProblemSeverity() {
        int n = super.findMaxProblemSeverity();
        if (n == 1) {
            try {
                if (((IProject)this.getResource()).getDefaultCharset(false) == null) {
                    ((IProject)this.getResource()).setDefaultCharset(((IProject)this.getResource()).getWorkspace().getRoot().getDefaultCharset(), null);
                }
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
        return n;
    }
}

