/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view.contents;

import gama.ui.navigator.view.contents.WrappedContainer;
import gama.ui.navigator.view.contents.WrappedFile;
import gama.ui.shared.dialogs.Messages;
import org.eclipse.core.resources.IFile;

public class WrappedLink
extends WrappedFile {
    final boolean isWeb = ((IFile)this.getResource()).getLocation().toString().contains("+_+");

    public WrappedLink(WrappedContainer<?> wrappedContainer, IFile iFile) {
        super(wrappedContainer, iFile);
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public boolean handleDoubleClick() {
        if (!this.getManager().validateLocation((IFile)this.getResource())) {
            Messages.error((String)("The file at location '" + String.valueOf(((IFile)this.getResource()).getLocation()) + " does not exist"));
            return true;
        }
        return false;
    }

    @Override
    public int findMaxProblemSeverity() {
        if (!this.getManager().validateLocation((IFile)this.getResource())) {
            return -4;
        }
        return -3;
    }

    @Override
    public boolean canBeDecorated() {
        return true;
    }

    @Override
    public void getSuffix(StringBuilder stringBuilder) {
        super.getSuffix(stringBuilder);
        if (stringBuilder.length() > 0) {
            stringBuilder.append(" - ");
        }
        stringBuilder.append(this.reconstructTargetName());
    }

    String reconstructTargetName() {
        String string = ((IFile)this.getResource()).getLocation().toString();
        if (this.isWeb) {
            string = string.substring(string.lastIndexOf("/") + 1).replace("+_+", "/");
        }
        return string;
    }
}

