/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view;

import gama.dev.DEBUG;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;

public class ResourceChangeReporter
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        if (!DEBUG.IS_ON()) {
            return;
        }
        IResource iResource = iResourceChangeEvent.getResource();
        switch (iResourceChangeEvent.getType()) {
            case 2: {
                DEBUG.OUT((Object)("Project " + String.valueOf(iResource.getFullPath()) + " is about to close."));
                break;
            }
            case 4: {
                DEBUG.OUT((Object)("Project " + String.valueOf(iResource.getFullPath()) + " is about to be deleted."));
                break;
            }
            case 1: {
                DEBUG.OUT((Object)"Resources have changed.");
                try {
                    iResourceChangeEvent.getDelta().accept((IResourceDeltaVisitor)new DeltaPrinter());
                }
                catch (CoreException coreException) {}
                break;
            }
            case 8: {
                try {
                    DEBUG.OUT((Object)"Build about to run.");
                    iResourceChangeEvent.getDelta().accept((IResourceDeltaVisitor)new DeltaPrinter());
                }
                catch (CoreException coreException) {}
                break;
            }
            case 16: {
                try {
                    DEBUG.OUT((Object)"Build complete.");
                    iResourceChangeEvent.getDelta().accept((IResourceDeltaVisitor)new DeltaPrinter());
                    break;
                }
                catch (CoreException coreException) {}
            }
        }
    }

    class DeltaPrinter
    implements IResourceDeltaVisitor {
        DeltaPrinter() {
        }

        public boolean visit(IResourceDelta iResourceDelta) {
            if (!DEBUG.IS_ON()) {
                return false;
            }
            IResource iResource = iResourceDelta.getResource();
            switch (iResourceDelta.getKind()) {
                case 1: {
                    DEBUG.OUT((Object)("Resource " + String.valueOf(iResource.getFullPath()) + " was added."));
                    break;
                }
                case 2: {
                    DEBUG.OUT((Object)("Resource " + String.valueOf(iResource.getFullPath()) + " was removed."));
                    break;
                }
                case 4: {
                    DEBUG.OUT((Object)("Resource " + String.valueOf(iResourceDelta.getFullPath()) + " has changed."));
                    int n = iResourceDelta.getFlags();
                    if ((n & 0x100) != 0) {
                        DEBUG.OUT((Object)"--> Content Change");
                    }
                    if ((n & 0x40000) != 0) {
                        DEBUG.OUT((Object)"--> Content Replaced");
                    }
                    if ((n & 0x20000) == 0) break;
                    DEBUG.OUT((Object)"--> Marker Change");
                }
            }
            return true;
        }
    }
}

