/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view.contents;

import gama.ui.navigator.view.contents.Category;
import gama.ui.navigator.view.contents.NavigatorRoot;
import gama.ui.navigator.view.contents.VirtualContent;
import gama.ui.navigator.view.contents.WrappedFile;
import gama.ui.shared.utils.WorkbenchHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class LinkedFile
extends VirtualContent<Category>
implements IAdaptable {
    final WrappedFile file;
    final String suffix;

    public LinkedFile(Category category, IFile iFile, String string) {
        super(category, NavigatorRoot.getInstance().getManager().findWrappedInstanceOf(iFile).getName());
        this.suffix = string;
        this.file = (WrappedFile)this.getManager().findWrappedInstanceOf(iFile);
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public Object[] getNavigatorChildren() {
        return EMPTY;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.createFromImage((Image)DEFAULT_LABEL_PROVIDER.getImage(this.file.getResource()));
    }

    @Override
    public boolean handleDoubleClick() {
        try {
            IDE.openEditor((IWorkbenchPage)WorkbenchHelper.getPage(), (IFile)((IFile)this.file.getResource()));
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
            return false;
        }
        return true;
    }

    public Object getAdapter(Class clazz) {
        return clazz == IResource.class || clazz == IFile.class ? this.file.getResource() : null;
    }

    @Override
    public int findMaxProblemSeverity() {
        return this.file.findMaxProblemSeverity();
    }

    @Override
    public void getSuffix(StringBuilder stringBuilder) {
        stringBuilder.append(this.suffix);
    }

    @Override
    public ImageDescriptor getOverlay() {
        return null;
    }

    @Override
    public VirtualContent.VirtualContentType getType() {
        return VirtualContent.VirtualContentType.FILE_REFERENCE;
    }

    public WrappedFile getTarget() {
        return this.file;
    }
}

