/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view.contents;

import gama.core.common.GamlFileExtension;
import gama.ui.navigator.view.contents.ModelsLibraryFolder;
import gama.ui.navigator.view.contents.PluginsModelsFolder;
import gama.ui.navigator.view.contents.ResourceManager;
import gama.ui.navigator.view.contents.TestModelsFolder;
import gama.ui.navigator.view.contents.TopLevelFolder;
import gama.ui.navigator.view.contents.UserProjectsFolder;
import gama.ui.navigator.view.contents.VirtualContent;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;

public class NavigatorRoot
extends VirtualContent
implements IAdaptable {
    private TopLevelFolder userFolder;
    private TopLevelFolder testFolder;
    private TopLevelFolder pluginFolder;
    private TopLevelFolder libraryFolder;
    private static final NavigatorRoot instance = new NavigatorRoot();
    private ResourceManager mapper;

    public NavigatorRoot() {
        super(null, "Workspace");
    }

    public TopLevelFolder getUserFolder() {
        if (this.userFolder == null) {
            this.userFolder = new UserProjectsFolder(this, "User models");
        }
        return this.userFolder;
    }

    public TopLevelFolder getTestFolder() {
        if (this.testFolder == null) {
            this.testFolder = new TestModelsFolder(this, "Test models");
        }
        return this.testFolder;
    }

    public TopLevelFolder getPluginFolder() {
        if (this.pluginFolder == null) {
            this.pluginFolder = new PluginsModelsFolder(this, "Plugin models");
        }
        return this.pluginFolder;
    }

    public TopLevelFolder getLibraryFolder() {
        if (this.libraryFolder == null) {
            this.libraryFolder = new ModelsLibraryFolder(this, "Library models");
        }
        return this.libraryFolder;
    }

    public void resetVirtualFolders(ResourceManager resourceManager) {
        if (resourceManager != null) {
            this.setManager(resourceManager);
        }
        this.setUserFolder(null);
        this.setPluginFolder(null);
        this.setTestFolder(null);
        this.setLibraryFolder(null);
    }

    public void recreateVirtualFolders() {
        this.getFolders();
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IResource.class || clazz == IContainer.class) {
            return ResourcesPlugin.getWorkspace().getRoot();
        }
        return AdapterManager.getDefault().getAdapter((Object)this, clazz);
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public Object[] getNavigatorChildren() {
        return this.getFolders();
    }

    public TopLevelFolder[] getFolders() {
        return new TopLevelFolder[]{this.getLibraryFolder(), this.getPluginFolder(), this.getTestFolder(), this.getUserFolder()};
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    @Override
    public void getSuffix(StringBuilder stringBuilder) {
    }

    @Override
    public int findMaxProblemSeverity() {
        return 0;
    }

    @Override
    public ImageDescriptor getOverlay() {
        return null;
    }

    @Override
    public TopLevelFolder getTopLevelFolder() {
        return this.getUserFolder();
    }

    @Override
    public VirtualContent.VirtualContentType getType() {
        return VirtualContent.VirtualContentType.ROOT;
    }

    @Override
    public String getStatusMessage() {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        try {
            String string;
            int n = iWorkspaceRoot.members().length;
            int n2 = 0;
            IResource[] iResourceArray = iWorkspaceRoot.members();
            int n3 = iResourceArray.length;
            int n4 = 0;
            while (n4 < n3) {
                string = iResourceArray[n4];
                int[] nArray = new int[1];
                try {
                    if (string.isAccessible()) {
                        string.accept(iResourceProxy -> {
                            if (iResourceProxy.getType() == 1 && GamlFileExtension.isAny((String)iResourceProxy.getName())) {
                                nArray[0] = nArray[0] + 1;
                            }
                            return true;
                        }, 0);
                    }
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
                n2 += nArray[0];
                ++n4;
            }
            string = iWorkspaceRoot.getLocation().lastSegment();
            return this.getName() + " " + string + " (" + n + " projects, " + n2 + " models)";
        }
        catch (CoreException coreException) {
            return this.getName();
        }
    }

    public void setLibraryFolder(TopLevelFolder topLevelFolder) {
        this.libraryFolder = topLevelFolder;
    }

    public void setPluginFolder(TopLevelFolder topLevelFolder) {
        this.pluginFolder = topLevelFolder;
    }

    public void setUserFolder(TopLevelFolder topLevelFolder) {
        this.userFolder = topLevelFolder;
    }

    public void setTestFolder(TopLevelFolder topLevelFolder) {
        this.testFolder = topLevelFolder;
    }

    @Override
    public ResourceManager getManager() {
        return this.mapper;
    }

    public void setManager(ResourceManager resourceManager) {
        this.mapper = resourceManager;
    }

    public TopLevelFolder getFolder(String string) {
        TopLevelFolder[] topLevelFolderArray = this.getFolders();
        int n = topLevelFolderArray.length;
        int n2 = 0;
        while (n2 < n) {
            TopLevelFolder topLevelFolder = topLevelFolderArray[n2];
            if (topLevelFolder.getName().equals(string)) {
                return topLevelFolder;
            }
            ++n2;
        }
        return null;
    }

    public static NavigatorRoot getInstance() {
        return instance;
    }
}

