/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view.actions;

import gama.ui.navigator.metadata.FileMetaDataProvider;
import gama.ui.navigator.view.actions.PasteAction;
import gama.ui.navigator.view.contents.ResourceManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.part.ResourceTransfer;

class CopyAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.CopyAction";
    private final Shell shell;
    private final Clipboard clipboard;
    private PasteAction pasteAction;

    public CopyAction(Shell shell, Clipboard clipboard) {
        super("Copy");
        Assert.isNotNull((Object)shell);
        Assert.isNotNull((Object)clipboard);
        this.shell = shell;
        this.clipboard = clipboard;
        this.setToolTipText("Copy selected resource(s)");
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "CopyHelpId");
    }

    public CopyAction(Shell shell, Clipboard clipboard, PasteAction pasteAction) {
        this(shell, clipboard);
        this.pasteAction = pasteAction;
    }

    public void run() {
        List<? extends IResource> list = this.getSelectedResources();
        IResource[] iResourceArray = list.toArray(new IResource[list.size()]);
        int n = iResourceArray.length;
        int n2 = 0;
        String[] stringArray = new String[n];
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        while (n3 < n) {
            IPath iPath = iResourceArray[n3].getLocation();
            if (iPath != null) {
                stringArray[n2++] = iPath.toOSString();
            }
            if (n3 > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(iResourceArray[n3].getName());
            ++n3;
        }
        if (n2 < n) {
            String[] stringArray2 = stringArray;
            stringArray = new String[n2];
            int n4 = 0;
            while (n4 < n2) {
                stringArray[n4] = stringArray2[n4];
                ++n4;
            }
        }
        this.setClipboard(iResourceArray, stringArray, stringBuilder.toString());
        if (this.pasteAction != null && this.pasteAction.getStructuredSelection() != null) {
            this.pasteAction.selectionChanged(this.pasteAction.getStructuredSelection());
        }
    }

    protected List<? extends IResource> getSelectedResources() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (IResource iResource : super.getSelectedResources()) {
            arrayList.add(iResource);
            if (!ResourceManager.isFile(iResource)) continue;
            arrayList.addAll(FileMetaDataProvider.getInstance().getSupportFilesOf((IFile)iResource));
        }
        return arrayList;
    }

    private void setClipboard(IResource[] iResourceArray, String[] stringArray, String string) {
        block5: {
            try {
                if (stringArray.length > 0) {
                    this.clipboard.setContents(new Object[]{iResourceArray, stringArray, string}, new Transfer[]{ResourceTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()});
                } else {
                    this.clipboard.setContents(new Object[]{iResourceArray, string}, new Transfer[]{ResourceTransfer.getInstance(), TextTransfer.getInstance()});
                }
            }
            catch (SWTError sWTError) {
                if (sWTError.code != 2002) {
                    throw sWTError;
                }
                if (!MessageDialog.openQuestion((Shell)this.shell, (String)"Problem with copy title", (String)"Problem with copy.")) break block5;
                this.setClipboard(iResourceArray, stringArray, string);
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        if (!super.updateSelection(iStructuredSelection)) {
            return false;
        }
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        List<? extends IResource> list = this.getSelectedResources();
        if (list.size() == 0) {
            return false;
        }
        boolean bl = this.selectionIsOfType(4);
        boolean bl2 = this.selectionIsOfType(3);
        if (!bl && !bl2) {
            return false;
        }
        if (bl && bl2) {
            return false;
        }
        IContainer iContainer = list.get(0).getParent();
        if (iContainer == null) {
            return false;
        }
        for (IResource iResource : list) {
            if (!iResource.getParent().equals((Object)iContainer)) {
                return false;
            }
            if (iResource.getLocationURI() != null) continue;
            return false;
        }
        return true;
    }
}

