/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view.actions;

import gama.ui.navigator.view.actions.OpenFileAction;
import gama.ui.navigator.view.contents.WrappedFile;
import gama.ui.shared.resources.GamaIcon;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class OpenActionProvider
extends CommonActionProvider {
    private OpenFileAction openFileAction;
    private ICommonViewerWorkbenchSite viewSite = null;
    private boolean contribute = false;

    public void init(ICommonActionExtensionSite iCommonActionExtensionSite) {
        if (iCommonActionExtensionSite.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            this.viewSite = (ICommonViewerWorkbenchSite)iCommonActionExtensionSite.getViewSite();
            this.openFileAction = new OpenFileAction(this.viewSite.getPage());
            this.openFileAction.setImageDescriptor(GamaIcon.named((String)"navigator/navigator.open2").descriptor());
            this.contribute = true;
        }
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        if (!this.contribute || this.getContext().getSelection().isEmpty()) {
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        this.openFileAction.selectionChanged(iStructuredSelection);
        if (this.openFileAction.isEnabled()) {
            iMenuManager.insertAfter("group.open", (IAction)this.openFileAction);
        }
    }

    public void fillActionBars(IActionBars iActionBars) {
        if (!this.contribute) {
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        if (iStructuredSelection.size() == 1 && iStructuredSelection.getFirstElement() instanceof WrappedFile) {
            this.openFileAction.selectionChanged(iStructuredSelection);
            iActionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openFileAction);
        }
    }
}

