/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view.actions;

import gama.ui.shared.utils.WorkbenchHelper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.mapping.ResourceChangeValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.part.FileEditorInput;

public class CloseResourceAction
extends WorkspaceAction
implements IResourceChangeListener {
    public static final String ID = "org.eclipse.ui.CloseResourceAction";
    private String[] modelProviderIds;

    public CloseResourceAction(IShellProvider iShellProvider) {
        super(iShellProvider, IDEWorkbenchMessages.CloseResourceAction_text);
        this.initAction();
    }

    private void initAction() {
        this.setId(ID);
        this.setToolTipText(IDEWorkbenchMessages.CloseResourceAction_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.close_resource_action_context");
    }

    protected String getOperationMessage() {
        return IDEWorkbenchMessages.CloseResourceAction_operationMessage;
    }

    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.CloseResourceAction_problemMessage;
    }

    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.CloseResourceAction_title;
    }

    protected void invokeOperation(IResource iResource, IProgressMonitor iProgressMonitor) throws CoreException {
        ((IProject)iResource).close(iProgressMonitor);
    }

    public void run() {
        List<? extends IResource> list = this.getSelectedResources();
        if (list == null || list.isEmpty()) {
            return;
        }
        IResource[] iResourceArray = list.toArray(new IResource[list.size()]);
        if (!IDE.saveAllEditors((IResource[])iResourceArray, (boolean)true)) {
            return;
        }
        if (!this.validateClose()) {
            return;
        }
        CloseResourceAction.closeMatchingEditors(list, false);
        ISchedulingRule iSchedulingRule = null;
        IResourceRuleFactory iResourceRuleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        IResource[] iResourceArray2 = iResourceArray;
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource iResource = iResourceArray2[n2];
            IProject iProject = (IProject)iResource;
            iSchedulingRule = MultiRule.combine(iSchedulingRule, (ISchedulingRule)iResourceRuleFactory.modifyRule((IResource)iProject));
            ++n2;
        }
        this.runInBackground(iSchedulingRule);
    }

    protected boolean shouldPerformResourcePruning() {
        return false;
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        if (!this.selectionIsOfType(4)) {
            return false;
        }
        for (IProject iProject : this.getSelectedResources()) {
            if (!iProject.isOpen()) continue;
            return true;
        }
        return false;
    }

    public synchronized void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IResourceDelta iResourceDelta;
        List<? extends IResource> list = this.getSelectedResources();
        if (this.selectionIsOfType(4) && (iResourceDelta = iResourceChangeEvent.getDelta()) != null) {
            IResourceDelta[] iResourceDeltaArray;
            IResourceDelta[] iResourceDeltaArray2 = iResourceDeltaArray = iResourceDelta.getAffectedChildren(4);
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta iResourceDelta2 = iResourceDeltaArray2[n2];
                if ((iResourceDelta2.getFlags() & 0x4000) != 0 && list.contains(iResourceDelta2.getResource())) {
                    this.selectionChanged(this.getStructuredSelection());
                    return;
                }
                ++n2;
            }
        }
    }

    protected synchronized List<? extends IResource> getSelectedResources() {
        return super.getSelectedResources();
    }

    protected synchronized List<?> getSelectedNonResources() {
        return super.getSelectedNonResources();
    }

    public String[] getModelProviderIds() {
        return this.modelProviderIds;
    }

    public void setModelProviderIds(String[] stringArray) {
        this.modelProviderIds = stringArray;
    }

    private boolean validateClose() {
        Object object2;
        IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory = ResourceChangeValidator.getValidator().createDeltaFactory();
        List list = this.getActionResources();
        for (Object object2 : list) {
            if (!(object2 instanceof IProject)) continue;
            IProject iProject = (IProject)object2;
            iResourceChangeDescriptionFactory.close(iProject);
        }
        object2 = list.size() == 1 ? NLS.bind((String)IDEWorkbenchMessages.CloseResourceAction_warningForOne, (Object)((IResource)list.get(0)).getName()) : IDEWorkbenchMessages.CloseResourceAction_warningForMultiple;
        return IDE.promptToConfirm((Shell)WorkbenchHelper.getShell(), (String)IDEWorkbenchMessages.CloseResourceAction_confirm, (String)object2, (IResourceDelta)iResourceChangeDescriptionFactory.getDelta(), (String[])this.getModelProviderIds(), (boolean)false);
    }

    static void closeMatchingEditors(final List<? extends IResource> list, final boolean bl) {
        if (list.isEmpty()) {
            return;
        }
        Runnable runnable = () -> SafeRunner.run((ISafeRunnable)new SafeRunnable(IDEWorkbenchMessages.ErrorOnCloseEditors){

            public void run() {
                IWorkbenchWindow iWorkbenchWindow = CloseResourceAction.getActiveWindow();
                if (iWorkbenchWindow != null) {
                    List<IEditorReference> list2 = CloseResourceAction.getMatchingEditors(list, iWorkbenchWindow, bl);
                    if (list2.isEmpty()) {
                        return;
                    }
                    CloseResourceAction.closeEditors(list2, iWorkbenchWindow);
                }
            }
        });
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)runnable);
    }

    static IWorkbenchWindow getActiveWindow() {
        IWorkbenchWindow[] iWorkbenchWindowArray;
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null && (iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows()).length > 0) {
            iWorkbenchWindow = iWorkbenchWindowArray[0];
        }
        return iWorkbenchWindow;
    }

    static List<IEditorReference> getMatchingEditors(List<? extends IResource> list, IWorkbenchWindow iWorkbenchWindow, boolean bl) {
        IEditorReference[] iEditorReferenceArray;
        ArrayList<IEditorReference> arrayList = new ArrayList<IEditorReference>();
        IEditorReference[] iEditorReferenceArray2 = iEditorReferenceArray = CloseResourceAction.getEditors(iWorkbenchWindow);
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference iEditorReference = iEditorReferenceArray2[n2];
            IResource iResource = CloseResourceAction.getAdapter(iEditorReference);
            if (!(iResource == null || !CloseResourceAction.belongsTo(list, iResource) || bl && iResource.exists())) {
                arrayList.add(iEditorReference);
            }
            ++n2;
        }
        return arrayList;
    }

    static IEditorReference[] getEditors(IWorkbenchWindow iWorkbenchWindow) {
        IWorkbenchPage iWorkbenchPage;
        if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
            return iWorkbenchPage.getEditorReferences();
        }
        return new IEditorReference[0];
    }

    static IResource getAdapter(IEditorReference iEditorReference) {
        FileEditorInput fileEditorInput;
        IFile iFile;
        IEditorInput iEditorInput;
        try {
            iEditorInput = iEditorReference.getEditorInput();
        }
        catch (PartInitException partInitException) {
            return null;
        }
        if (iEditorInput instanceof FileEditorInput && (iFile = (fileEditorInput = (FileEditorInput)iEditorInput).getFile()) != null) {
            return iFile;
        }
        fileEditorInput = CloseResourceAction.getAdapter(iEditorInput, IFile.class);
        if (fileEditorInput != null) {
            return fileEditorInput;
        }
        return CloseResourceAction.getAdapter(iEditorInput, IResource.class);
    }

    public static final <T> T getAdapter(Object object, Class<T> clazz) {
        Object object2;
        Object object3;
        Assert.isNotNull(clazz);
        if (object == null) {
            return null;
        }
        if (clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        if (object instanceof IAdaptable && (object3 = (object2 = (IAdaptable)object).getAdapter(clazz)) != null) {
            Assert.isTrue((boolean)clazz.isInstance(object3));
            return (T)object3;
        }
        if (!(object instanceof PlatformObject) && (object2 = Platform.getAdapterManager().getAdapter(object, clazz)) != null) {
            return (T)object2;
        }
        return null;
    }

    static boolean belongsTo(List<? extends IResource> list, IResource iResource) {
        for (IResource iResource2 : list) {
            if (!iResource2.contains((ISchedulingRule)iResource)) continue;
            return true;
        }
        return false;
    }

    static void closeEditors(List<IEditorReference> list, IWorkbenchWindow iWorkbenchWindow) {
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage == null) {
            return;
        }
        iWorkbenchPage.closeEditors(list.toArray(new IEditorReference[list.size()]), false);
    }
}

