/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.wizards;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.wizards.datatransfer.ArchiveFileManipulations;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.TarEntry;
import org.eclipse.ui.internal.wizards.datatransfer.TarException;
import org.eclipse.ui.internal.wizards.datatransfer.TarFile;
import org.eclipse.ui.internal.wizards.datatransfer.TarLeveledStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.ZipLeveledStructureProvider;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class ImportProjectWizardPage
extends WizardDataTransferPage {
    public static final String METADATA_FOLDER = ".metadata";
    ILeveledImportStructureProvider structureProvider;
    private static final String STORE_DIRECTORIES = "WizardProjectsImportPage.STORE_DIRECTORIES";
    private static final String STORE_ARCHIVES = "WizardProjectsImportPage.STORE_ARCHIVES";
    private static final String STORE_NESTED_PROJECTS = "WizardProjectsImportPage.STORE_NESTED_PROJECTS";
    private static final String STORE_COPY_PROJECT_ID = "WizardProjectsImportPage.STORE_COPY_PROJECT_ID";
    private static final String STORE_ARCHIVE_SELECTED = "WizardProjectsImportPage.STORE_ARCHIVE_SELECTED";
    Combo directoryPathField;
    CheckboxTreeViewer projectsList;
    Button nestedProjectsCheckbox;
    boolean nestedProjects = false;
    Button copyCheckbox;
    boolean copyFiles = false;
    ProjectRecord[] selectedProjects = new ProjectRecord[0];
    static String previouslyBrowsedDirectory = "";
    static String previouslyBrowsedArchive = "";
    Button projectFromDirectoryRadio;
    Button projectFromArchiveRadio;
    Combo archivePathField;
    Button browseDirectoriesButton;
    Button browseArchivesButton;
    String lastPath;
    static final String[] FILE_IMPORT_MASK = new String[]{"*.jar;*.zip;*.tar;*.tar.gz;*.tgz", "*.*"};
    final String initialPath;
    Button hideConflictingProjects;
    final ConflictingProjectFilter conflictingProjectsFilter = new ConflictingProjectFilter();
    List<IProject> createdProjects;

    public ImportProjectWizardPage() {
        this("wizardExternalProjectsPage", null);
    }

    public ImportProjectWizardPage(String string) {
        this(string, null);
    }

    public ImportProjectWizardPage(String string, String string2) {
        super(string);
        this.initialPath = string2;
        this.setPageComplete(false);
        this.setTitle("Import GAMA projects");
        this.setMessage("Select a directory or an archive to search for existing GAMA projects.");
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        this.createProjectsRoot(composite2);
        this.createProjectsList(composite2);
        this.createOptionsGroup(composite2);
        this.restoreWidgetValues();
        Dialog.applyDialogFont((Control)composite2);
    }

    protected void createOptionsGroupButtons(Group group) {
        this.nestedProjectsCheckbox = new Button((Composite)group, 32);
        this.nestedProjectsCheckbox.setText(DataTransferMessages.WizardProjectsImportPage_SearchForNestedProjects);
        this.nestedProjectsCheckbox.setLayoutData((Object)new GridData(768));
        this.nestedProjectsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImportProjectWizardPage.this.nestedProjects = ImportProjectWizardPage.this.nestedProjectsCheckbox.getSelection();
                if (ImportProjectWizardPage.this.projectFromDirectoryRadio.getSelection()) {
                    ImportProjectWizardPage.this.updateProjectsList(ImportProjectWizardPage.this.directoryPathField.getText().trim(), true);
                } else {
                    ImportProjectWizardPage.this.updateProjectsList(ImportProjectWizardPage.this.archivePathField.getText().trim(), true);
                }
            }
        });
        this.copyCheckbox = new Button((Composite)group, 32);
        this.copyCheckbox.setText(DataTransferMessages.WizardProjectsImportPage_CopyProjectsIntoWorkspace);
        this.copyCheckbox.setLayoutData((Object)new GridData(768));
        this.copyCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImportProjectWizardPage.this.copyFiles = ImportProjectWizardPage.this.copyCheckbox.getSelection();
                ImportProjectWizardPage.this.projectsList.refresh(true);
            }
        });
        this.hideConflictingProjects = new Button((Composite)group, 32);
        this.hideConflictingProjects.setText(DataTransferMessages.WizardProjectsImportPage_hideExistingProjects);
        this.hideConflictingProjects.setLayoutData((Object)new GridData(768));
        this.hideConflictingProjects.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImportProjectWizardPage.this.projectsList.removeFilter((ViewerFilter)ImportProjectWizardPage.this.conflictingProjectsFilter);
                if (ImportProjectWizardPage.this.hideConflictingProjects.getSelection()) {
                    ImportProjectWizardPage.this.projectsList.addFilter((ViewerFilter)ImportProjectWizardPage.this.conflictingProjectsFilter);
                }
            }
        });
        Dialog.applyDialogFont((Control)this.hideConflictingProjects);
    }

    private void createProjectsList(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(DataTransferMessages.WizardProjectsImportPage_ProjectsListTitle);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.makeColumnsEqualWidth = false;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        this.projectsList = new CheckboxTreeViewer(composite2, 2048);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = new PixelConverter(this.projectsList.getControl()).convertWidthInCharsToPixels(25);
        gridData.heightHint = new PixelConverter(this.projectsList.getControl()).convertHeightInCharsToPixels(10);
        this.projectsList.getControl().setLayoutData((Object)gridData);
        this.projectsList.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object object) {
                return null;
            }

            public Object[] getElements(Object object) {
                return ImportProjectWizardPage.this.getProjectRecords();
            }

            public boolean hasChildren(Object object) {
                return false;
            }

            public Object getParent(Object object) {
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        this.projectsList.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.projectsList.addCheckStateListener(checkStateChangedEvent -> {
            ProjectRecord projectRecord = (ProjectRecord)checkStateChangedEvent.getElement();
            if (projectRecord.hasConflicts || projectRecord.isInvalid) {
                this.projectsList.setChecked((Object)projectRecord, false);
            }
            this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
        });
        this.projectsList.setInput((Object)this);
        this.projectsList.setComparator(new ViewerComparator());
        this.createSelectionButtons(composite2);
    }

    private void createSelectionButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(2));
        Button button = new Button(composite2, 8);
        button.setText(DataTransferMessages.DataTransfer_selectAll);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProjectRecord[] projectRecordArray = ImportProjectWizardPage.this.selectedProjects;
                int n = ImportProjectWizardPage.this.selectedProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    ProjectRecord projectRecord = projectRecordArray[n2];
                    if (projectRecord.hasConflicts || projectRecord.isInvalid) {
                        ImportProjectWizardPage.this.projectsList.setChecked((Object)projectRecord, false);
                    } else {
                        ImportProjectWizardPage.this.projectsList.setChecked((Object)projectRecord, true);
                    }
                    ++n2;
                }
                ImportProjectWizardPage.this.setPageComplete(ImportProjectWizardPage.this.projectsList.getCheckedElements().length > 0);
            }
        });
        Dialog.applyDialogFont((Control)button);
        this.setButtonLayoutData(button);
        Button button2 = new Button(composite2, 8);
        button2.setText(DataTransferMessages.DataTransfer_deselectAll);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImportProjectWizardPage.this.projectsList.setCheckedElements(new Object[0]);
                ImportProjectWizardPage.this.setPageComplete(false);
            }
        });
        Dialog.applyDialogFont((Control)button2);
        this.setButtonLayoutData(button2);
        Button button3 = new Button(composite2, 8);
        button3.setText(DataTransferMessages.DataTransfer_refresh);
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ImportProjectWizardPage.this.projectFromDirectoryRadio.getSelection()) {
                    ImportProjectWizardPage.this.updateProjectsList(ImportProjectWizardPage.this.directoryPathField.getText().trim(), true);
                } else {
                    ImportProjectWizardPage.this.updateProjectsList(ImportProjectWizardPage.this.archivePathField.getText().trim(), true);
                }
            }
        });
        Dialog.applyDialogFont((Control)button3);
        this.setButtonLayoutData(button3);
    }

    private void createProjectsRoot(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        this.projectFromDirectoryRadio = new Button(composite2, 16);
        this.projectFromDirectoryRadio.setText(DataTransferMessages.WizardProjectsImportPage_RootSelectTitle);
        this.directoryPathField = new Combo(composite2, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = new PixelConverter((Control)this.directoryPathField).convertWidthInCharsToPixels(25);
        this.directoryPathField.setLayoutData((Object)gridData);
        this.browseDirectoriesButton = new Button(composite2, 8);
        this.browseDirectoriesButton.setText(DataTransferMessages.DataTransfer_browse);
        this.setButtonLayoutData(this.browseDirectoriesButton);
        this.projectFromArchiveRadio = new Button(composite2, 16);
        this.projectFromArchiveRadio.setText(DataTransferMessages.WizardProjectsImportPage_ArchiveSelectTitle);
        this.archivePathField = new Combo(composite2, 2048);
        GridData gridData2 = new GridData(768);
        gridData2.widthHint = new PixelConverter((Control)this.archivePathField).convertWidthInCharsToPixels(25);
        this.archivePathField.setLayoutData((Object)gridData2);
        this.browseArchivesButton = new Button(composite2, 8);
        this.browseArchivesButton.setText(DataTransferMessages.DataTransfer_browse);
        this.setButtonLayoutData(this.browseArchivesButton);
        this.projectFromDirectoryRadio.setSelection(true);
        this.archivePathField.setEnabled(false);
        this.browseArchivesButton.setEnabled(false);
        this.browseDirectoriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImportProjectWizardPage.this.handleLocationDirectoryButtonPressed();
            }
        });
        this.browseArchivesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImportProjectWizardPage.this.handleLocationArchiveButtonPressed();
            }
        });
        this.directoryPathField.addTraverseListener(traverseEvent -> {
            if (traverseEvent.detail == 4) {
                traverseEvent.doit = false;
                this.updateProjectsList(this.directoryPathField.getText().trim());
            }
        });
        this.directoryPathField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ImportProjectWizardPage.this.updateProjectsList(ImportProjectWizardPage.this.directoryPathField.getText().trim());
            }
        });
        this.directoryPathField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImportProjectWizardPage.this.updateProjectsList(ImportProjectWizardPage.this.directoryPathField.getText().trim());
            }
        });
        this.archivePathField.addTraverseListener(traverseEvent -> {
            if (traverseEvent.detail == 4) {
                traverseEvent.doit = false;
                this.updateProjectsList(this.archivePathField.getText().trim());
            }
        });
        this.archivePathField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ImportProjectWizardPage.this.updateProjectsList(ImportProjectWizardPage.this.archivePathField.getText().trim());
            }
        });
        this.archivePathField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImportProjectWizardPage.this.updateProjectsList(ImportProjectWizardPage.this.archivePathField.getText().trim());
            }
        });
        this.projectFromDirectoryRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImportProjectWizardPage.this.directoryRadioSelected();
            }
        });
        this.projectFromArchiveRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImportProjectWizardPage.this.archiveRadioSelected();
            }
        });
    }

    void archiveRadioSelected() {
        if (this.projectFromArchiveRadio.getSelection()) {
            this.directoryPathField.setEnabled(false);
            this.browseDirectoriesButton.setEnabled(false);
            this.archivePathField.setEnabled(true);
            this.browseArchivesButton.setEnabled(true);
            this.updateProjectsList(this.archivePathField.getText());
            this.archivePathField.setFocus();
            this.nestedProjectsCheckbox.setSelection(true);
            this.nestedProjectsCheckbox.setEnabled(false);
            this.copyCheckbox.setSelection(true);
            this.copyCheckbox.setEnabled(false);
        }
    }

    void directoryRadioSelected() {
        if (this.projectFromDirectoryRadio.getSelection()) {
            this.directoryPathField.setEnabled(true);
            this.browseDirectoriesButton.setEnabled(true);
            this.archivePathField.setEnabled(false);
            this.browseArchivesButton.setEnabled(false);
            this.updateProjectsList(this.directoryPathField.getText());
            this.directoryPathField.setFocus();
            this.nestedProjectsCheckbox.setEnabled(true);
            this.nestedProjectsCheckbox.setSelection(this.nestedProjects);
            this.copyCheckbox.setEnabled(true);
            this.copyCheckbox.setSelection(this.copyFiles);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && this.projectFromDirectoryRadio.getSelection()) {
            this.directoryPathField.setFocus();
        }
        if (bl && this.projectFromArchiveRadio.getSelection()) {
            this.archivePathField.setFocus();
        }
    }

    public void updateProjectsList(String string) {
        this.updateProjectsList(string, false);
    }

    void updateProjectsList(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            this.setMessage("Select a directory or an archive to search for existing GAMA projects.");
            this.selectedProjects = new ProjectRecord[0];
            this.projectsList.refresh(true);
            this.projectsList.setCheckedElements((Object[])this.selectedProjects);
            this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
            this.lastPath = string;
            return;
        }
        File file = new File(string);
        if (string.equals(this.lastPath) && !bl) {
            return;
        }
        boolean bl2 = this.projectFromDirectoryRadio.getSelection();
        try {
            this.getContainer().run(true, true, iProgressMonitor -> {
                iProgressMonitor.beginTask(DataTransferMessages.WizardProjectsImportPage_SearchingMessage, 100);
                this.selectedProjects = new ProjectRecord[0];
                ArrayList<ProjectRecord> arrayList = new ArrayList<ProjectRecord>();
                iProgressMonitor.worked(10);
                if (!bl2 && ArchiveFileManipulations.isTarFile((String)string)) {
                    TarFile tarFile = this.getSpecifiedTarSourceFile(string);
                    if (tarFile == null) {
                        return;
                    }
                    this.structureProvider = new TarLeveledStructureProvider(tarFile);
                    Object object = this.structureProvider.getRoot();
                    if (!this.collectProjectFilesFromProvider(arrayList, object, 0, iProgressMonitor)) {
                        return;
                    }
                    Iterator iterator = arrayList.iterator();
                    this.selectedProjects = new ProjectRecord[arrayList.size()];
                    int n = 0;
                    iProgressMonitor.worked(50);
                    iProgressMonitor.subTask(DataTransferMessages.WizardProjectsImportPage_ProcessingMessage);
                    while (iterator.hasNext()) {
                        this.selectedProjects[n++] = (ProjectRecord)iterator.next();
                    }
                } else if (!bl2 && ArchiveFileManipulations.isZipFile((String)string)) {
                    ZipFile zipFile = this.getSpecifiedZipSourceFile(string);
                    if (zipFile == null) {
                        return;
                    }
                    this.structureProvider = new ZipLeveledStructureProvider(zipFile);
                    Object object = this.structureProvider.getRoot();
                    if (!this.collectProjectFilesFromProvider(arrayList, object, 0, iProgressMonitor)) {
                        return;
                    }
                    Iterator iterator = arrayList.iterator();
                    this.selectedProjects = new ProjectRecord[arrayList.size()];
                    int n = 0;
                    iProgressMonitor.worked(50);
                    iProgressMonitor.subTask(DataTransferMessages.WizardProjectsImportPage_ProcessingMessage);
                    while (iterator.hasNext()) {
                        this.selectedProjects[n++] = (ProjectRecord)iterator.next();
                    }
                } else if (bl2 && file.isDirectory()) {
                    if (!this.collectProjectFilesFromDirectory(arrayList, file, null, iProgressMonitor)) {
                        return;
                    }
                    Iterator iterator = arrayList.iterator();
                    this.selectedProjects = new ProjectRecord[arrayList.size()];
                    int n = 0;
                    iProgressMonitor.worked(50);
                    iProgressMonitor.subTask(DataTransferMessages.WizardProjectsImportPage_ProcessingMessage);
                    while (iterator.hasNext()) {
                        File file2 = (File)iterator.next();
                        this.selectedProjects[n] = new ProjectRecord(file2);
                        ++n;
                    }
                } else {
                    iProgressMonitor.worked(60);
                }
                iProgressMonitor.done();
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            IDEWorkbenchPlugin.log((String)invocationTargetException.getMessage(), (Throwable)invocationTargetException);
        }
        catch (InterruptedException interruptedException) {}
        this.lastPath = string;
        this.updateProjectsStatus();
    }

    private void updateProjectsStatus() {
        this.projectsList.refresh(true);
        ProjectRecord[] projectRecordArray = this.getProjectRecords();
        boolean bl = false;
        boolean bl2 = false;
        ProjectRecord[] projectRecordArray2 = projectRecordArray;
        int n = projectRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectRecord projectRecord = projectRecordArray2[n2];
            if (projectRecord.hasConflicts || projectRecord.isInvalid) {
                this.projectsList.setGrayed((Object)projectRecord, true);
                bl |= projectRecord.hasConflicts;
                bl2 |= projectRecord.isInvalid;
            } else {
                this.projectsList.setChecked((Object)projectRecord, true);
            }
            ++n2;
        }
        if (bl && bl2) {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_projectsInWorkspaceAndInvalid, 2);
        } else if (bl) {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_projectsInWorkspace, 2);
        } else if (bl2) {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_projectsInvalid, 2);
        } else {
            this.setMessage("Select a directory or an archive to search for existing GAMA projects.");
        }
        this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
        if (this.selectedProjects.length == 0) {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_noProjectsToImport, 2);
        }
    }

    private ZipFile getSpecifiedZipSourceFile(String string) {
        if (string.length() == 0) {
            return null;
        }
        try {
            return new ZipFile(string);
        }
        catch (ZipException zipException) {
            this.displayErrorDialog(DataTransferMessages.ZipImport_badFormat);
        }
        catch (IOException iOException) {
            this.displayErrorDialog(DataTransferMessages.ZipImport_couldNotRead);
        }
        this.archivePathField.setFocus();
        return null;
    }

    private TarFile getSpecifiedTarSourceFile(String string) {
        if (string.length() == 0) {
            return null;
        }
        try {
            return new TarFile(string);
        }
        catch (TarException tarException) {
            this.displayErrorDialog(DataTransferMessages.TarImport_badFormat);
        }
        catch (IOException iOException) {
            this.displayErrorDialog(DataTransferMessages.ZipImport_couldNotRead);
        }
        this.archivePathField.setFocus();
        return null;
    }

    private boolean collectProjectFilesFromDirectory(Collection collection, File file, Set<String> set, IProgressMonitor iProgressMonitor) {
        File file2;
        Set<String> set2 = set;
        if (iProgressMonitor.isCanceled()) {
            return false;
        }
        iProgressMonitor.subTask(NLS.bind((String)DataTransferMessages.WizardProjectsImportPage_CheckingMessage, (Object)file.getPath()));
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return false;
        }
        if (set2 == null) {
            set2 = new HashSet<String>();
            try {
                set2.add(file.getCanonicalPath());
            }
            catch (IOException iOException) {
                StatusManager.getManager().handle(StatusUtil.newStatus((int)4, (String)iOException.getLocalizedMessage(), (Throwable)iOException));
            }
        }
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            file2 = fileArray2[n2];
            if (file2.isFile() && ".project".equals(file2.getName())) {
                collection.add(file2);
                if (!this.nestedProjects) {
                    return true;
                }
            }
            ++n2;
        }
        fileArray2 = fileArray;
        n = fileArray.length;
        n2 = 0;
        while (n2 < n) {
            block13: {
                file2 = fileArray2[n2];
                if (file2.isDirectory() && !METADATA_FOLDER.equals(file2.getName())) {
                    block12: {
                        try {
                            String string = file2.getCanonicalPath();
                            if (set2.add(string)) break block12;
                            break block13;
                        }
                        catch (IOException iOException) {
                            StatusManager.getManager().handle(StatusUtil.newStatus((int)4, (String)iOException.getLocalizedMessage(), (Throwable)iOException));
                        }
                    }
                    this.collectProjectFilesFromDirectory(collection, file2, set2, iProgressMonitor);
                }
            }
            ++n2;
        }
        return true;
    }

    private boolean collectProjectFilesFromProvider(Collection<ProjectRecord> collection, Object object, int n, IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor.isCanceled()) {
            return false;
        }
        iProgressMonitor.subTask(NLS.bind((String)DataTransferMessages.WizardProjectsImportPage_CheckingMessage, (Object)this.structureProvider.getLabel(object)));
        ArrayList arrayList = this.structureProvider.getChildren(object);
        if (arrayList == null) {
            arrayList = new ArrayList(1);
        }
        for (Object e : arrayList) {
            String string;
            if (this.structureProvider.isFolder(e)) {
                this.collectProjectFilesFromProvider(collection, e, n + 1, iProgressMonitor);
            }
            if (!".project".equals(string = this.structureProvider.getLabel(e))) continue;
            collection.add(new ProjectRecord(e, object, n));
        }
        return true;
    }

    protected void handleLocationDirectoryButtonPressed() {
        Object object;
        DirectoryDialog directoryDialog = new DirectoryDialog(this.directoryPathField.getShell(), 0x10000000);
        directoryDialog.setMessage(DataTransferMessages.WizardProjectsImportPage_SelectDialogTitle);
        String string = this.directoryPathField.getText().trim();
        if (string.length() == 0) {
            string = previouslyBrowsedDirectory;
        }
        if (string.length() == 0) {
            directoryDialog.setFilterPath(IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getLocation().toOSString());
        } else {
            object = new File(string);
            if (((File)object).exists()) {
                directoryDialog.setFilterPath(new Path(string).toOSString());
            }
        }
        object = directoryDialog.open();
        if (object != null) {
            previouslyBrowsedDirectory = object;
            this.directoryPathField.setText(previouslyBrowsedDirectory);
            this.updateProjectsList((String)object);
        }
    }

    protected void handleLocationArchiveButtonPressed() {
        Object object;
        FileDialog fileDialog = new FileDialog(this.archivePathField.getShell(), 0x10000000);
        fileDialog.setFilterExtensions(FILE_IMPORT_MASK);
        fileDialog.setText(DataTransferMessages.WizardProjectsImportPage_SelectArchiveDialogTitle);
        String string = this.archivePathField.getText().trim();
        if (string.length() == 0) {
            string = previouslyBrowsedArchive;
        }
        if (string.length() == 0) {
            fileDialog.setFilterPath(IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getLocation().toOSString());
        } else {
            object = new File(string).getParentFile();
            if (object != null && ((File)object).exists()) {
                fileDialog.setFilterPath(((File)object).toString());
            }
        }
        object = fileDialog.open();
        if (object != null) {
            previouslyBrowsedArchive = object;
            this.archivePathField.setText(previouslyBrowsedArchive);
            this.updateProjectsList((String)object);
        }
    }

    public boolean createProjects() {
        this.saveWidgetValues();
        final Object[] objectArray = this.projectsList.getCheckedElements();
        this.createdProjects = new ArrayList<IProject>();
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)objectArray.length);
                    if (iProgressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    MultiStatus multiStatus = new MultiStatus("org.eclipse.ui.ide", 1, DataTransferMessages.WizardProjectsImportPage_projectsInWorkspaceAndInvalid, null);
                    Object[] objectArray2 = objectArray;
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray2[n2];
                        multiStatus.add(ImportProjectWizardPage.this.createExistingProject((ProjectRecord)object, (IProgressMonitor)subMonitor.split(1)));
                        ++n2;
                    }
                    if (!multiStatus.isOK()) {
                        throw new InvocationTargetException(new CoreException((IStatus)multiStatus));
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        try {
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)workspaceModifyOperation);
            }
            catch (InterruptedException interruptedException) {
                ArchiveFileManipulations.closeStructureProvider((ILeveledImportStructureProvider)this.structureProvider, (Shell)this.getShell());
                return false;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                String string = DataTransferMessages.WizardExternalProjectImportPage_errorMessage;
                Object object = throwable instanceof CoreException ? ((CoreException)throwable).getStatus() : new Status(4, "org.eclipse.ui.ide", 1, string, throwable);
                this.updateProjectsStatus();
                ErrorDialog.openError((Shell)this.getShell(), (String)string, null, (IStatus)object);
                ArchiveFileManipulations.closeStructureProvider((ILeveledImportStructureProvider)this.structureProvider, (Shell)this.getShell());
                return false;
            }
        }
        finally {
            ArchiveFileManipulations.closeStructureProvider((ILeveledImportStructureProvider)this.structureProvider, (Shell)this.getShell());
        }
        return true;
    }

    public void performCancel() {
        ArchiveFileManipulations.closeStructureProvider((ILeveledImportStructureProvider)this.structureProvider, (Shell)this.getShell());
    }

    IStatus createExistingProject(ProjectRecord projectRecord, IProgressMonitor iProgressMonitor) throws InterruptedException {
        IStatus iStatus;
        IStatus iStatus2;
        Object object;
        Object object2;
        String string = projectRecord.getProjectName();
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IProject iProject = iWorkspace.getRoot().getProject(string);
        this.createdProjects.add(iProject);
        if (projectRecord.description == null) {
            projectRecord.description = iWorkspace.newProjectDescription(string);
            object2 = new Path(projectRecord.projectSystemFile.getAbsolutePath());
            if (Platform.getLocation().isPrefixOf((IPath)object2)) {
                projectRecord.description.setLocation(null);
            } else {
                projectRecord.description.setLocation((IPath)object2);
            }
        } else {
            projectRecord.description.setName(string);
        }
        if (projectRecord.projectArchiveFile != null) {
            object2 = this.structureProvider.getChildren(projectRecord.parent);
            this.structureProvider.setStrip(projectRecord.level);
            ImportOperation importOperation = new ImportOperation(iProject.getFullPath(), this.structureProvider.getRoot(), (IImportStructureProvider)this.structureProvider, (IOverwriteQuery)this, (List)object2);
            importOperation.setContext(this.getShell());
            try {
                importOperation.run(iProgressMonitor);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getCause() instanceof CoreException) {
                    return ((CoreException)invocationTargetException.getCause()).getStatus();
                }
                return new Status(4, "org.eclipse.ui.ide", 2, invocationTargetException.getCause().getLocalizedMessage(), (Throwable)invocationTargetException);
            }
            return importOperation.getStatus();
        }
        object2 = null;
        if (this.copyFiles && (object = projectRecord.description.getLocationURI()) != null) {
            iStatus2 = ResourcesPlugin.getWorkspace().validateProjectLocationURI(iProject, (URI)object);
            if (!iStatus2.isOK()) {
                return iStatus2;
            }
            object2 = new File((URI)object);
            iStatus = iWorkspace.newProjectDescription(string);
            iStatus.setBuildSpec(projectRecord.description.getBuildSpec());
            iStatus.setComment(projectRecord.description.getComment());
            iStatus.setNatureIds(projectRecord.description.getNatureIds());
            iStatus.setReferencedProjects(projectRecord.description.getReferencedProjects());
            projectRecord.description = iStatus;
        }
        try {
            try {
                object = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)DataTransferMessages.WizardProjectsImportPage_CreateProjectsTask, (int)100);
                iProject.create(projectRecord.description, (IProgressMonitor)object.split(30));
                iProject.open(128, (IProgressMonitor)object.split(70));
            }
            catch (CoreException coreException) {
                iStatus = coreException.getStatus();
                iProgressMonitor.done();
                return iStatus;
            }
        }
        finally {
            iProgressMonitor.done();
        }
        if (this.copyFiles && object2 != null) {
            object = FileSystemStructureProvider.INSTANCE.getChildren(object2);
            iStatus2 = new ImportOperation(iProject.getFullPath(), object2, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, (IOverwriteQuery)this, (List)object);
            iStatus2.setContext(this.getShell());
            iStatus2.setOverwriteResources(true);
            iStatus2.setCreateContainerStructure(false);
            try {
                iStatus2.run(iProgressMonitor);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getCause() instanceof CoreException) {
                    return ((CoreException)invocationTargetException.getCause()).getStatus();
                }
                return new Status(4, "org.eclipse.ui.ide", 2, invocationTargetException.getCause().getLocalizedMessage(), (Throwable)invocationTargetException);
            }
            return iStatus2.getStatus();
        }
        return Status.OK_STATUS;
    }

    public Button getProjectFromDirectoryRadio() {
        return this.projectFromDirectoryRadio;
    }

    public CheckboxTreeViewer getProjectsList() {
        return this.projectsList;
    }

    private IProject[] getProjectsInWorkspace() {
        return IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getProjects();
    }

    public ProjectRecord[] getProjectRecords() {
        ArrayList<ProjectRecord> arrayList = new ArrayList<ProjectRecord>();
        int n = 0;
        while (n < this.selectedProjects.length) {
            String string = this.selectedProjects[n].getProjectName();
            this.selectedProjects[n].hasConflicts = this.isProjectInWorkspacePath(string) && this.copyFiles || this.isProjectInWorkspace(string);
            arrayList.add(this.selectedProjects[n]);
            ++n;
        }
        return arrayList.toArray(new ProjectRecord[arrayList.size()]);
    }

    private boolean isProjectInWorkspacePath(String string) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IPath iPath = iWorkspace.getRoot().getLocation();
        IPath iPath2 = iPath.append(string);
        return iPath2.toFile().exists();
    }

    private boolean isProjectInWorkspace(String string) {
        IProject[] iProjectArray;
        if (string == null) {
            return false;
        }
        IProject[] iProjectArray2 = iProjectArray = this.getProjectsInWorkspace();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray2[n2];
            if (string.equals(iProject.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void restoreWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            this.restoreFromHistory(iDialogSettings, STORE_DIRECTORIES, this.directoryPathField);
            this.restoreFromHistory(iDialogSettings, STORE_ARCHIVES, this.archivePathField);
            this.nestedProjects = iDialogSettings.getBoolean(STORE_NESTED_PROJECTS);
            this.nestedProjectsCheckbox.setSelection(this.nestedProjects);
            this.copyFiles = iDialogSettings.getBoolean(STORE_COPY_PROJECT_ID);
            this.copyCheckbox.setSelection(this.copyFiles);
        }
        if (this.initialPath == null && iDialogSettings != null) {
            boolean bl = iDialogSettings.getBoolean(STORE_ARCHIVE_SELECTED);
            this.projectFromDirectoryRadio.setSelection(!bl);
            this.projectFromArchiveRadio.setSelection(bl);
            if (bl) {
                this.archiveRadioSelected();
            } else {
                this.directoryRadioSelected();
            }
        } else if (this.initialPath != null) {
            boolean bl = new File(this.initialPath).isDirectory();
            this.projectFromDirectoryRadio.setSelection(bl);
            this.projectFromArchiveRadio.setSelection(!bl);
            if (bl) {
                this.directoryPathField.setText(this.initialPath);
                this.directoryPathField.setSelection(new Point(this.initialPath.length(), this.initialPath.length()));
                this.directoryRadioSelected();
            } else {
                this.archivePathField.setText(this.initialPath);
                this.archivePathField.setSelection(new Point(this.initialPath.length(), this.initialPath.length()));
                this.archiveRadioSelected();
            }
        }
    }

    private void restoreFromHistory(IDialogSettings iDialogSettings, String string, Combo combo) {
        String[] stringArray = iDialogSettings.getArray(string);
        if (stringArray == null) {
            return;
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            combo.add(string2);
            ++n2;
        }
    }

    public void saveWidgetValues() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        if (iDialogSettings != null) {
            this.saveInHistory(iDialogSettings, STORE_DIRECTORIES, this.directoryPathField.getText());
            this.saveInHistory(iDialogSettings, STORE_ARCHIVES, this.archivePathField.getText());
            iDialogSettings.put(STORE_NESTED_PROJECTS, this.nestedProjectsCheckbox.getSelection());
            iDialogSettings.put(STORE_COPY_PROJECT_ID, this.copyCheckbox.getSelection());
            iDialogSettings.put(STORE_ARCHIVE_SELECTED, this.projectFromArchiveRadio.getSelection());
        }
    }

    private void saveInHistory(IDialogSettings iDialogSettings, String string, String string2) {
        String[] stringArray = iDialogSettings.getArray(string);
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        stringArray = this.addToHistory(stringArray, string2);
        iDialogSettings.put(string, stringArray);
    }

    public Button getCopyCheckbox() {
        return this.copyCheckbox;
    }

    public Button getNestedProjectsCheckbox() {
        return this.nestedProjectsCheckbox;
    }

    public void handleEvent(Event event) {
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    class ConflictingProjectFilter
    extends ViewerFilter {
        ConflictingProjectFilter() {
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            return !((ProjectRecord)object2).hasConflicts;
        }
    }

    final class ProjectLabelProvider
    extends LabelProvider
    implements IColorProvider {
        ProjectLabelProvider() {
        }

        public String getText(Object object) {
            return ((ProjectRecord)object).getProjectLabel();
        }

        public Color getBackground(Object object) {
            return null;
        }

        public Color getForeground(Object object) {
            ProjectRecord projectRecord = (ProjectRecord)object;
            if (projectRecord.hasConflicts || projectRecord.isInvalid) {
                return ImportProjectWizardPage.this.getShell().getDisplay().getSystemColor(15);
            }
            return null;
        }
    }

    public class ProjectRecord {
        File projectSystemFile;
        Object projectArchiveFile;
        String projectName;
        Object parent;
        int level;
        boolean hasConflicts;
        boolean isInvalid = false;
        IProjectDescription description;

        ProjectRecord(File file) {
            this.projectSystemFile = file;
            this.setProjectName();
        }

        ProjectRecord(Object object, Object object2, int n) {
            this.projectArchiveFile = object;
            this.parent = object2;
            this.level = n;
            this.setProjectName();
        }

        private void setProjectName() {
            try {
                Object object;
                if (this.projectArchiveFile != null) {
                    object = null;
                    Object var2_3 = null;
                    try (InputStream inputStream = ImportProjectWizardPage.this.structureProvider.getContents(this.projectArchiveFile);){
                        if (inputStream == null) {
                            if (this.projectArchiveFile instanceof ZipEntry) {
                                Path path = new Path(((ZipEntry)this.projectArchiveFile).getName());
                                this.projectName = path.segment(path.segmentCount() - 2);
                            } else if (this.projectArchiveFile instanceof TarEntry) {
                                Path path = new Path(((TarEntry)this.projectArchiveFile).getName());
                                this.projectName = path.segment(path.segmentCount() - 2);
                            }
                        } else {
                            this.description = IDEWorkbenchPlugin.getPluginWorkspace().loadProjectDescription(inputStream);
                            this.projectName = this.description.getName();
                        }
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        throw object;
                    }
                }
                if (this.projectName == null) {
                    object = new Path(this.projectSystemFile.getPath());
                    if (this.isDefaultLocation((IPath)object)) {
                        this.projectName = object.segment(object.segmentCount() - 2);
                        this.description = IDEWorkbenchPlugin.getPluginWorkspace().newProjectDescription(this.projectName);
                    } else {
                        this.description = IDEWorkbenchPlugin.getPluginWorkspace().loadProjectDescription((IPath)object);
                        this.projectName = this.description.getName();
                    }
                }
            }
            catch (CoreException coreException) {
                this.projectName = DataTransferMessages.WizardProjectsImportPage_invalidProjectName;
                this.isInvalid = true;
            }
            catch (IOException iOException) {
                this.projectName = DataTransferMessages.WizardProjectsImportPage_invalidProjectName;
                this.isInvalid = true;
            }
        }

        private boolean isDefaultLocation(IPath iPath) {
            if (iPath.segmentCount() < 2) {
                return false;
            }
            return iPath.removeLastSegments(2).toFile().equals(Platform.getLocation().toFile());
        }

        public String getProjectName() {
            return this.projectName;
        }

        public boolean isInvalidProject() {
            return this.isInvalid;
        }

        public String getProjectLabel() {
            String string = this.projectSystemFile == null ? ImportProjectWizardPage.this.structureProvider.getLabel(this.parent) : this.projectSystemFile.getParent();
            return NLS.bind((String)DataTransferMessages.WizardProjectsImportPage_projectLabel, (Object)this.projectName, (Object)string);
        }
    }
}

