/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class OpenResourceAction
extends WorkspaceAction
implements IResourceChangeListener {
    public static final String ID = "org.eclipse.ui.OpenResourceAction";

    public OpenResourceAction(IShellProvider iShellProvider) {
        super(iShellProvider, IDEWorkbenchMessages.OpenResourceAction_text);
        this.initAction();
    }

    private void initAction() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.open_resource_action_context");
        this.setToolTipText(IDEWorkbenchMessages.OpenResourceAction_toolTip);
        this.setId(ID);
    }

    int countClosedProjects() {
        IProject[] iProjectArray;
        int n = 0;
        IProject[] iProjectArray2 = iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n2 = iProjectArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IProject iProject = iProjectArray2[n3];
            if (!iProject.isOpen()) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    protected String getOperationMessage() {
        return IDEWorkbenchMessages.OpenResourceAction_operationMessage;
    }

    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.OpenResourceAction_problemMessage;
    }

    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.OpenResourceAction_dialogTitle;
    }

    boolean hasOtherClosedProjects() {
        int n = 0;
        for (IProject iProject : this.getSelectedResources()) {
            if (iProject.isOpen()) continue;
            ++n;
        }
        return n < this.countClosedProjects();
    }

    protected void invokeOperation(IResource iResource, IProgressMonitor iProgressMonitor) throws CoreException {
        ((IProject)iResource).open(iProgressMonitor);
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IResourceDelta iResourceDelta;
        List list = this.getSelectedResources();
        if (this.selectionIsOfType(4) && (iResourceDelta = iResourceChangeEvent.getDelta()) != null) {
            IResourceDelta[] iResourceDeltaArray;
            IResourceDelta[] iResourceDeltaArray2 = iResourceDeltaArray = iResourceDelta.getAffectedChildren(4);
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta iResourceDelta2 = iResourceDeltaArray2[n2];
                if ((iResourceDelta2.getFlags() & 0x4000) != 0 && list.contains(iResourceDelta2.getResource())) {
                    this.selectionChanged(this.getStructuredSelection());
                    return;
                }
                ++n2;
            }
        }
    }

    public void run() {
        try {
            this.runOpenWithReferences();
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    private void runOpenWithReferences() {
        final ArrayList arrayList = new ArrayList(this.getActionResources());
        WorkspaceJob workspaceJob = new WorkspaceJob(OpenResourceAction.removeMnemonics((String)this.getText())){
            private boolean openProjectReferences;
            private boolean hasPrompted;
            private boolean canceled;
            {
                super(string);
                this.openProjectReferences = true;
                this.hasPrompted = false;
                this.canceled = false;
            }

            private void doOpenWithReferences(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
                IProject iProject2;
                int n;
                int n2;
                IProject[] iProjectArray;
                if (!iProject.exists() || iProject.isOpen()) {
                    return;
                }
                iProject.open((IProgressMonitor)SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)1000));
                IProject[] iProjectArray2 = iProject.getReferencedProjects();
                if (!this.hasPrompted) {
                    this.openProjectReferences = false;
                    iProjectArray = iProjectArray2;
                    n2 = iProjectArray2.length;
                    n = 0;
                    while (n < n2) {
                        iProject2 = iProjectArray[n];
                        if (iProject2.exists() && !iProject2.isOpen()) {
                            this.openProjectReferences = true;
                            break;
                        }
                        ++n;
                    }
                    if (this.openProjectReferences && OpenResourceAction.this.hasOtherClosedProjects()) {
                        Display.getDefault().syncExec(() -> {
                            try {
                                this.openProjectReferences = true;
                            }
                            catch (OperationCanceledException operationCanceledException) {
                                this.canceled = true;
                            }
                            this.hasPrompted = true;
                        });
                        if (this.canceled) {
                            throw new OperationCanceledException();
                        }
                    }
                }
                if (this.openProjectReferences) {
                    iProjectArray = iProjectArray2;
                    n2 = iProjectArray2.length;
                    n = 0;
                    while (n < n2) {
                        iProject2 = iProjectArray[n];
                        this.doOpenWithReferences(iProject2, iProgressMonitor);
                        ++n;
                    }
                }
            }

            public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) throws CoreException {
                try {
                    iProgressMonitor.beginTask("", OpenResourceAction.this.countClosedProjects() * 1000);
                    iProgressMonitor.setTaskName(OpenResourceAction.this.getOperationMessage());
                    for (Object e : arrayList) {
                        this.doOpenWithReferences((IProject)e, iProgressMonitor);
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        workspaceJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        workspaceJob.setUser(true);
        workspaceJob.schedule();
    }

    protected boolean shouldPerformResourcePruning() {
        return false;
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        if (!this.selectionIsOfType(4)) {
            return false;
        }
        for (IProject iProject : this.getSelectedResources()) {
            if (iProject.isOpen()) continue;
            return true;
        }
        return false;
    }
}

