/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.wizards;

import com.google.common.collect.Maps;
import gama.ui.navigator.wizards.AbstractNewModelWizard;
import gama.ui.navigator.wizards.AbstractNewModelWizardPage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewFileWizardPage
extends AbstractNewModelWizardPage {
    Text descriptionText;
    Button yesButton;
    String templateName;
    Combo combo;

    public NewFileWizardPage(ISelection iSelection) {
        super(iSelection);
        this.setTitle("Model file");
        this.setDescription("This wizard creates a new model file.");
    }

    @Override
    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.createContainerSection(composite2);
        this.createLabel(composite2, "&Choose a template:");
        Composite composite3 = new Composite(composite2, 0);
        this.applyGridData((Control)composite3, 2);
        FillLayout fillLayout = new FillLayout();
        composite3.setLayout((Layout)fillLayout);
        HashMap<String, String> hashMap = new HashMap<String, String>(Maps.filterEntries(AbstractNewModelWizard.TEMPLATES, entry -> ((String)entry.getValue()).contains(".model.template")));
        this.addProjectTemplates(hashMap);
        this.combo = new Combo(composite3, 12);
        Object[] objectArray = hashMap.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        this.combo.setItems((String[])objectArray);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter((String[])objectArray, hashMap){
            private final /* synthetic */ String[] val$choices;
            private final /* synthetic */ HashMap val$templates;
            {
                this.val$choices = stringArray;
                this.val$templates = hashMap;
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewFileWizardPage.this.templateName = this.val$choices[NewFileWizardPage.this.combo.getSelectionIndex()];
                NewFileWizardPage.this.templatePath = (String)this.val$templates.get(NewFileWizardPage.this.templateName);
                NewFileWizardPage.this.updateStatus(null);
                NewFileWizardPage.this.dialogChanged();
                NewFileWizardPage.this.descriptionText.setText(NewFileWizardPage.this.templatePath.endsWith("resource") ? "Based on the internal " + NewFileWizardPage.this.templateName + " template." : "Based on the template at '" + NewFileWizardPage.this.templatePath + "'");
            }
        });
        this.combo.select(0);
        this.templateName = objectArray[0];
        this.templatePath = hashMap.get(this.templateName);
        this.createFileNameSection(composite2);
        this.createAuthorSection(composite2);
        this.createNameSection(composite2);
        this.createDocSection(composite2);
        this.createLabel(composite2, "&Model description:");
        this.descriptionText = new Text(composite2, 2882);
        this.descriptionText.setBounds(0, 0, 250, 100);
        this.descriptionText.setText(this.templatePath.endsWith("resource") ? "Based on the internal " + this.templateName + " template." : "Based on the template at '" + this.templatePath + "'");
        GridData gridData = new GridData(4, 4, true, false);
        gridData.heightHint = 100;
        gridData.verticalSpan = 4;
        gridData.horizontalSpan = 2;
        this.descriptionText.setLayoutData((Object)gridData);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)composite2);
    }

    private void addProjectTemplates(Map<String, String> map) {
        IContainer iContainer = this.findContainer();
        if (iContainer == null) {
            return;
        }
        IProject iProject = iContainer.getProject();
        if (iProject == null) {
            return;
        }
        IFolder iFolder = iProject.getFolder("templates");
        if (!iFolder.exists()) {
            return;
        }
        try {
            IResource[] iResourceArray = iFolder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource = iResourceArray[n2];
                String string = iResource.getName();
                if (string.contains(".template")) {
                    map.put(string.replaceAll(".template", ""), iResource.getProjectRelativePath().toString());
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    private void createDocSection(Composite composite) {
        this.createLabel(composite, "&Create a documentation template ?");
        Composite composite2 = new Composite(composite, 0);
        FillLayout fillLayout = new FillLayout();
        composite2.setLayout((Layout)fillLayout);
        this.applyGridData((Control)composite2, 2);
        this.yesButton = new Button(composite2, 16);
        this.yesButton.setText("Yes");
        Button button = new Button(composite2, 16);
        button.setText("No");
        button.setSelection(true);
        this.yesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewFileWizardPage.this.dialogChanged();
            }
        });
    }

    public String getDescription() {
        return this.descriptionText.getText();
    }

    @Override
    public boolean createDoc() {
        return this.yesButton.getSelection();
    }

    @Override
    public String getTemplateType() {
        return this.templateName;
    }

    @Override
    public String getExtension() {
        return ".gaml";
    }

    @Override
    public String gamlType() {
        return "Model";
    }
}

