/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.navigator.view;

import gama.ui.navigator.metadata.FileMetaDataProvider;
import gama.ui.navigator.view.contents.ResourceManager;
import gama.ui.navigator.view.contents.TopLevelFolder;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.PerformRefactoringOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.MoveResourcesDescriptor;
import org.eclipse.ltk.ui.refactoring.RefactoringUI;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.CopyProjectOperation;
import org.eclipse.ui.actions.MoveFilesAndFoldersOperation;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.ide.dialogs.ImportTypeDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.resources.ResourceDropAdapterAssistant;
import org.eclipse.ui.part.ResourceTransfer;

public class NavigatorResourceDropAssistant
extends ResourceDropAdapterAssistant {
    private static final IResource[] NO_RESOURCES = new IResource[0];
    private RefactoringStatus refactoringStatus;
    private IStatus returnStatus;

    public boolean isSupportedType(TransferData transferData) {
        return super.isSupportedType(transferData) || FileTransfer.getInstance().isSupportedType(transferData);
    }

    public IStatus validateDrop(Object object, int n, TransferData transferData) {
        Object object2;
        IResource iResource = ResourceManager.getResource(object);
        if (!(object instanceof TopLevelFolder)) {
            if (iResource == null) {
                return WorkbenchNavigatorPlugin.createStatus((int)1, (int)0, (String)WorkbenchNavigatorMessages.DropAdapter_targetMustBeResource, null);
            }
            if (!iResource.isAccessible()) {
                return WorkbenchNavigatorPlugin.createErrorStatus((int)0, (String)WorkbenchNavigatorMessages.DropAdapter_canNotDropIntoClosedProject, null);
            }
            object2 = this.getActualTarget(iResource);
            if (object2.getType() == 8) {
                return WorkbenchNavigatorPlugin.createErrorStatus((int)0, (String)WorkbenchNavigatorMessages.DropAdapter_resourcesCanNotBeSiblings, null);
            }
        }
        object2 = null;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferData)) {
            IResource[] iResourceArray = this.getSelectedResources();
            if (this.allProjects(iResourceArray) && object instanceof TopLevelFolder) {
                return Status.OK_STATUS;
            }
            if (this.anyProjects(iResourceArray)) {
                object2 = WorkbenchNavigatorMessages.DropAdapter_canNotDropProjectIntoProject;
            } else if (iResourceArray.length == 0) {
                object2 = WorkbenchNavigatorMessages.DropAdapter_dropOperationErrorOther;
            } else {
                Object object3 = n == 1 ? new CopyFilesAndFoldersOperation(this.getShell()) : new MoveFilesAndFoldersOperation(this.getShell());
                IContainer iContainer = this.getActualTarget(iResource);
                if (iContainer == null) {
                    object2 = "Not permitted";
                } else if (object3.validateDestination(iContainer, iResourceArray) != null) {
                    object3.setVirtualFolders(true);
                    object2 = object3.validateDestination(iContainer, iResourceArray);
                }
            }
        } else if (FileTransfer.getInstance().isSupportedType(transferData)) {
            String[] stringArray = (String[])FileTransfer.getInstance().nativeToJava(transferData);
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            CopyFilesAndFoldersOperation copyFilesAndFoldersOperation = new CopyFilesAndFoldersOperation(this.getShell());
            IContainer iContainer = this.getActualTarget(iResource);
            object2 = iContainer == null ? "Not permitted" : copyFilesAndFoldersOperation.validateImportDestination(iContainer, stringArray);
        }
        if (object2 != null) {
            return WorkbenchNavigatorPlugin.createErrorStatus((int)0, (String)object2, null);
        }
        return Status.OK_STATUS;
    }

    private boolean allProjects(IResource[] iResourceArray) {
        if (iResourceArray == null || iResourceArray.length == 0) {
            return false;
        }
        IResource[] iResourceArray2 = iResourceArray;
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource iResource = iResourceArray2[n2];
            if (iResource.getType() != 4) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean anyProjects(IResource[] iResourceArray) {
        if (iResourceArray == null || iResourceArray.length == 0) {
            return false;
        }
        IResource[] iResourceArray2 = iResourceArray;
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource iResource = iResourceArray2[n2];
            if (iResource.getType() == 4) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IStatus handleDrop(CommonDropAdapter commonDropAdapter, DropTargetEvent dropTargetEvent, Object object) {
        IResource iResource;
        IResource[] iResourceArray = null;
        IStatus iStatus = null;
        TransferData transferData = commonDropAdapter.getCurrentTransfer();
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferData)) {
            iResourceArray = this.getSelectedResources();
        } else if (ResourceTransfer.getInstance().isSupportedType(transferData)) {
            iResourceArray = (IResource[])dropTargetEvent.data;
        }
        if (object instanceof TopLevelFolder && this.allProjects(iResourceArray)) {
            iStatus = this.performProjectCopy(commonDropAdapter, this.getShell(), iResourceArray);
        } else {
            iResource = ResourceManager.getResource(object);
            if (iResource == null || dropTargetEvent.data == null) {
                return Status.CANCEL_STATUS;
            }
            if (FileTransfer.getInstance().isSupportedType(transferData)) {
                iStatus = this.performFileDrop(commonDropAdapter, dropTargetEvent.data);
            } else if (iResourceArray != null && iResourceArray.length > 0) {
                iStatus = commonDropAdapter.getCurrentOperation() == 1 || commonDropAdapter.getCurrentOperation() == 4 ? this.performResourceCopy(commonDropAdapter, this.getShell(), iResourceArray) : this.performResourceMove(commonDropAdapter, iResourceArray);
            }
        }
        this.openError(iStatus);
        iResource = ResourceManager.getResource(object);
        IContainer iContainer = this.getActualTarget(iResource);
        if (iContainer != null && iContainer.isAccessible()) {
            try {
                iContainer.refreshLocal(1, null);
            }
            catch (CoreException coreException) {}
        }
        return iStatus;
    }

    private IStatus performProjectCopy(CommonDropAdapter commonDropAdapter, Shell shell, IResource[] iResourceArray) {
        ResourceManager.setSelectedFolder(commonDropAdapter.getCurrentTarget());
        IResource[] iResourceArray2 = iResourceArray;
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource iResource = iResourceArray2[n2];
            CopyProjectOperation copyProjectOperation = new CopyProjectOperation(shell);
            copyProjectOperation.copyProject((IProject)iResource);
            ++n2;
        }
        return null;
    }

    public IStatus validatePluginTransferDrop(IStructuredSelection iStructuredSelection, Object object) {
        if (!ResourceManager.isResource(object)) {
            return WorkbenchNavigatorPlugin.createStatus((int)1, (int)0, (String)WorkbenchNavigatorMessages.DropAdapter_targetMustBeResource, null);
        }
        IResource iResource = ResourceManager.getResource(object);
        if (!iResource.isAccessible()) {
            return WorkbenchNavigatorPlugin.createErrorStatus((int)0, (String)WorkbenchNavigatorMessages.DropAdapter_canNotDropIntoClosedProject, null);
        }
        IContainer iContainer = this.getActualTarget(iResource);
        if (iContainer.getType() == 8) {
            return WorkbenchNavigatorPlugin.createErrorStatus((int)0, (String)WorkbenchNavigatorMessages.DropAdapter_resourcesCanNotBeSiblings, null);
        }
        IResource[] iResourceArray = this.getSelectedResources(iStructuredSelection);
        String string = null;
        if (iResourceArray.length == 0) {
            string = WorkbenchNavigatorMessages.DropAdapter_dropOperationErrorOther;
        } else {
            MoveFilesAndFoldersOperation moveFilesAndFoldersOperation = new MoveFilesAndFoldersOperation(this.getShell());
            string = moveFilesAndFoldersOperation.validateDestination(iContainer, iResourceArray);
        }
        if (string != null) {
            return WorkbenchNavigatorPlugin.createErrorStatus((int)0, (String)string, null);
        }
        return Status.OK_STATUS;
    }

    public IStatus handlePluginTransferDrop(IStructuredSelection iStructuredSelection, Object object) {
        IContainer iContainer = this.getActualTarget(ResourceManager.getResource(object));
        IResource[] iResourceArray = this.getSelectedResources(iStructuredSelection);
        MoveFilesAndFoldersOperation moveFilesAndFoldersOperation = new MoveFilesAndFoldersOperation(this.getShell());
        moveFilesAndFoldersOperation.copyResources(iResourceArray, iContainer);
        if (iContainer != null && iContainer.isAccessible()) {
            try {
                iContainer.refreshLocal(1, null);
            }
            catch (CoreException coreException) {}
        }
        return Status.OK_STATUS;
    }

    private IContainer getActualTarget(IResource iResource) {
        if (iResource == null) {
            return null;
        }
        if (iResource.getType() == 1) {
            return iResource.getParent();
        }
        return (IContainer)iResource;
    }

    private IResource[] getSelectedResources() {
        ISelection iSelection = LocalSelectionTransfer.getTransfer().getSelection();
        if (iSelection instanceof IStructuredSelection) {
            return this.getSelectedResources((IStructuredSelection)iSelection);
        }
        return NO_RESOURCES;
    }

    private IResource[] getSelectedResources(IStructuredSelection iStructuredSelection) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            IResource iResource = ResourceManager.getResource(iterator.next());
            if (iResource == null) continue;
            arrayList.add(iResource);
            if (!ResourceManager.isFile(iResource)) continue;
            arrayList.addAll(FileMetaDataProvider.getInstance().getSupportFilesOf((IFile)iResource));
        }
        return arrayList.toArray(new IResource[arrayList.size()]);
    }

    private IStatus performResourceCopy(CommonDropAdapter commonDropAdapter, Shell shell, IResource[] iResourceArray) {
        CopyFilesAndFoldersOperation copyFilesAndFoldersOperation;
        int n;
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 1, WorkbenchNavigatorMessages.DropAdapter_problemsMoving, null);
        this.mergeStatus(multiStatus, this.validateTarget(commonDropAdapter.getCurrentTarget(), commonDropAdapter.getCurrentTransfer(), commonDropAdapter.getCurrentOperation()));
        IContainer iContainer = this.getActualTarget(ResourceManager.getResource(commonDropAdapter.getCurrentTarget()));
        boolean bl = false;
        if (iContainer.isVirtual()) {
            bl = true;
            IResource[] iResourceArray2 = iResourceArray;
            int n2 = iResourceArray.length;
            n = 0;
            while (n < n2) {
                copyFilesAndFoldersOperation = iResourceArray2[n];
                if (copyFilesAndFoldersOperation.getType() != 1 && copyFilesAndFoldersOperation.getLocation() != null) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        copyFilesAndFoldersOperation = new CopyFilesAndFoldersOperation(shell);
        if (bl) {
            copyFilesAndFoldersOperation.setCreateLinks(true);
        } else {
            IPreferenceStore iPreferenceStore;
            String string;
            n = 1;
            IResource[] iResourceArray3 = iResourceArray;
            int n3 = iResourceArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IResource iResource = iResourceArray3[n4];
                if (!iResource.isVirtual() && !iResource.isLinked()) {
                    n = 0;
                    break;
                }
                ++n4;
            }
            if (n == 0 && "prompt".equals(string = (iPreferenceStore = IDEWorkbenchPlugin.getDefault().getPreferenceStore()).getString(iContainer.isVirtual() ? "IMPORT_FILES_AND_FOLDERS_VIRTUAL_FOLDER_MODE" : "IMPORT_FILES_AND_FOLDERS_MODE"))) {
                ImportTypeDialog importTypeDialog = new ImportTypeDialog(this.getShell(), commonDropAdapter.getCurrentOperation(), iResourceArray, iContainer);
                importTypeDialog.setResource((IResource)iContainer);
                if (importTypeDialog.open() != 0) {
                    return multiStatus;
                }
                if (importTypeDialog.getSelection() == 2) {
                    copyFilesAndFoldersOperation.setVirtualFolders(true);
                }
                if (importTypeDialog.getSelection() == 4) {
                    copyFilesAndFoldersOperation.setCreateLinks(true);
                }
                if (importTypeDialog.getVariable() != null) {
                    copyFilesAndFoldersOperation.setRelativeVariable(importTypeDialog.getVariable());
                }
            }
        }
        copyFilesAndFoldersOperation.copyResources(iResourceArray, iContainer);
        return multiStatus;
    }

    private IStatus performResourceMove(CommonDropAdapter commonDropAdapter, IResource[] refactoring) {
        CopyFilesAndFoldersOperation copyFilesAndFoldersOperation;
        Refactoring refactoring2;
        Refactoring refactoring3 = refactoring;
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 1, WorkbenchNavigatorMessages.DropAdapter_problemsMoving, null);
        this.mergeStatus(multiStatus, this.validateTarget(commonDropAdapter.getCurrentTarget(), commonDropAdapter.getCurrentTransfer(), commonDropAdapter.getCurrentOperation()));
        IContainer iContainer = this.getActualTarget(ResourceManager.getResource(commonDropAdapter.getCurrentTarget()));
        boolean bl = false;
        if (iContainer.isVirtual()) {
            bl = true;
            refactoring2 = refactoring3;
            int n = ((IResource[])refactoring2).length;
            int n2 = 0;
            while (n2 < n) {
                copyFilesAndFoldersOperation = refactoring2[n2];
                if (copyFilesAndFoldersOperation.isVirtual() || copyFilesAndFoldersOperation.isLinked()) {
                    bl = false;
                    break;
                }
                ++n2;
            }
        }
        if (bl) {
            copyFilesAndFoldersOperation = new CopyFilesAndFoldersOperation(this.getShell());
            copyFilesAndFoldersOperation.setCreateLinks(true);
            copyFilesAndFoldersOperation.copyResources((IResource[])refactoring3, iContainer);
        } else {
            copyFilesAndFoldersOperation = new ReadOnlyStateChecker(this.getShell(), WorkbenchNavigatorMessages.MoveResourceAction_title, WorkbenchNavigatorMessages.MoveResourceAction_checkMoveMessage);
            refactoring3 = copyFilesAndFoldersOperation.checkReadOnlyResources((IResource[])refactoring3);
            try {
                PerformRefactoringOperation performRefactoringOperation;
                int n;
                RefactoringContribution refactoringContribution = RefactoringCore.getRefactoringContribution((String)"org.eclipse.ltk.core.refactoring.move.resources");
                MoveResourcesDescriptor moveResourcesDescriptor = (MoveResourcesDescriptor)refactoringContribution.createDescriptor();
                moveResourcesDescriptor.setResourcesToMove((IResource[])refactoring3);
                moveResourcesDescriptor.setDestination(iContainer);
                this.refactoringStatus = new RefactoringStatus();
                refactoring2 = moveResourcesDescriptor.createRefactoring(this.refactoringStatus);
                this.returnStatus = null;
                IRunnableWithProgress iRunnableWithProgress = iProgressMonitor -> {
                    try {
                        this.refactoringStatus = refactoring2.checkAllConditions(iProgressMonitor);
                    }
                    catch (CoreException coreException) {
                        this.returnStatus = WorkbenchNavigatorPlugin.createErrorStatus((int)0, (String)coreException.getLocalizedMessage(), (Throwable)coreException);
                    }
                };
                if (this.returnStatus != null) {
                    return this.returnStatus;
                }
                try {
                    PlatformUI.getWorkbench().getProgressService().run(false, false, iRunnableWithProgress);
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
                catch (InvocationTargetException invocationTargetException) {
                    return WorkbenchNavigatorPlugin.createErrorStatus((int)0, (String)invocationTargetException.getLocalizedMessage(), (Throwable)invocationTargetException);
                }
                if (this.refactoringStatus.hasEntries() && (n = (performRefactoringOperation = RefactoringUI.createLightWeightStatusDialog((RefactoringStatus)this.refactoringStatus, (Shell)this.getShell(), (String)WorkbenchNavigatorMessages.MoveResourceAction_title)).open()) != 0) {
                    return Status.CANCEL_STATUS;
                }
                performRefactoringOperation = new PerformRefactoringOperation(refactoring2, 6);
                IWorkspaceRunnable iWorkspaceRunnable = iProgressMonitor -> performRefactoringOperation.run(iProgressMonitor);
                this.returnStatus = null;
                IRunnableWithProgress iRunnableWithProgress2 = iProgressMonitor -> {
                    try {
                        ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), 1, iProgressMonitor);
                    }
                    catch (CoreException coreException) {
                        this.returnStatus = WorkbenchNavigatorPlugin.createErrorStatus((int)0, (String)coreException.getLocalizedMessage(), (Throwable)coreException);
                    }
                };
                if (this.returnStatus != null) {
                    return this.returnStatus;
                }
                try {
                    PlatformUI.getWorkbench().getProgressService().run(false, false, iRunnableWithProgress2);
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
                catch (InvocationTargetException invocationTargetException) {
                    return WorkbenchNavigatorPlugin.createErrorStatus((int)0, (String)invocationTargetException.getLocalizedMessage(), (Throwable)invocationTargetException);
                }
            }
            catch (CoreException coreException) {
                return WorkbenchNavigatorPlugin.createErrorStatus((int)0, (String)coreException.getLocalizedMessage(), (Throwable)coreException);
            }
            catch (OperationCanceledException operationCanceledException) {}
        }
        return multiStatus;
    }

    private IStatus performFileDrop(CommonDropAdapter commonDropAdapter, Object object) {
        int n = commonDropAdapter.getCurrentOperation();
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, WorkbenchNavigatorMessages.DropAdapter_problemImporting, null);
        this.mergeStatus(multiStatus, this.validateTarget(commonDropAdapter.getCurrentTarget(), commonDropAdapter.getCurrentTransfer(), n));
        IContainer iContainer = this.getActualTarget(ResourceManager.getResource(commonDropAdapter.getCurrentTarget()));
        String[] stringArray = (String[])object;
        Display.getCurrent().asyncExec(() -> {
            this.getShell().forceActive();
            new CopyFilesAndFoldersOperation(this.getShell()).copyOrLinkFiles(stringArray, iContainer, n);
        });
        return multiStatus;
    }

    private IStatus validateTarget(Object object, TransferData transferData, int n) {
        if (!ResourceManager.isResource(object)) {
            return WorkbenchNavigatorPlugin.createInfoStatus((String)WorkbenchNavigatorMessages.DropAdapter_targetMustBeResource);
        }
        IResource iResource = ResourceManager.getResource(object);
        if (!iResource.isAccessible()) {
            return WorkbenchNavigatorPlugin.createErrorStatus((String)WorkbenchNavigatorMessages.DropAdapter_canNotDropIntoClosedProject);
        }
        IContainer iContainer = this.getActualTarget(iResource);
        if (iContainer.getType() == 8) {
            return WorkbenchNavigatorPlugin.createErrorStatus((String)WorkbenchNavigatorMessages.DropAdapter_resourcesCanNotBeSiblings);
        }
        String string = null;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferData)) {
            IResource[] iResourceArray = this.getSelectedResources();
            if (iResourceArray.length == 0) {
                string = WorkbenchNavigatorMessages.DropAdapter_dropOperationErrorOther;
            } else {
                Object object2 = n == 1 || n == 4 ? new CopyFilesAndFoldersOperation(this.getShell()) : new MoveFilesAndFoldersOperation(this.getShell());
                if (object2.validateDestination(iContainer, iResourceArray) != null) {
                    object2.setVirtualFolders(true);
                    string = object2.validateDestination(iContainer, iResourceArray);
                }
            }
        } else if (FileTransfer.getInstance().isSupportedType(transferData)) {
            String[] stringArray = (String[])FileTransfer.getInstance().nativeToJava(transferData);
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            CopyFilesAndFoldersOperation copyFilesAndFoldersOperation = new CopyFilesAndFoldersOperation(this.getShell());
            string = copyFilesAndFoldersOperation.validateImportDestination(iContainer, stringArray);
        }
        if (string != null) {
            return WorkbenchNavigatorPlugin.createErrorStatus((String)string);
        }
        return Status.OK_STATUS;
    }

    private void mergeStatus(MultiStatus multiStatus, IStatus iStatus) {
        if (!iStatus.isOK()) {
            multiStatus.merge(iStatus);
        }
    }

    private void openError(IStatus iStatus) {
        if (iStatus == null) {
            return;
        }
        String string = WorkbenchNavigatorMessages.DropAdapter_title;
        if (!iStatus.isMultiStatus()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)string, null, (IStatus)iStatus, (int)6);
            return;
        }
        IStatus[] iStatusArray = iStatus.getChildren();
        if (iStatusArray.length == 1) {
            ErrorDialog.openError((Shell)this.getShell(), (String)iStatus.getMessage(), null, (IStatus)iStatusArray[0], (int)6);
            return;
        }
        ErrorDialog.openError((Shell)this.getShell(), (String)string, null, (IStatus)iStatus, (int)6);
    }
}

